/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.PrimaryKey;
import org.jboss.dna.common.jdbc.model.api.PrimaryKeyColumn;
import org.jboss.dna.common.jdbc.model.spi.PrimaryKeyBean;

public class PrimaryKeyBeanTest
extends TestCase {
    private PrimaryKey bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new PrimaryKeyBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testGetColumns() {
        Set columns = this.bean.getColumns();
        PrimaryKeyBeanTest.assertNotNull((String)"Unable to get columns", (Object)columns);
        PrimaryKeyBeanTest.assertTrue((String)"Column set should be empty by default", (boolean)columns.isEmpty());
    }

    public void testAddColumn() {
        String COLUMN_NAME = "My column";
        PrimaryKeyColumn column = new DefaultModelFactory().createPrimaryKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        PrimaryKeyBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testDeleteColumn() {
        String COLUMN_NAME = "My column";
        PrimaryKeyColumn column = new DefaultModelFactory().createPrimaryKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        PrimaryKeyBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        this.bean.deleteColumn(column);
        PrimaryKeyBeanTest.assertTrue((String)"Column set should be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testFindColumnByName() {
        String COLUMN_NAME = "My column";
        PrimaryKeyColumn column = new DefaultModelFactory().createPrimaryKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        PrimaryKeyBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findColumnByName(COLUMN_NAME));
    }
}

