/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.Attribute;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.UserDefinedType;
import org.jboss.dna.common.jdbc.model.spi.UserDefinedTypeBean;

public class UserDefinedTypeBeanTest
extends TestCase {
    private UserDefinedType bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new UserDefinedTypeBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testSetClassName() {
        String className = "My class";
        this.bean.setClassName(className);
        UserDefinedTypeBeanTest.assertSame((String)"Unable to set class name", (Object)className, (Object)this.bean.getClassName());
    }

    public void testSetSqlType() {
        this.bean.setSqlType(SqlType.VARCHAR);
        UserDefinedTypeBeanTest.assertSame((String)"Unable to set SQL type", (Object)SqlType.VARCHAR, (Object)this.bean.getSqlType());
    }

    public void testSetBaseType() {
        this.bean.setBaseType(SqlType.VARCHAR);
        UserDefinedTypeBeanTest.assertSame((String)"Unable to set base type", (Object)SqlType.VARCHAR, (Object)this.bean.getBaseType());
    }

    public void testGetAttributes() {
        Set attributes = this.bean.getAttributes();
        UserDefinedTypeBeanTest.assertNotNull((String)"Unable to get attributes", (Object)attributes);
        UserDefinedTypeBeanTest.assertTrue((String)"Attribute set should be empty by default", (boolean)attributes.isEmpty());
    }

    public void testAddAttribute() {
        String NAME = "My name";
        Attribute a = new DefaultModelFactory().createAttribute();
        a.setName(NAME);
        this.bean.addAttribute(a);
        UserDefinedTypeBeanTest.assertFalse((String)"Attribute set should not be empty", (boolean)this.bean.getAttributes().isEmpty());
    }

    public void testDeleteAttribute() {
        String NAME = "My name";
        Attribute a = new DefaultModelFactory().createAttribute();
        a.setName(NAME);
        this.bean.addAttribute(a);
        UserDefinedTypeBeanTest.assertFalse((String)"Attribute set should not be empty", (boolean)this.bean.getAttributes().isEmpty());
        this.bean.deleteAttribute(a);
        UserDefinedTypeBeanTest.assertTrue((String)"Attribute set should be empty", (boolean)this.bean.getAttributes().isEmpty());
    }

    public void testFindAttributeByName() {
        String NAME = "My name";
        Attribute a = new DefaultModelFactory().createAttribute();
        a.setName(NAME);
        this.bean.addAttribute(a);
        UserDefinedTypeBeanTest.assertSame((String)"Unable to find attribute", (Object)a, (Object)this.bean.findAttributeByName(NAME));
    }

    public void testSetSuperType() {
        UserDefinedType st = new DefaultModelFactory().createUserDefinedType();
        this.bean.setSuperType(st);
        UserDefinedTypeBeanTest.assertSame((String)"Unable to set super type", (Object)st, (Object)this.bean.getSuperType());
    }
}

