/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.util;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.jboss.dna.common.jdbc.JdbcMetadataI18n;
import org.jboss.dna.common.jdbc.model.ModelFactory;
import org.jboss.dna.common.jdbc.model.api.Attribute;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifier;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifierScopeType;
import org.jboss.dna.common.jdbc.model.api.Catalog;
import org.jboss.dna.common.jdbc.model.api.ColumnPseudoType;
import org.jboss.dna.common.jdbc.model.api.Database;
import org.jboss.dna.common.jdbc.model.api.DatabaseMetaDataMethodException;
import org.jboss.dna.common.jdbc.model.api.ForeignKey;
import org.jboss.dna.common.jdbc.model.api.ForeignKeyColumn;
import org.jboss.dna.common.jdbc.model.api.Index;
import org.jboss.dna.common.jdbc.model.api.IndexColumn;
import org.jboss.dna.common.jdbc.model.api.IndexType;
import org.jboss.dna.common.jdbc.model.api.KeyDeferrabilityType;
import org.jboss.dna.common.jdbc.model.api.KeyModifyRuleType;
import org.jboss.dna.common.jdbc.model.api.NullabilityType;
import org.jboss.dna.common.jdbc.model.api.Parameter;
import org.jboss.dna.common.jdbc.model.api.ParameterIoType;
import org.jboss.dna.common.jdbc.model.api.PrimaryKey;
import org.jboss.dna.common.jdbc.model.api.PrimaryKeyColumn;
import org.jboss.dna.common.jdbc.model.api.Privilege;
import org.jboss.dna.common.jdbc.model.api.PrivilegeType;
import org.jboss.dna.common.jdbc.model.api.Reference;
import org.jboss.dna.common.jdbc.model.api.ResultSetConcurrencyType;
import org.jboss.dna.common.jdbc.model.api.ResultSetHoldabilityType;
import org.jboss.dna.common.jdbc.model.api.ResultSetType;
import org.jboss.dna.common.jdbc.model.api.SQLStateType;
import org.jboss.dna.common.jdbc.model.api.Schema;
import org.jboss.dna.common.jdbc.model.api.SearchabilityType;
import org.jboss.dna.common.jdbc.model.api.SortSequenceType;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.SqlTypeInfo;
import org.jboss.dna.common.jdbc.model.api.StoredProcedure;
import org.jboss.dna.common.jdbc.model.api.StoredProcedureResultType;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.api.TableColumn;
import org.jboss.dna.common.jdbc.model.api.TableType;
import org.jboss.dna.common.jdbc.model.api.TransactionIsolationLevelType;
import org.jboss.dna.common.jdbc.model.api.UserDefinedType;
import org.jboss.dna.common.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtil {
    private static Logger log = Logger.getLogger(DatabaseUtil.class);
    private static String standardUserDefinedTypes = "JAVA_OBJECT,STRUCT,DISTINCT";
    private static Map<String, Integer> standardUserDefinedTypesMapping = new HashMap<String, Integer>();

    private DatabaseUtil() {
    }

    public static String getStandardUserDefinedTypes() {
        return standardUserDefinedTypes;
    }

    public static int[] getUserDefinedTypes(String userDefinedTypes) {
        String[] userDefinedTypesStringArray = userDefinedTypes == null ? null : userDefinedTypes.split(",");
        int[] userDefinedTypesArray = new int[userDefinedTypesStringArray.length];
        for (int i = 0; i < userDefinedTypesStringArray.length; ++i) {
            Integer udtType = standardUserDefinedTypesMapping.get(userDefinedTypesStringArray[i]);
            userDefinedTypesArray[i] = udtType == null ? 0 : udtType;
        }
        return userDefinedTypesArray;
    }

    public static Boolean getBoolean(ResultSet resultSet, String columnName) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        boolean value = resultSet.getBoolean(columnName);
        return resultSet.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Boolean getBoolean(ResultSet resultSet, String columnName, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        boolean value = false;
        try {
            value = resultSet.getBoolean(columnName);
            return resultSet.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnName, e.getMessage()});
            return null;
        }
    }

    public static Boolean getBoolean(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        boolean value = resultSet.getBoolean(columnIndex);
        return resultSet.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Boolean getBoolean(ResultSet resultSet, int columnIndex, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        boolean value = false;
        try {
            value = resultSet.getBoolean(columnIndex);
            return resultSet.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnIndex, e.getMessage()});
            return null;
        }
    }

    public static Integer getInteger(ResultSet resultSet, String columnName) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        int value = resultSet.getInt(columnName);
        return resultSet.wasNull() ? null : new Integer(value);
    }

    public static Integer getInteger(ResultSet resultSet, String columnName, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        int value = 0;
        try {
            value = resultSet.getInt(columnName);
            return resultSet.wasNull() ? null : new Integer(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnName, e.getMessage()});
            return null;
        }
    }

    public static Integer getInteger(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        int value = resultSet.getInt(columnIndex);
        return resultSet.wasNull() ? null : new Integer(value);
    }

    public static Integer getInteger(ResultSet resultSet, int columnIndex, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        int value = 0;
        try {
            value = resultSet.getInt(columnIndex);
            return resultSet.wasNull() ? null : new Integer(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnIndex, e.getMessage()});
            return null;
        }
    }

    public static Long getLong(ResultSet resultSet, String columnName) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        long value = resultSet.getLong(columnName);
        return resultSet.wasNull() ? null : new Long(value);
    }

    public static Long getLong(ResultSet resultSet, String columnName, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        long value = 0L;
        try {
            value = resultSet.getLong(columnName);
            return resultSet.wasNull() ? null : new Long(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnName, e.getMessage()});
            return null;
        }
    }

    public static Long getLong(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        long value = resultSet.getLong(columnIndex);
        return resultSet.wasNull() ? null : new Long(value);
    }

    public static Long getLong(ResultSet resultSet, int columnIndex, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        long value = 0L;
        try {
            value = resultSet.getLong(columnIndex);
            return resultSet.wasNull() ? null : new Long(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnIndex, e.getMessage()});
            return null;
        }
    }

    public static Double getDouble(ResultSet resultSet, String columnName) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        double value = resultSet.getDouble(columnName);
        return resultSet.wasNull() ? null : new Double(value);
    }

    public static Double getDouble(ResultSet resultSet, String columnName, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        double value = 0.0;
        try {
            value = resultSet.getLong(columnName);
            return resultSet.wasNull() ? null : new Double(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnName, e.getMessage()});
            return null;
        }
    }

    public static Double getDouble(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        double value = resultSet.getDouble(columnIndex);
        return resultSet.wasNull() ? null : new Double(value);
    }

    public static Double getDouble(ResultSet resultSet, int columnIndex, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        double value = 0.0;
        try {
            value = resultSet.getLong(columnIndex);
            return resultSet.wasNull() ? null : new Double(value);
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnIndex, e.getMessage()});
            return null;
        }
    }

    public static String getString(ResultSet resultSet, String columnName) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        String value = resultSet.getString(columnName);
        return resultSet.wasNull() ? null : value;
    }

    public static String getString(ResultSet resultSet, String columnName, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        String value = null;
        try {
            value = resultSet.getString(columnName);
            return resultSet.wasNull() ? null : value;
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnName, e.getMessage()});
            return null;
        }
    }

    public static String getString(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        String value = resultSet.getString(columnIndex);
        return resultSet.wasNull() ? null : value;
    }

    public static String getString(ResultSet resultSet, int columnIndex, boolean failOnError) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        String value = null;
        try {
            value = resultSet.getString(columnIndex);
            return resultSet.wasNull() ? null : value;
        }
        catch (SQLException e) {
            if (failOnError) {
                throw e;
            }
            log.error(JdbcMetadataI18n.unableToGetValueFromColumn, new Object[]{columnIndex, e.getMessage()});
            return null;
        }
    }

    public static BestRowIdentifierScopeType getBestRowIdentifierScopeType(Integer type) {
        if (type == null) {
            return null;
        }
        for (BestRowIdentifierScopeType sType : BestRowIdentifierScopeType.values()) {
            if (sType.getScope() != type.intValue()) continue;
            return sType;
        }
        log.debug(String.format("[%s] Unknown best row identifier scope type %d", "getBestRowIdentifierScopeType", type), new Object[0]);
        return null;
    }

    public static ColumnPseudoType getColumnPseudoType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ColumnPseudoType pType : ColumnPseudoType.values()) {
            if (pType.getType() != type.intValue()) continue;
            return pType;
        }
        log.debug(String.format("[%s] Unknown column pseudo type %d", "getColumnPseudoType", type), new Object[0]);
        return null;
    }

    public static IndexType getIndexType(Integer type) {
        if (type == null) {
            return null;
        }
        for (IndexType iType : IndexType.values()) {
            if (iType.getType() != type.intValue()) continue;
            return iType;
        }
        log.debug(String.format("[%s] Unknown index type %d", "getKeyDeferrabilityType", type), new Object[0]);
        return null;
    }

    public static KeyDeferrabilityType getKeyDeferrabilityType(Integer type) {
        if (type == null) {
            return null;
        }
        for (KeyDeferrabilityType dType : KeyDeferrabilityType.values()) {
            if (dType.getDeferrability() != type.intValue()) continue;
            return dType;
        }
        log.debug(String.format("[%s] Unknown key deferrability type %d", "getKeyDeferrabilityType", type), new Object[0]);
        return null;
    }

    public static KeyModifyRuleType getKeyModifyRuleType(Integer type) {
        if (type == null) {
            return null;
        }
        for (KeyModifyRuleType rType : KeyModifyRuleType.values()) {
            if (rType.getRule() != type.intValue()) continue;
            return rType;
        }
        log.debug(String.format("[%s] Unknown key modify rule type %d", "getKeyModifyRuleType", type), new Object[0]);
        return null;
    }

    public static NullabilityType getNullabilityType(Integer type) {
        if (type == null) {
            return null;
        }
        for (NullabilityType nType : NullabilityType.values()) {
            if (nType.getNullability() != type.intValue()) continue;
            return nType;
        }
        log.debug(String.format("[%s] Unknown nullability type %d", "getNullabilityType", type), new Object[0]);
        return null;
    }

    public static ParameterIoType getParameterIoType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ParameterIoType ioType : ParameterIoType.values()) {
            if (ioType.getType() != type.intValue()) continue;
            return ioType;
        }
        log.debug(String.format("[%s] Unknown parameter I/O type %d", "getParameterIoType", type), new Object[0]);
        return null;
    }

    public static PrivilegeType getPrivilegeType(String type) {
        if (type == null) {
            return null;
        }
        for (PrivilegeType pType : PrivilegeType.values()) {
            if (!pType.getType().equals(type)) continue;
            return pType;
        }
        log.debug(String.format("[%s] Unknown privilege type %s", "getPrivilegeType", type), new Object[0]);
        return null;
    }

    public static ResultSetConcurrencyType getResultSetConcurrencyType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ResultSetConcurrencyType cType : ResultSetConcurrencyType.values()) {
            if (cType.getConcurrency() != type.intValue()) continue;
            return cType;
        }
        log.debug(String.format("[%s] Unknown result set concurrency type %d", "getResultSetConcurrencyType", type), new Object[0]);
        return null;
    }

    public static ResultSetHoldabilityType getResultSetHoldabilityType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ResultSetHoldabilityType hType : ResultSetHoldabilityType.values()) {
            if (hType.getHoldability() != type.intValue()) continue;
            return hType;
        }
        log.debug(String.format("[%s] Unknown result set holdability type %d", "getResultSetHoldabilityType", type), new Object[0]);
        return null;
    }

    public static ResultSetType getResultSetType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ResultSetType rsType : ResultSetType.values()) {
            if (rsType.getType() != type.intValue()) continue;
            return rsType;
        }
        log.debug(String.format("[%s] Unknown result set type %d", "getResultSetType", type), new Object[0]);
        return null;
    }

    public static SearchabilityType getSearchabilityType(Integer type) {
        if (type == null) {
            return null;
        }
        for (SearchabilityType sType : SearchabilityType.values()) {
            if (sType.getSearchability() != type.intValue()) continue;
            return sType;
        }
        log.debug(String.format("[%s] Unknown serachability type %d", "getSearchabilityType", type), new Object[0]);
        return null;
    }

    public static SortSequenceType getSortSequenceType(String type) {
        if (type == null) {
            return null;
        }
        for (SortSequenceType sType : SortSequenceType.values()) {
            if (sType.getType() == null || !sType.getType().equals(type)) continue;
            return sType;
        }
        log.debug(String.format("[%s] Unknown sort sequence type %s", "getSortSequenceType", type), new Object[0]);
        return null;
    }

    public static SQLStateType getSqlStateType(Integer type) {
        if (type == null) {
            return null;
        }
        for (SQLStateType stateType : SQLStateType.values()) {
            if (stateType.getState() != type.intValue()) continue;
            return stateType;
        }
        log.debug(String.format("[%s] Unknown SQL state type %d", "getSqlStateType", type), new Object[0]);
        return null;
    }

    public static SqlType getSqlType(Integer type) {
        if (type == null) {
            return null;
        }
        for (SqlType sqlType : SqlType.values()) {
            if (sqlType.getType() != type.intValue()) continue;
            return sqlType;
        }
        log.debug(String.format("[%s] Unknown SQL Type %d", "getSqlType", type), new Object[0]);
        return null;
    }

    public static StoredProcedureResultType getStoredProcedureResultType(Integer type) {
        if (type == null) {
            return null;
        }
        for (StoredProcedureResultType spResultType : StoredProcedureResultType.values()) {
            if (spResultType.getType() != type.intValue()) continue;
            return spResultType;
        }
        log.debug(String.format("[%s] Unknown stored procedure result type %d", "getStoredProcedureResultType", type), new Object[0]);
        return null;
    }

    public static TransactionIsolationLevelType getTransactionIsolationLevelType(Integer type) {
        if (type == null) {
            return null;
        }
        for (TransactionIsolationLevelType txType : TransactionIsolationLevelType.values()) {
            if (txType.getLevel() != type.intValue()) continue;
            return txType;
        }
        log.debug(String.format("[%s] Unknown transaction isolation level type %d", "getTransactionIsolationLevelType", type), new Object[0]);
        return null;
    }

    public static Catalog populateCatalog(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String catalogName = DatabaseUtil.getString(resultSet, "TABLE_CAT", false);
        Catalog catalog = factory.createCatalog();
        catalog.setName(catalogName);
        database.addCatalog(catalog);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The catalog '%s' has been added.", database.getName(), catalogName), new Object[0]);
        }
        return catalog;
    }

    public static Schema populateSchema(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String schemaName = DatabaseUtil.getString(resultSet, "TABLE_SCHEM", false);
        String catalogName = DatabaseUtil.getString(resultSet, "TABLE_CATALOG", false);
        Schema schema = factory.createSchema();
        schema.setName(schemaName);
        if (catalogName != null) {
            Catalog catalog = database.findCatalogByName(catalogName);
            schema.setCatalog(catalog);
        }
        database.addSchema(schema);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The schema '%s' has been added.", database.getName(), schemaName), new Object[0]);
        }
        return schema;
    }

    public static TableType populateTableType(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String tableTypeName = DatabaseUtil.getString(resultSet, "TABLE_TYPE", false);
        TableType tableType = factory.createTableType();
        tableType.setName(tableTypeName);
        database.addTableType(tableType);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table type '%s' has been added.", database.getName(), tableType), new Object[0]);
        }
        return tableType;
    }

    public static StoredProcedure populateStoredProcedure(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String procedureCatalog = DatabaseUtil.getString(resultSet, "PROCEDURE_CAT", false);
        String procedureSchema = DatabaseUtil.getString(resultSet, "PROCEDURE_SCHEM", false);
        String procedureName = DatabaseUtil.getString(resultSet, "PROCEDURE_NAME", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        Integer procedureType = DatabaseUtil.getInteger(resultSet, "PROCEDURE_TYPE", false);
        StoredProcedure sp = factory.createStoredProcedure();
        sp.setName(procedureName);
        sp.setRemarks(remarks);
        if (procedureCatalog != null && procedureCatalog.trim().length() != 0) {
            Catalog catalog = database.findCatalogByName(procedureCatalog);
            sp.setCatalog(catalog);
            if (catalog == null) {
                traceLog.debug(String.format("[Database %s] Unable to find catalog '%4$s' for the procedure %s (schema %s, catalog %s)", database.getName(), procedureName, procedureSchema, procedureCatalog), new Object[0]);
            }
            if (failOnError && catalog == null) {
                throw new DatabaseMetaDataMethodException("Catalog name shall be provided", "populateStoredProcedure");
            }
        }
        if (procedureSchema != null && procedureSchema.trim().length() != 0) {
            Schema schema = database.findSchemaByName(procedureCatalog, procedureSchema);
            sp.setSchema(schema);
            if (schema == null) {
                traceLog.debug(String.format("[Database %s] Unable to find schema '%3$s' for the procedure %s (schema %s, catalog %s)", database.getName(), procedureName, procedureSchema, procedureCatalog), new Object[0]);
            }
            if (failOnError && schema == null) {
                throw new DatabaseMetaDataMethodException("Schema name shall be provided", "populateStoredProcedure");
            }
        }
        sp.setResultType(DatabaseUtil.getStoredProcedureResultType(procedureType));
        database.addStoredProcedure(sp);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The Stored procedure '%s' (schema %s, catalog %s) has been added.", database.getName(), procedureName, procedureSchema, procedureCatalog), new Object[0]);
        }
        return sp;
    }

    public static Parameter populateStoredProcedureParameter(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, StoredProcedure storedProcedure, int ordinalPosition) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        String procedureCatalog = storedProcedure.getCatalog() == null ? null : storedProcedure.getCatalog().getName();
        String procedureSchema = storedProcedure.getSchema() == null ? null : storedProcedure.getSchema().getName();
        String procedureName = storedProcedure.getName();
        String parameterName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
        Integer parameterType = DatabaseUtil.getInteger(resultSet, "COLUMN_TYPE", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        Integer precision = DatabaseUtil.getInteger(resultSet, "PRECISION", false);
        Integer length = DatabaseUtil.getInteger(resultSet, "LENGTH", false);
        Integer scale = DatabaseUtil.getInteger(resultSet, "SCALE", false);
        Integer radix = DatabaseUtil.getInteger(resultSet, "RADIX", false);
        Integer nullableType = DatabaseUtil.getInteger(resultSet, "NULLABLE", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        Parameter parameter = factory.createParameter();
        parameter.setName(parameterName);
        parameter.setRemarks(remarks);
        parameter.setOwner(storedProcedure);
        parameter.setNullabilityType(DatabaseUtil.getNullabilityType(nullableType));
        parameter.setSqlType(DatabaseUtil.getSqlType(dataType));
        parameter.setTypeName(typeName);
        parameter.setSize(length);
        parameter.setPrecision(precision);
        parameter.setRadix(radix);
        parameter.setDefaultValue(null);
        parameter.setOrdinalPosition(ordinalPosition);
        parameter.setCharOctetLength(null);
        parameter.setIoType(DatabaseUtil.getParameterIoType(parameterType));
        parameter.setScale(scale);
        storedProcedure.addParameter(parameter);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The Stored procedure '%s' (schema %s, catalog %s) parameter %s has been added.", database.getName(), procedureName, procedureSchema, procedureCatalog, parameterName), new Object[0]);
        }
        return parameter;
    }

    public static Table populateTable(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String tableCatalog = DatabaseUtil.getString(resultSet, "TABLE_CAT", false);
        String tableSchema = DatabaseUtil.getString(resultSet, "TABLE_SCHEM", false);
        String tableName = DatabaseUtil.getString(resultSet, "TABLE_NAME", false);
        String tableTypeName = DatabaseUtil.getString(resultSet, "TABLE_TYPE", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        String typeCatalogName = DatabaseUtil.getString(resultSet, "TYPE_CAT", false);
        String typeSchemaName = DatabaseUtil.getString(resultSet, "TYPE_SCHEM", false);
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        String selfRefColumnName = DatabaseUtil.getString(resultSet, "SELF_REFERENCING_COL_NAME", false);
        String refGeneration = DatabaseUtil.getString(resultSet, "REF_GENERATION", false);
        Table table = factory.createTable();
        table.setName(tableName);
        table.setRemarks(remarks);
        if (tableCatalog != null && tableCatalog.trim().length() != 0) {
            Catalog catalog = database.findCatalogByName(tableCatalog);
            table.setCatalog(catalog);
            if (catalog == null) {
                traceLog.debug(String.format("[Database %s] Unable to find catalog '%4$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, tableSchema, tableCatalog), new Object[0]);
            }
            if (failOnError) {
                throw new DatabaseMetaDataMethodException("Catalog name shall be provided", "populateTable");
            }
        }
        if (tableSchema != null && tableSchema.trim().length() != 0) {
            Schema schema = database.findSchemaByName(tableCatalog, tableSchema);
            table.setSchema(schema);
            if (schema == null) {
                traceLog.debug(String.format("[Database %s] Unable to find schema '%3$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, tableSchema, tableCatalog), new Object[0]);
            }
            if (failOnError) {
                throw new DatabaseMetaDataMethodException("Table name shall be provided", "populateTable");
            }
        }
        if (tableTypeName != null) {
            TableType tableType = factory.createTableType();
            tableType.setName(tableTypeName);
            table.setTableType(tableType);
        }
        if (typeCatalogName != null && typeCatalogName.trim().length() != 0) {
            Catalog typeCatalog = database.findCatalogByName(typeCatalogName);
            table.setTypeCatalog(typeCatalog);
            if (typeCatalog == null) {
                traceLog.debug(String.format("[Database %s] Unable to find catalog '%4$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, tableSchema, typeCatalogName), new Object[0]);
            }
        }
        if (typeSchemaName != null && typeSchemaName.trim().length() != 0) {
            Schema typeSchema = database.findSchemaByName(typeCatalogName, typeSchemaName);
            table.setTypeSchema(typeSchema);
            if (typeSchema == null) {
                traceLog.debug(String.format("[Database %s] Unable to find schema '%3$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, typeSchemaName, typeCatalogName), new Object[0]);
            }
            if (failOnError && typeSchema == null) {
                throw new DatabaseMetaDataMethodException("Schema name shall be provided", "populateTable");
            }
        }
        table.setTypeName(typeName);
        table.setSelfReferencingColumnName(selfRefColumnName);
        table.setReferenceGeneration(refGeneration);
        database.addTable(table);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) has been added.", database.getName(), tableName, tableSchema, tableCatalog), new Object[0]);
        }
        return table;
    }

    public static TableColumn populateTableColumn(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        String columnName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        Integer size = DatabaseUtil.getInteger(resultSet, "COLUMN_SIZE", false);
        Integer precision = DatabaseUtil.getInteger(resultSet, "DECIMAL_DIGITS", false);
        Integer radix = DatabaseUtil.getInteger(resultSet, "NUM_PREC_RADIX", false);
        Integer nullableType = DatabaseUtil.getInteger(resultSet, "NULLABLE", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        String defaultValue = DatabaseUtil.getString(resultSet, "COLUMN_DEF", false);
        Integer charOctetLength = DatabaseUtil.getInteger(resultSet, "CHAR_OCTET_LENGTH", false);
        Integer ordinalPosition = DatabaseUtil.getInteger(resultSet, "ORDINAL_POSITION", false);
        String scopeCatalog = DatabaseUtil.getString(resultSet, "SCOPE_CATLOG", false);
        String scopeSchema = DatabaseUtil.getString(resultSet, "SCOPE_SCHEMA", false);
        String scopeTable = DatabaseUtil.getString(resultSet, "SCOPE_TABLE", false);
        Integer sourceDataType = DatabaseUtil.getInteger(resultSet, "SOURCE_DATA_TYPE", false);
        TableColumn column = factory.createTableColumn();
        column.setName(columnName);
        column.setRemarks(remarks);
        column.setOwner(table);
        column.setNullabilityType(DatabaseUtil.getNullabilityType(nullableType));
        column.setSqlType(DatabaseUtil.getSqlType(dataType));
        column.setTypeName(typeName);
        column.setSize(size);
        column.setPrecision(precision);
        column.setRadix(radix);
        column.setDefaultValue(defaultValue);
        column.setOrdinalPosition(ordinalPosition);
        column.setCharOctetLength(charOctetLength);
        column.setPseudoType(ColumnPseudoType.NOT_PSEUDO);
        if (scopeCatalog != null || scopeSchema != null || scopeTable != null || sourceDataType != null) {
            Reference reference = factory.createReference();
            reference.setSourceDataType(DatabaseUtil.getSqlType(sourceDataType));
            reference.setSourceTable(database.findTableByName(scopeCatalog, scopeSchema, scopeTable));
            column.setReference(reference);
        }
        table.addColumn(column);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) column %s has been added.", database.getName(), tableName, schemaName, catalogName, columnName), new Object[0]);
        }
        return column;
    }

    public static BestRowIdentifier populateBestRowIdentifier(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        String scopeName;
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        Integer scope = DatabaseUtil.getInteger(resultSet, "SCOPE", false);
        String columnName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        Integer precision = DatabaseUtil.getInteger(resultSet, "COLUMN_SIZE", false);
        Integer scale = DatabaseUtil.getInteger(resultSet, "DECIMAL_DIGITS", false);
        Integer pseudoColumn = DatabaseUtil.getInteger(resultSet, "PSEUDO_COLUMN", false);
        BestRowIdentifierScopeType scopeType = DatabaseUtil.getBestRowIdentifierScopeType(scope);
        if (scopeType == null) {
            if (failOnError) {
                throw new IllegalArgumentException("scopeType");
            }
            return null;
        }
        BestRowIdentifier brId = table.findBestRowIdentifierByScopeType(scopeType);
        if (brId == null) {
            brId = factory.createBestRowIdentifier();
        }
        brId.setScopeType(scopeType);
        boolean isPseudoColumn = DatabaseUtil.getColumnPseudoType(pseudoColumn) != null && DatabaseUtil.getColumnPseudoType(pseudoColumn) == ColumnPseudoType.PSEUDO;
        TableColumn column = null;
        if (isPseudoColumn) {
            column = factory.createTableColumn();
            column.setName(columnName);
            column.setOwner(table);
            column.setSqlType(DatabaseUtil.getSqlType(dataType));
            column.setTypeName(typeName);
            column.setPrecision(precision);
            column.setSize(precision);
            column.setRadix(scale);
            column.setPseudoType(DatabaseUtil.getColumnPseudoType(pseudoColumn));
            table.addColumn(column);
        } else {
            column = table.findColumnByName(columnName);
            if (column != null) {
                column.setPseudoType(DatabaseUtil.getColumnPseudoType(pseudoColumn));
            }
        }
        if (column != null) {
            brId.addColumn(column);
        }
        table.addBestRowIdentifier(brId);
        String string = scopeName = brId.getScopeType() == null ? null : brId.getScopeType().getName();
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) best row identifier with scope %s has been added.", database.getName(), tableName, schemaName, catalogName, scopeName), new Object[0]);
        }
        return brId;
    }

    public static PrimaryKey populatePrimaryKey(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        String primaryKeyName = null;
        PrimaryKey pk = factory.createPrimaryKey();
        pk.setCatalog(table.getCatalog());
        pk.setSchema(table.getSchema());
        while (resultSet.next()) {
            if (primaryKeyName == null) {
                primaryKeyName = DatabaseUtil.getString(resultSet, "PK_NAME", false);
                pk.setName(primaryKeyName);
            }
            String columnName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
            Integer ordinalPosition = DatabaseUtil.getInteger(resultSet, "KEY_SEQ", false);
            TableColumn tableColumn = table.findColumnByName(columnName);
            String errMessage = null;
            if (tableColumn == null) {
                errMessage = String.format("[Database %s] Unable to find table column '%5$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, schemaName, catalogName, columnName);
                traceLog.debug(errMessage, new Object[0]);
            }
            if (failOnError && tableColumn == null) {
                throw new DatabaseMetaDataMethodException(errMessage, "populatePrimaryKey");
            }
            PrimaryKeyColumn pkColumn = factory.createPrimaryKeyColumn();
            if (tableColumn != null) {
                tableColumn.setPrimaryKeyColumn(Boolean.TRUE);
                PropertyUtils.copyProperties((Object)pkColumn, (Object)tableColumn);
            } else {
                pkColumn.setName(columnName);
            }
            pkColumn.setOrdinalPosition(ordinalPosition);
            pk.addColumn(pkColumn);
        }
        table.setPrimaryKey(pk);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) primary key %s has been added.", database.getName(), tableName, schemaName, catalogName, primaryKeyName), new Object[0]);
        }
        return pk;
    }

    public static Set<ForeignKey> populateForeignKeys(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        ForeignKey fk = factory.createForeignKey();
        while (resultSet.next()) {
            String pkTableCatalogName = DatabaseUtil.getString(resultSet, "PKTABLE_CAT", false);
            String pkTableSchemaName = DatabaseUtil.getString(resultSet, "PKTABLE_SCHEM", false);
            String pkTableName = DatabaseUtil.getString(resultSet, "PKTABLE_NAME", false);
            String pkColumnName = DatabaseUtil.getString(resultSet, "PKCOLUMN_NAME", false);
            String fkColumnName = DatabaseUtil.getString(resultSet, "FKCOLUMN_NAME", false);
            Integer ordinalPosition = DatabaseUtil.getInteger(resultSet, "KEY_SEQ", false);
            Integer updateRule = DatabaseUtil.getInteger(resultSet, "UPDATE_RULE", false);
            Integer deleteRule = DatabaseUtil.getInteger(resultSet, "DELETE_RULE", false);
            String foreignKeyName = DatabaseUtil.getString(resultSet, "FK_NAME", false);
            Integer defferability = DatabaseUtil.getInteger(resultSet, "DEFERRABILITY", false);
            if (fk.getName() != null && !fk.getName().equals(foreignKeyName)) {
                table.addForeignKey(fk);
                if (traceLog.isTraceEnabled()) {
                    traceLog.trace(String.format("[Database %s] The table '%s' (schema %s, catalog %s) foreign key %s has been added.", database.getName(), tableName, schemaName, catalogName, foreignKeyName), new Object[0]);
                }
                fk = factory.createForeignKey();
                continue;
            }
            fk.setName(foreignKeyName);
            fk.setCatalog(table.getCatalog());
            fk.setSchema(table.getSchema());
            TableColumn tableColumn = table.findColumnByName(fkColumnName);
            String errMessage = null;
            if (tableColumn == null) {
                errMessage = String.format("[Database %s] Unable to find table column '%5$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, schemaName, catalogName, fkColumnName);
                traceLog.debug(errMessage, new Object[0]);
            }
            if (failOnError && tableColumn == null) {
                throw new DatabaseMetaDataMethodException(errMessage, "populateForeignKeys");
            }
            ForeignKeyColumn fkColumn = factory.createForeignKeyColumn();
            if (tableColumn != null) {
                tableColumn.setForeignKeyColumn(Boolean.TRUE);
                PropertyUtils.copyProperties((Object)fkColumn, (Object)tableColumn);
            } else {
                fkColumn.setName(fkColumnName);
            }
            fkColumn.setOrdinalPosition(ordinalPosition);
            Table pkTable = database.findTableByName(pkTableCatalogName, pkTableSchemaName, pkTableName);
            fk.setSourceTable(pkTable);
            PrimaryKey pk = pkTable == null ? null : pkTable.getPrimaryKey();
            fk.setSourcePrimaryKey(pk);
            fk.setUpdateRule(DatabaseUtil.getKeyModifyRuleType(updateRule));
            fk.setDeleteRule(DatabaseUtil.getKeyModifyRuleType(deleteRule));
            fk.setDeferrability(DatabaseUtil.getKeyDeferrabilityType(defferability));
            TableColumn pkColumn = pkTable == null ? null : pkTable.findColumnByName(pkColumnName);
            fkColumn.setSourceColumn(pkColumn);
            fk.addColumn(fkColumn);
        }
        table.addForeignKey(fk);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) foreign key %s has been added.", database.getName(), tableName, schemaName, catalogName, fk.getName()), new Object[0]);
        }
        return table.getForeignKeys();
    }

    public static Set<Index> populateIndexes(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        Index index = factory.createIndex();
        while (resultSet.next()) {
            Boolean nonUnique = DatabaseUtil.getBoolean(resultSet, "NON_UNIQUE", false);
            String indexQualifier = DatabaseUtil.getString(resultSet, "INDEX_QUALIFIER", false);
            String indexName = DatabaseUtil.getString(resultSet, "INDEX_NAME", false);
            Integer indexType = DatabaseUtil.getInteger(resultSet, "TYPE", false);
            Integer ordinalPosition = DatabaseUtil.getInteger(resultSet, "ORDINAL_POSITION", false);
            String indexColumnName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
            String ascOrDesc = DatabaseUtil.getString(resultSet, "ASC_OR_DESC", false);
            Integer cardinality = DatabaseUtil.getInteger(resultSet, "CARDINALITY", false);
            Integer pages = DatabaseUtil.getInteger(resultSet, "PAGES", false);
            String filterCondition = DatabaseUtil.getString(resultSet, "FILTER_CONDITION", false);
            if (index.getName() != null && !index.getName().equals(indexName)) {
                table.addIndex(index);
                if (traceLog.isDebugEnabled()) {
                    traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) index %s has been added.", database.getName(), tableName, schemaName, catalogName, indexName), new Object[0]);
                }
                index = factory.createIndex();
                continue;
            }
            index.setName(indexName);
            index.setCatalog(indexQualifier == null ? table.getCatalog() : database.findCatalogByName(indexQualifier));
            index.setSchema(table.getSchema());
            index.setUnique(nonUnique == null ? null : (nonUnique == true ? Boolean.FALSE : Boolean.TRUE));
            index.setIndexType(DatabaseUtil.getIndexType(indexType));
            index.setCardinality(cardinality);
            index.setPages(pages);
            index.setFilterCondition(filterCondition);
            TableColumn tableColumn = table.findColumnByName(indexColumnName);
            String errMessage = null;
            if (tableColumn == null) {
                errMessage = String.format("[Database %s] Unable to find table column '%5$s' for the table %s (schema %s, catalog %s)", database.getName(), tableName, schemaName, catalogName, indexColumnName);
                traceLog.debug(errMessage, new Object[0]);
            }
            if (failOnError && tableColumn == null) {
                throw new DatabaseMetaDataMethodException(errMessage, "populateIndexes");
            }
            IndexColumn indexColumn = factory.createIndexColumn();
            if (tableColumn != null) {
                tableColumn.setIndexColumn(Boolean.TRUE);
                PropertyUtils.copyProperties((Object)indexColumn, (Object)tableColumn);
            } else {
                indexColumn.setName(indexColumnName);
            }
            indexColumn.setOrdinalPosition(ordinalPosition);
            indexColumn.setSortSequenceType(DatabaseUtil.getSortSequenceType(ascOrDesc));
            index.addColumn(indexColumn);
        }
        table.addIndex(index);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) index %s has been added.", database.getName(), tableName, schemaName, catalogName, index.getName()), new Object[0]);
        }
        return table.getIndexes();
    }

    public static TableColumn populateVersionColumn(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        String columnName = DatabaseUtil.getString(resultSet, "COLUMN_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        Integer size = DatabaseUtil.getInteger(resultSet, "COLUMN_SIZE", false);
        Integer precision = DatabaseUtil.getInteger(resultSet, "DECIMAL_DIGITS", false);
        Integer columnPseudoType = DatabaseUtil.getInteger(resultSet, "PSEUDO_COLUMN", false);
        TableColumn column = table.findColumnByName(columnName);
        if (column == null) {
            column = factory.createTableColumn();
            column.setName(columnName);
            column.setOwner(table);
            column.setSqlType(DatabaseUtil.getSqlType(dataType));
            column.setTypeName(typeName);
            column.setSize(size);
            column.setPrecision(precision);
            column.setOrdinalPosition(null);
            table.addColumn(column);
        }
        column.setPseudoType(DatabaseUtil.getColumnPseudoType(columnPseudoType));
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) column %s has been updated or added.", database.getName(), tableName, schemaName, catalogName, columnName), new Object[0]);
        }
        return column;
    }

    public static Set<Privilege> populateTablePrivileges(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        while (resultSet.next()) {
            String grantor = DatabaseUtil.getString(resultSet, "GRANTOR", false);
            String grantee = DatabaseUtil.getString(resultSet, "GRANTEE", false);
            String privilegeName = DatabaseUtil.getString(resultSet, "PRIVILEGE", false);
            String isGrantableStr = DatabaseUtil.getString(resultSet, "IS_GRANTABLE", false);
            Privilege privilege = factory.createPrivilege();
            privilege.setName(privilegeName);
            privilege.setPrivilegeType(DatabaseUtil.getPrivilegeType(privilegeName));
            privilege.setGrantor(grantor);
            privilege.setGrantee(grantee);
            privilege.setGrantable("YES".equals(isGrantableStr) ? Boolean.TRUE : ("NO".equals(isGrantableStr) ? Boolean.FALSE : null));
            table.addPrivilege(privilege);
            if (!traceLog.isDebugEnabled()) continue;
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) privilege %s has been added.", database.getName(), tableName, schemaName, catalogName, privilegeName), new Object[0]);
        }
        return table.getPrivileges();
    }

    public static Set<Privilege> populateTableColumnPrivileges(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table, TableColumn column) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        if (column == null) {
            throw new IllegalArgumentException("column");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        while (resultSet.next()) {
            String grantor = DatabaseUtil.getString(resultSet, "GRANTOR", false);
            String grantee = DatabaseUtil.getString(resultSet, "GRANTEE", false);
            String privilegeName = DatabaseUtil.getString(resultSet, "PRIVILEGE", false);
            String isGrantableStr = DatabaseUtil.getString(resultSet, "IS_GRANTABLE", false);
            Privilege privilege = factory.createPrivilege();
            privilege.setName(privilegeName);
            privilege.setPrivilegeType(DatabaseUtil.getPrivilegeType(privilegeName));
            privilege.setGrantor(grantor);
            privilege.setGrantee(grantee);
            privilege.setGrantable("YES".equals(isGrantableStr) ? Boolean.TRUE : ("NO".equals(isGrantableStr) ? Boolean.FALSE : null));
            column.addPrivilege(privilege);
            if (!traceLog.isDebugEnabled()) continue;
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) column %s privilege %s has been added.", database.getName(), tableName, schemaName, catalogName, column.getName(), privilegeName), new Object[0]);
        }
        return column.getPrivileges();
    }

    public static SqlTypeInfo populateSqlTypeInfo(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String typeName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        Long precision = DatabaseUtil.getLong(resultSet, "PRECISION", false);
        String literalPrefix = DatabaseUtil.getString(resultSet, "LITERAL_PREFIX", false);
        String literalSuffix = DatabaseUtil.getString(resultSet, "LITERAL_SUFFIX", false);
        String createParams = DatabaseUtil.getString(resultSet, "CREATE_PARAMS", false);
        Integer nullableType = DatabaseUtil.getInteger(resultSet, "NULLABLE", false);
        Boolean caseSensitive = DatabaseUtil.getBoolean(resultSet, "CASE_SENSITIVE", false);
        Integer searchableType = DatabaseUtil.getInteger(resultSet, "SEARCHABLE", false);
        Boolean unsignedAttribute = DatabaseUtil.getBoolean(resultSet, "UNSIGNED_ATTRIBUTE", false);
        Boolean fixedPrecisionScale = DatabaseUtil.getBoolean(resultSet, "FIXED_PREC_SCALE", false);
        Boolean autoIncrement = DatabaseUtil.getBoolean(resultSet, "AUTO_INCREMENT", false);
        String localTypeName = DatabaseUtil.getString(resultSet, "LOCAL_TYPE_NAME", false);
        Integer minScale = DatabaseUtil.getInteger(resultSet, "MINIMUM_SCALE", false);
        Integer maxScale = DatabaseUtil.getInteger(resultSet, "MAXIMUM_SCALE", false);
        Integer radix = DatabaseUtil.getInteger(resultSet, "NUM_PREC_RADIX", false);
        SqlTypeInfo typeInfo = factory.createSqlTypeInfo();
        typeInfo.setName(typeName);
        typeInfo.setLocalizedTypeName(localTypeName);
        typeInfo.setNullabilityType(DatabaseUtil.getNullabilityType(nullableType));
        typeInfo.setSqlType(DatabaseUtil.getSqlType(dataType));
        typeInfo.setPrecision(precision);
        typeInfo.setFixedPrecisionScale(fixedPrecisionScale);
        typeInfo.setNumberPrecisionRadix(radix);
        typeInfo.setMinScale(minScale);
        typeInfo.setMaxScale(maxScale);
        typeInfo.setLiteralPrefix(literalPrefix);
        typeInfo.setLiteralSuffix(literalSuffix);
        typeInfo.setCreateParams(createParams);
        typeInfo.setCaseSensitive(caseSensitive);
        typeInfo.setSearchabilityType(DatabaseUtil.getSearchabilityType(searchableType));
        typeInfo.setUnsigned(unsignedAttribute);
        typeInfo.setAutoIncrement(autoIncrement);
        database.addSqlTypeInfo(typeInfo);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The SQL type '%s' has been added.", database.getName(), typeName), new Object[0]);
        }
        return typeInfo;
    }

    public static UserDefinedType populateUDT(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database) throws Exception {
        String errMessage;
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        String udtCatalog = DatabaseUtil.getString(resultSet, "TYPE_CAT", false);
        String udtSchema = DatabaseUtil.getString(resultSet, "TYPE_SCHEM", false);
        String udtName = DatabaseUtil.getString(resultSet, "TYPE_NAME", false);
        String className = DatabaseUtil.getString(resultSet, "CLASS_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        Integer baseType = DatabaseUtil.getInteger(resultSet, "BASE_TYPE", false);
        UserDefinedType udt = factory.createUserDefinedType();
        udt.setName(udtName);
        udt.setRemarks(remarks);
        if (udtCatalog != null && udtCatalog.trim().length() != 0) {
            Catalog catalog = database.findCatalogByName(udtCatalog);
            udt.setCatalog(catalog);
            errMessage = null;
            if (catalog == null) {
                errMessage = String.format("[Database %s] Unable to find catalog '%4$s' for the UDT %s (schema %s, catalog %s)", database.getName(), udtName, udtSchema, udtCatalog);
                traceLog.debug(errMessage, new Object[0]);
            }
            if (failOnError) {
                throw new DatabaseMetaDataMethodException(errMessage, "populateUDT");
            }
        }
        if (udtSchema != null && udtSchema.trim().length() != 0) {
            Schema schema = database.findSchemaByName(udtCatalog, udtSchema);
            udt.setSchema(schema);
            errMessage = null;
            if (schema == null) {
                errMessage = String.format("[Database %s] Unable to find schema '%3$s' for the UDT %s (schema %s, catalog %s)", database.getName(), udtName, udtSchema, udtCatalog);
                traceLog.debug(errMessage, new Object[0]);
            }
            if (failOnError) {
                throw new DatabaseMetaDataMethodException(errMessage, "populateUTD");
            }
        }
        udt.setClassName(className);
        udt.setSqlType(DatabaseUtil.getSqlType(dataType));
        udt.setBaseType(DatabaseUtil.getSqlType(baseType));
        database.addUserDefinedType(udt);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The UDT '%s' (schema %s, catalog %s) has been added.", database.getName(), udtName, udtSchema, udtCatalog), new Object[0]);
        }
        return udt;
    }

    public static Attribute populateUDTAttribute(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, UserDefinedType udt) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (udt == null) {
            throw new IllegalArgumentException("udt");
        }
        String catalogName = udt.getCatalog() == null ? null : udt.getCatalog().getName();
        String schemaName = udt.getSchema() == null ? null : udt.getSchema().getName();
        String udtName = udt.getName();
        String columnName = DatabaseUtil.getString(resultSet, "ATTR_NAME", false);
        Integer dataType = DatabaseUtil.getInteger(resultSet, "DATA_TYPE", false);
        String typeName = DatabaseUtil.getString(resultSet, "ATTR_TYPE_NAME", false);
        Integer size = DatabaseUtil.getInteger(resultSet, "ATTR_SIZE", false);
        Integer precision = DatabaseUtil.getInteger(resultSet, "DECIMAL_DIGITS", false);
        Integer radix = DatabaseUtil.getInteger(resultSet, "NUM_PREC_RADIX", false);
        Integer nullableType = DatabaseUtil.getInteger(resultSet, "NULLABLE", false);
        String remarks = DatabaseUtil.getString(resultSet, "REMARKS", false);
        String defaultValue = DatabaseUtil.getString(resultSet, "ATTR_DEF", false);
        Integer charOctetLength = DatabaseUtil.getInteger(resultSet, "CHAR_OCTET_LENGTH", false);
        Integer ordinalPosition = DatabaseUtil.getInteger(resultSet, "ORDINAL_POSITION", false);
        String scopeCatalog = DatabaseUtil.getString(resultSet, "SCOPE_CATLOG", false);
        String scopeSchema = DatabaseUtil.getString(resultSet, "SCOPE_SCHEMA", false);
        String scopeTable = DatabaseUtil.getString(resultSet, "SCOPE_TABLE", false);
        Integer sourceDataType = DatabaseUtil.getInteger(resultSet, "SOURCE_DATA_TYPE", false);
        Attribute column = factory.createAttribute();
        column.setName(columnName);
        column.setRemarks(remarks);
        column.setOwner(udt);
        column.setNullabilityType(DatabaseUtil.getNullabilityType(nullableType));
        column.setSqlType(DatabaseUtil.getSqlType(dataType));
        column.setTypeName(typeName);
        column.setSize(size);
        column.setPrecision(precision);
        column.setRadix(radix);
        column.setDefaultValue(defaultValue);
        column.setOrdinalPosition(ordinalPosition);
        column.setCharOctetLength(charOctetLength);
        if (scopeCatalog != null || scopeSchema != null || scopeTable != null || sourceDataType != null) {
            Reference reference = factory.createReference();
            reference.setSourceDataType(DatabaseUtil.getSqlType(sourceDataType));
            reference.setSourceTable(database.findTableByName(scopeCatalog, scopeSchema, scopeTable));
            column.setReference(reference);
        }
        udt.addAttribute(column);
        if (traceLog.isDebugEnabled()) {
            traceLog.debug(String.format("[Database %s] The UDT '%s' (schema %s, catalog %s) attribute %s has been added.", database.getName(), udtName, schemaName, catalogName, columnName), new Object[0]);
        }
        return column;
    }

    public static void updateUDTSuperType(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, UserDefinedType udt) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (udt == null) {
            throw new IllegalArgumentException("udt");
        }
        String catalogName = udt.getCatalog() == null ? null : udt.getCatalog().getName();
        String schemaName = udt.getSchema() == null ? null : udt.getSchema().getName();
        String udtName = udt.getName();
        String superTypeCatalog = DatabaseUtil.getString(resultSet, "SUPERTYPE_CAT", false);
        String superTypeSchema = DatabaseUtil.getString(resultSet, "SUPERTYPE_SCHEM", false);
        String superTypeName = DatabaseUtil.getString(resultSet, "SUPERTYPE_NAME", false);
        udt.setSuperType(database.findUserDefinedTypeByName(superTypeCatalog, superTypeSchema, superTypeName));
        if (udt.getSuperType() != null) {
            traceLog.debug(String.format("[Database %s] The UDT '%s' (schema %s, catalog %s) has super type %s (schema %s, catalog %s).", database.getName(), udtName, schemaName, catalogName, superTypeName, superTypeSchema, superTypeCatalog), new Object[0]);
        }
    }

    public static void updateTableSuperTable(ModelFactory factory, ResultSet resultSet, Logger traceLog, boolean failOnError, Database database, Table table) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        if (database == null) {
            throw new IllegalArgumentException("database");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (traceLog == null) {
            traceLog = log;
        }
        if (table == null) {
            throw new IllegalArgumentException("table");
        }
        String catalogName = table.getCatalog() == null ? null : table.getCatalog().getName();
        String schemaName = table.getSchema() == null ? null : table.getSchema().getName();
        String tableName = table.getName();
        String superTableName = DatabaseUtil.getString(resultSet, "SUPERTABLE_NAME", false);
        table.setSuperTable(database.findTableByName(catalogName, schemaName, tableName));
        if (table.getSuperTable() != null) {
            traceLog.debug(String.format("[Database %s] The table '%s' (schema %s, catalog %s) has super table %s.", database.getName(), tableName, schemaName, catalogName, superTableName), new Object[0]);
        }
    }

    public static <T> T getDatabaseMetadataProperty(DatabaseMetaData instance, String methodName, Logger traceLog) {
        try {
            Method m = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
            return (T)m.invoke((Object)instance, new Object[0]);
        }
        catch (Exception e) {
            traceLog.debug(String.format("Unable to execute getDatabaseMetadata for the '%1$s' method - %2$s: %3$s", methodName, e.getClass().getName(), e.getMessage()), new Object[0]);
            return null;
        }
    }

    static {
        standardUserDefinedTypesMapping.put("JAVA_OBJECT", new Integer(SqlType.JAVA_OBJECT.getType()));
        standardUserDefinedTypesMapping.put("STRUCT", new Integer(SqlType.STRUCT.getType()));
        standardUserDefinedTypesMapping.put("DISTINCT", new Integer(SqlType.DISTINCT.getType()));
    }
}

