/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.collection;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.ArgCheck;

@Immutable
public class Problem {
    public static final int DEFAULT_CODE = 0;
    private final Status status;
    private final I18n message;
    private final Object[] parameters;
    private final Throwable throwable;
    private final int code;
    private final String resource;
    private final String location;

    public Problem(Status status, int code, I18n message, Object ... params) {
        this(status, code, message, params, null, null, null);
    }

    public Problem(Status status, int code, I18n message, Object[] params, String resource, String location, Throwable throwable) {
        ArgCheck.isNotNull((Object)status, "status");
        ArgCheck.isNotNull(message, "message");
        this.status = status;
        this.code = code;
        this.message = message;
        this.parameters = params;
        this.resource = resource != null ? resource.trim() : null;
        this.location = location != null ? location.trim() : null;
        this.throwable = throwable;
    }

    public int getCode() {
        return this.code;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessageString() {
        return this.message.text(this.parameters);
    }

    public I18n getMessage() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getResource() {
        return this.resource;
    }

    public Status getStatus() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ERROR,
        WARNING,
        INFO;

    }
}

