/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.collection.Problem;
import org.jboss.dna.common.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Problems
implements Iterable<Problem> {
    private List<Problem> problems;

    public void addError(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, params));
    }

    public void addError(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, null, null, throwable));
    }

    public void addError(I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, resource, location));
    }

    public void addError(Throwable throwable, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, 0, message, resource, location, throwable));
    }

    public void addError(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, new Object[0]));
    }

    public void addError(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, null, null, throwable));
    }

    public void addError(int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, resource, location));
    }

    public void addError(Throwable throwable, int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.ERROR, code, message, resource, location, throwable));
    }

    public void addWarning(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, new Object[0]));
    }

    public void addWarning(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, null, null, throwable));
    }

    public void addWarning(I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, resource, location));
    }

    public void addWarning(Throwable throwable, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, 0, message, resource, location, throwable));
    }

    public void addWarning(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, new Object[0]));
    }

    public void addWarning(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, null, null, throwable));
    }

    public void addWarning(int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, resource, location));
    }

    public void addWarning(Throwable throwable, int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.WARNING, code, message, resource, location, throwable));
    }

    public void addInfo(I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, new Object[0]));
    }

    public void addInfo(Throwable throwable, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, null, null, throwable));
    }

    public void addInfo(I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, resource, location));
    }

    public void addInfo(Throwable throwable, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, 0, message, resource, location, throwable));
    }

    public void addInfo(int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, new Object[0]));
    }

    public void addInfo(Throwable throwable, int code, I18n message, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, null, null, throwable));
    }

    public void addInfo(int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, resource, location));
    }

    public void addInfo(Throwable throwable, int code, I18n message, String resource, String location, Object ... params) {
        this.addProblem(new Problem(Problem.Status.INFO, code, message, resource, location, throwable));
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    public boolean hasErrors() {
        if (this.problems == null) {
            return false;
        }
        for (Problem problem : this.problems) {
            if (problem.getStatus() != Problem.Status.ERROR) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarnings() {
        if (this.problems == null) {
            return false;
        }
        for (Problem problem : this.problems) {
            if (problem.getStatus() != Problem.Status.WARNING) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfo() {
        if (this.problems == null) {
            return false;
        }
        for (Problem problem : this.problems) {
            if (problem.getStatus() != Problem.Status.INFO) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.problems == null || this.problems.isEmpty();
    }

    public int size() {
        if (this.problems == null) {
            return 0;
        }
        return this.problems.size();
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.problems.iterator();
    }

    protected void addProblem(Problem problem) {
        if (problem == null) {
            return;
        }
        if (this.problems == null) {
            this.problems = new LinkedList<Problem>();
        }
        this.problems.add(problem);
    }
}

