/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.jcr.InvalidPathException;
import org.jboss.dna.common.jcr.PathNotFoundException;
import org.jboss.dna.common.text.Inflector;
import org.jboss.dna.common.text.Jsr283Encoder;
import org.jboss.dna.common.text.NoOpEncoder;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.text.UrlEncoder;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Path
implements Cloneable,
Comparable<Path>,
Iterable<Segment>,
Serializable {
    public static final TextEncoder NO_OP_ENCODER = new NoOpEncoder();
    public static final TextEncoder JSR283_ENCODER = new Jsr283Encoder();
    public static final TextEncoder URL_ENCODER = new UrlEncoder().setSlashEncoded(true);
    public static final TextEncoder DEFAULT_ENCODER = JSR283_ENCODER;
    public static final char DELIMITER = '/';
    public static final String DELIMITER_STR = new String(new char[]{'/'});
    public static final String PARENT = "..";
    public static final String SELF = ".";
    public static final Path ROOT = new Path(new ArrayList<Segment>(), true);
    protected static final Pattern DELIMITER_PATTERN = Pattern.compile(DELIMITER_STR);
    protected static final Pattern SEGMENT_PATTERN = Pattern.compile("([^:/]+)(:([^/\\[\\]]+))?(\\[(\\d+)])?");
    protected static final int NO_INDEX = -1;
    protected static final Segment PARENT_SEGMENT = new Segment("", "..", -1);
    protected static final Segment SELF_SEGMENT = new Segment("", ".", -1);
    protected static final List<Segment> PARENT_SEGMENT_LIST = Collections.singletonList(PARENT_SEGMENT);
    protected static final List<Segment> SELF_SEGMENT_LIST = Collections.singletonList(SELF_SEGMENT);
    private final List<Segment> segments;
    private final boolean absolute;
    private final boolean normalized;
    private transient String path;

    protected static List<Segment> resolveIntoSegments(Path relativeTo, String relativePath, TextEncoder encoder) {
        if (relativeTo == null) {
            relativeTo = ROOT;
        }
        if (encoder == null) {
            encoder = DEFAULT_ENCODER;
        }
        assert (relativePath != null);
        assert (relativePath.trim().equals(relativePath));
        int length = relativePath.length();
        if (length > 0 && relativePath.charAt(0) == '/') {
            relativePath = length > 1 ? relativePath.substring(1) : "";
            length = relativePath.length();
        }
        if (length > 0 && relativePath.charAt(length - 1) == '/') {
            relativePath = length > 1 ? relativePath.substring(0, length - 1) : "";
            length = relativePath.length();
        }
        ArrayList<Segment> segs = new ArrayList<Segment>(relativeTo.segments);
        if (length == 0) {
            return segs;
        }
        int index = segs.size() - 1;
        String[] pathSegments = DELIMITER_PATTERN.split(relativePath);
        if (pathSegments.length == 0) {
            String msg = "A valid path may not contain an empty segment (supplied path: " + relativePath + ")";
            throw new InvalidPathException(msg);
        }
        for (String segment : pathSegments) {
            assert (segment != null);
            if ((segment = segment.trim()).length() == 0) {
                String msg = "A valid path may not contain an empty segment (supplied path: " + relativePath + ")";
                throw new InvalidPathException(msg);
            }
            segs.add(new Segment(segment, encoder));
            ++index;
        }
        if (segs.isEmpty()) {
            return relativeTo.segments;
        }
        return Collections.unmodifiableList(segs);
    }

    public Path(String path) throws InvalidPathException {
        this(path, DEFAULT_ENCODER);
    }

    public Path(String path, TextEncoder encoder) throws InvalidPathException {
        if (path == null) {
            throw new InvalidPathException("A null path expression is not valid");
        }
        if ((path = path.trim()).length() == 0) {
            throw new InvalidPathException("The path expression may not be blank or contain only whitespace");
        }
        this.segments = Path.resolveIntoSegments(ROOT, path, encoder);
        this.absolute = path.startsWith(DELIMITER_STR);
        this.normalized = this.isNormalized(this.segments);
    }

    protected Path(Path path) {
        assert (path != null);
        this.segments = path.segments;
        this.absolute = path.absolute;
        this.normalized = path.normalized;
    }

    private Path(List<Segment> segments, boolean isAbsolute) {
        assert (segments != null);
        this.segments = Collections.unmodifiableList(segments);
        this.absolute = isAbsolute;
        this.normalized = this.isNormalized(this.segments);
    }

    protected Path createPath(List<Segment> segments, boolean isAbsolute) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new Path(segments, isAbsolute);
    }

    public int size() {
        return this.segments.size();
    }

    public boolean isRoot() {
        return this.segments.isEmpty();
    }

    public boolean isSame(Path other) {
        return this.compareTo(other) == 0;
    }

    public boolean isAncestorOf(Path decendant) {
        if (decendant == null) {
            return false;
        }
        if (this == decendant) {
            return false;
        }
        if (this.size() >= decendant.size()) {
            return false;
        }
        return decendant.toString().startsWith(this.toString());
    }

    public boolean isDecendantOf(Path ancestor) {
        if (ancestor == null) {
            return false;
        }
        if (this == ancestor) {
            return false;
        }
        if (this.size() <= ancestor.size()) {
            return false;
        }
        return this.toString().startsWith(ancestor.toString());
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    protected boolean isNormalized(List<Segment> segments) {
        for (Segment segment : segments) {
            if (segment.hasPrefix() || !segment.getName().equals(SELF) && !segment.getName().equals(PARENT)) continue;
            return false;
        }
        return true;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public Path getNormalizedPath() {
        if (this.isNormalized()) {
            return this;
        }
        LinkedList<Segment> newSegments = new LinkedList<Segment>();
        for (Segment segment : this.segments) {
            if (segment.equals(SELF_SEGMENT)) continue;
            if (segment.equals(PARENT_SEGMENT)) {
                if (newSegments.size() <= 0 && this.isAbsolute()) {
                    throw new InvalidPathException(CommonI18n.pathCannotBeNormalized.text(this));
                }
                if (newSegments.size() > 0 && !newSegments.getLast().equals(PARENT_SEGMENT)) {
                    newSegments.removeLast();
                    continue;
                }
            }
            newSegments.add(segment);
        }
        if (newSegments.isEmpty()) {
            if (this.isAbsolute()) {
                return ROOT;
            }
            return this.createPath(SELF_SEGMENT_LIST, false);
        }
        return this.createPath(newSegments, this.isAbsolute());
    }

    public Path getCanonicalPath() {
        if (!this.isAbsolute()) {
            String msg = CommonI18n.pathIsNotAbsolute.text(this);
            throw new InvalidPathException(msg);
        }
        if (this.isNormalized()) {
            return this;
        }
        return this.getNormalizedPath();
    }

    public Path relativeTo(Path startingPath) {
        int i;
        Segment toSeg;
        Segment thisSeg;
        ArgCheck.isNotNull(startingPath, "to");
        if (!this.isAbsolute()) {
            String msg = CommonI18n.pathIsNotAbsolute.text(this);
            throw new InvalidPathException(msg);
        }
        if (!startingPath.isAbsolute()) {
            String msg = CommonI18n.pathIsNotAbsolute.text(startingPath);
            throw new InvalidPathException(msg);
        }
        int lengthOfCommonAncestor = 0;
        Iterator<Segment> thisIter = this.getNormalizedPath().iterator();
        Iterator<Segment> toIter = startingPath.getNormalizedPath().iterator();
        while (thisIter.hasNext() && toIter.hasNext() && (thisSeg = thisIter.next()).equals(toSeg = toIter.next())) {
            ++lengthOfCommonAncestor;
        }
        int numberOfParentReferences = startingPath.size() - lengthOfCommonAncestor;
        ArrayList<Segment> relativeSegments = new ArrayList<Segment>();
        for (i = 0; i != numberOfParentReferences; ++i) {
            relativeSegments.add(PARENT_SEGMENT);
        }
        for (i = lengthOfCommonAncestor; i < this.size(); ++i) {
            relativeSegments.add(this.segments.get(i));
        }
        if (relativeSegments.isEmpty()) {
            relativeSegments.add(SELF_SEGMENT);
        }
        return this.createPath(relativeSegments, false);
    }

    public Path resolve(Path relativePath) {
        ArgCheck.isNotNull(relativePath, "relative path");
        if (!this.isAbsolute()) {
            String msg = CommonI18n.pathIsAlreadyAbsolute.text(this.path);
            throw new InvalidPathException(msg);
        }
        if (relativePath.isAbsolute()) {
            String msg = CommonI18n.pathIsNotRelative.text(relativePath);
            throw new InvalidPathException(msg);
        }
        if ((relativePath = relativePath.getNormalizedPath()).size() == 1) {
            Segment onlySegment = relativePath.getSegment(0);
            if (onlySegment.isSelfReference()) {
                return this;
            }
            if (onlySegment.isParentReference()) {
                return this.getAncestor();
            }
        }
        ArrayList<Segment> segments = new ArrayList<Segment>(this.size() + relativePath.size());
        segments.addAll(this.segments);
        segments.addAll(relativePath.segments);
        return this.createPath(segments, true).getNormalizedPath();
    }

    public Path resolve(String relativePath) {
        return this.resolve(relativePath, null);
    }

    public Path resolve(String relativePath, TextEncoder encoder) {
        return this.resolve(new Path(relativePath, encoder));
    }

    public Path resolveAgainst(Path absolutePath) {
        ArgCheck.isNotNull(absolutePath, "absolute path");
        return absolutePath.resolve(this);
    }

    public Path resolveAgainst(String absolutePath) {
        return this.resolveAgainst(absolutePath, null);
    }

    public Path resolveAgainst(String absolutePath, TextEncoder encoder) {
        return this.resolveAgainst(new Path(absolutePath, encoder));
    }

    public Path getAncestor() {
        if (this.isRoot()) {
            return this;
        }
        if (this.segments.size() == 1) {
            return ROOT;
        }
        return this.createPath(this.segments.subList(0, this.size() - 1), this.isAbsolute());
    }

    public Path getAncestor(int degree) {
        ArgCheck.isNonNegative(degree, "degree");
        if (this.isRoot()) {
            return this;
        }
        int endIndex = this.segments.size() - degree;
        if (endIndex < 0) {
            String msg = CommonI18n.pathAncestorDegreeIsInvalid.text(this.path, Inflector.getInstance().ordinalize(degree));
            throw new PathNotFoundException(msg);
        }
        return this.createPath(this.segments.subList(0, endIndex), this.isAbsolute());
    }

    public boolean hasSameAncestor(Path that) {
        if (that == null) {
            return false;
        }
        if (that.size() != this.size()) {
            return false;
        }
        return this.getAncestor().equals(that.getAncestor());
    }

    public Path getCommonAncestor(Path that) {
        Segment thatSeg;
        Segment thisSeg;
        if (that == null) {
            return null;
        }
        ArrayList<Segment> commonSegments = new ArrayList<Segment>();
        Iterator<Segment> thisIter = this.getNormalizedPath().iterator();
        Iterator<Segment> thatIter = that.getNormalizedPath().iterator();
        while (thisIter.hasNext() && thatIter.hasNext() && (thisSeg = thisIter.next()).equals(thatSeg = thatIter.next())) {
            commonSegments.add(thisSeg);
        }
        if (commonSegments.isEmpty()) {
            return ROOT;
        }
        return this.createPath(commonSegments, this.isAbsolute());
    }

    public boolean endsWith(String segment) {
        return this.endsWith(segment, NO_OP_ENCODER);
    }

    public boolean endsWith(String segment, TextEncoder encoder) {
        if (segment == null || this.segments.isEmpty()) {
            return false;
        }
        if (encoder == null) {
            encoder = NO_OP_ENCODER;
        }
        return this.getLastSegment().equals(new Segment(segment, encoder));
    }

    public Segment getLastSegment() {
        if (this.segments.isEmpty()) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public Segment getSegment(int index) {
        return this.segments.get(index);
    }

    public Path append(String segment) {
        return this.append(segment, NO_OP_ENCODER);
    }

    public Path append(String ... segments) {
        return this.append(segments, NO_OP_ENCODER);
    }

    public Path append(String segment, TextEncoder encoder) {
        if (segment == null) {
            return this;
        }
        if (segment.trim().length() == 0) {
            String msg = "A valid path may not contain an empty segment";
            throw new InvalidPathException(msg);
        }
        if (encoder == null) {
            encoder = NO_OP_ENCODER;
        }
        ArrayList<Segment> segments = new ArrayList<Segment>(this.size() + 1);
        segments.addAll(this.segments);
        segments.add(new Segment(encoder.encode(segment), encoder));
        return this.createPath(segments, this.isAbsolute());
    }

    public Path append(String[] segments, TextEncoder encoder) {
        if (segments == null || segments.length == 0) {
            return this;
        }
        if (encoder == null) {
            encoder = NO_OP_ENCODER;
        }
        ArrayList<Segment> segs = new ArrayList<Segment>(this.size() + segments.length);
        segs.addAll(this.segments);
        for (String segment : segments) {
            if (segment == null) continue;
            if (segment.trim().length() == 0) {
                String msg = "A valid path may not contain an empty segment: " + StringUtil.readableString((Object)segments);
                throw new InvalidPathException(msg);
            }
            segs.add(new Segment(encoder.encode(segment), encoder));
        }
        return this.createPath(segs, this.isAbsolute());
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public Segment[] toArray() {
        return this.segments.toArray(new Segment[this.segments.size()]);
    }

    public String[] toStringArray() {
        String[] result = new String[this.segments.size()];
        int i = 0;
        for (Segment segment : this.segments) {
            result[i++] = segment.toString();
        }
        return result;
    }

    public List<Segment> toList() {
        return this.segments;
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            return ((Object)this.segments).equals(that.segments);
        }
        return false;
    }

    @Override
    public int compareTo(Path that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        Iterator<Segment> thisIter = this.segments.iterator();
        Iterator<Segment> thatIter = that.segments.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            Segment thatSegment;
            Segment thisSegment = thisIter.next();
            int diff = thisSegment.compareTo(thatSegment = thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    public Path clone() {
        return new Path(this);
    }

    public String getString() {
        return this.getString(DEFAULT_ENCODER);
    }

    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = DEFAULT_ENCODER;
        }
        if (encoder == DEFAULT_ENCODER && this.path != null) {
            return this.path;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append('/');
        }
        boolean first = true;
        for (Segment segment : this.segments) {
            if (first) {
                first = false;
            } else {
                sb.append('/');
            }
            assert (segment != null);
            sb.append(encoder.encode(segment.toString()));
        }
        String result = sb.toString();
        if (encoder == DEFAULT_ENCODER && this.path == null) {
            this.path = result;
        }
        return result;
    }

    public String toString() {
        if (this.path == null) {
            this.path = this.getString(DEFAULT_ENCODER);
        }
        return this.path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class Segment
    implements Cloneable,
    Comparable<Segment>,
    Serializable {
        private final String prefix;
        private final String name;
        private final int index;
        private final int hc;

        protected Segment(String segment, TextEncoder encoder) {
            Matcher matcher = SEGMENT_PATTERN.matcher(segment);
            if (!matcher.matches()) {
                throw new InvalidPathException("Invalid path segment: " + segment);
            }
            String part1 = matcher.group(1);
            String part2 = matcher.group(3);
            String indexPart = matcher.group(5);
            this.name = part2 != null ? encoder.decode(part2) : encoder.decode(part1);
            this.prefix = part2 != null ? encoder.decode(part1) : "";
            this.index = indexPart != null ? Integer.parseInt(indexPart) : -1;
            this.hc = HashCode.compute(this.prefix, this.name);
        }

        protected Segment(String prefix, String name, int index) {
            this.prefix = prefix;
            this.name = name;
            this.index = index;
            this.hc = HashCode.compute(this.prefix, this.name);
            assert (this.prefix != null);
            assert (this.name != null);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName(boolean includeIndex) {
            StringBuilder sb = new StringBuilder();
            if (this.hasPrefix()) {
                sb.append(this.prefix);
                sb.append(":");
            }
            sb.append(this.name);
            if (includeIndex && this.hasIndex()) {
                sb.append("[").append(this.index).append("]");
            }
            return sb.toString();
        }

        public int getIndex() {
            return this.index;
        }

        public boolean hasIndex() {
            return this.index != -1;
        }

        public boolean hasPrefix() {
            return this.prefix.length() != 0;
        }

        public boolean isSelfReference() {
            return this.equals(SELF_SEGMENT);
        }

        public boolean isParentReference() {
            return this.equals(PARENT_SEGMENT);
        }

        public int hashCode() {
            return this.hc;
        }

        @Override
        public int compareTo(Segment that) {
            if (this == that) {
                return 0;
            }
            int diff = this.prefix.compareTo(that.prefix);
            if (diff != 0) {
                return diff;
            }
            diff = this.name.compareTo(that.name);
            if (diff != 0) {
                return diff;
            }
            return this.index - that.index;
        }

        public Object clone() {
            return new Segment(this.prefix, this.name, this.index);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Segment) {
                Segment that = (Segment)obj;
                if (this.hc != that.hc) {
                    return false;
                }
                if (!this.prefix.equals(that.prefix)) {
                    return false;
                }
                if (!this.name.equals(that.name)) {
                    return false;
                }
                return this.index == that.index;
            }
            return false;
        }

        public String toString() {
            return this.getQualifiedName(true);
        }
    }
}

