/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.monitor;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.ProgressStatus;

@ThreadSafe
public class NullProgressMonitor
implements ProgressMonitor {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final String activityName;

    public NullProgressMonitor(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void beginTask(double totalWork, I18n name, Object ... params) {
    }

    public ProgressMonitor createSubtask(double subtaskWork) {
        return this;
    }

    public void done() {
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setCancelled(boolean value) {
        this.cancelled.set(value);
    }

    public void worked(double work) {
    }

    public ProgressStatus getStatus(Locale locale) {
        return new ProgressStatus(this.activityName, CommonI18n.nullProgressMonitorTaskName.text(locale, new Object[0]), 0.0, this.cancelled.get());
    }
}

