/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.monitor;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.ProgressStatus;
import org.jboss.dna.common.monitor.SubProgressMonitor;

@ThreadSafe
public class SimpleProgressMonitor
implements ProgressMonitor {
    @GuardedBy(value="lock")
    private I18n taskName;
    @GuardedBy(value="lock")
    private Object[] taskNameParams;
    @GuardedBy(value="lock")
    private double totalWork;
    @GuardedBy(value="lock")
    private double worked;
    @GuardedBy(value="lock")
    private boolean done;
    private final String activityName;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public SimpleProgressMonitor(String activityName) {
        this.activityName = activityName != null ? activityName.trim() : "";
        this.taskName = null;
        this.taskNameParams = null;
    }

    public String getActivityName() {
        return this.activityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(double totalWork, I18n name, Object ... params) {
        assert (totalWork > 0.0);
        try {
            this.lock.writeLock().lock();
            this.taskName = name;
            this.taskNameParams = params;
            this.totalWork = totalWork;
            this.worked = 0.0;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ProgressMonitor createSubtask(double subtaskWork) {
        return new SubProgressMonitor(this, subtaskWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        boolean alreadyDone = false;
        try {
            this.lock.writeLock().lock();
            if (!this.done) {
                this.worked = this.totalWork;
            } else {
                alreadyDone = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!alreadyDone) {
            this.notifyProgress();
        }
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setCancelled(boolean value) {
        this.cancelled.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worked(double work) {
        if (work > 0.0) {
            try {
                this.lock.writeLock().lock();
                if (this.worked < this.totalWork) {
                    this.worked += work;
                    if (this.worked > this.totalWork) {
                        this.worked = this.totalWork;
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.notifyProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressStatus getStatus(Locale locale) {
        try {
            this.lock.readLock().lock();
            String localizedTaskName = this.taskName == null ? "" : this.taskName.text(locale, this.taskNameParams);
            ProgressStatus progressStatus = new ProgressStatus(this.getActivityName(), localizedTaskName, this.worked, this.totalWork, this.isCancelled());
            return progressStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void notifyProgress() {
    }
}

