/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.dna.common.CommonI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgCheck {
    public static void isNonNegative(int argument, String name) {
        if (argument < 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(int argument, String name) {
        if (argument > 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(int argument, String name) {
        if (argument >= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(int argument, String name) {
        if (argument <= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNonNegative(long argument, String name) {
        if (argument < 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(long argument, String name) {
        if (argument > 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(long argument, String name) {
        if (argument >= 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNonNegative(double argument, String name) {
        if (argument < 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(double argument, String name) {
        if (argument > 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(double argument, String name) {
        if (argument >= 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(double argument, String name) {
        if (argument <= 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNotNan(double argument, String name) {
        if (Double.isNaN(argument)) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNumber.text(name));
        }
    }

    public static void isNotZeroLength(String argument, String name) {
        ArgCheck.isNotNull(argument, name);
        if (argument.length() <= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNullOrZeroLength.text(name));
        }
    }

    public static void isNotEmpty(String argument, String name) {
        ArgCheck.isNotZeroLength(argument, name);
        if (argument != null && argument.trim().length() == 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNullOrZeroLengthOrEmpty.text(name));
        }
    }

    public static void isNotNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNull.text(name));
        }
    }

    public static <T> T getNotNull(T argument, String name) {
        ArgCheck.isNotNull(argument, name);
        return argument;
    }

    public static void isNull(Object argument, String name) {
        if (argument != null) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNull.text(name));
        }
    }

    public static void isInstanceOf(Object argument, Class expectedClass, String name) {
        ArgCheck.isNotNull(argument, name);
        if (!expectedClass.isInstance(argument)) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeInstanceOf.text(name, argument.getClass(), expectedClass.getName()));
        }
    }

    public static <C> C getInstanceOf(Object argument, Class<C> expectedClass, String name) {
        ArgCheck.isInstanceOf(argument, expectedClass, name);
        return (C)argument;
    }

    public static <T> void isSame(T argument, String argumentName, T object, String objectName) {
        if (argument != object) {
            if (objectName == null) {
                objectName = ArgCheck.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustBeSameAs.text(argumentName, objectName));
        }
    }

    public static <T> void isNotSame(T argument, String argumentName, T object, String objectName) {
        if (argument == object) {
            if (objectName == null) {
                objectName = ArgCheck.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustNotBeSameAs.text(argumentName, objectName));
        }
    }

    public static <T> void isEquals(T argument, String argumentName, T object, String objectName) {
        if (!argument.equals(object)) {
            if (objectName == null) {
                objectName = ArgCheck.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustBeEquals.text(argumentName, objectName));
        }
    }

    public static <T> void isNotEquals(T argument, String argumentName, T object, String objectName) {
        if (argument.equals(object)) {
            if (objectName == null) {
                objectName = ArgCheck.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustNotBeEquals.text(argumentName, objectName));
        }
    }

    public static void isNotEmpty(Iterator argument, String name) {
        ArgCheck.isNotNull(argument, name);
        if (!argument.hasNext()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Collection argument, String name) {
        ArgCheck.isNotNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Map argument, String name) {
        ArgCheck.isNotNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Object[] argument, String name) {
        ArgCheck.isNotNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    protected static String getObjectName(Object obj) {
        return obj == null ? null : "'" + obj.toString() + "'";
    }

    public static void contains(Collection argument, Object value, String name) {
        ArgCheck.isNotNull(argument, name);
        if (!argument.contains(value)) {
            throw new IllegalArgumentException(CommonI18n.argumentDidNotContainObject.text(name, ArgCheck.getObjectName(value)));
        }
    }

    public static void containsKey(Map argument, Object key, String name) {
        ArgCheck.isNotNull(argument, name);
        if (!argument.containsKey(key)) {
            throw new IllegalArgumentException(CommonI18n.argumentDidNotContainKey.text(name, ArgCheck.getObjectName(key)));
        }
    }

    public static void containsNoNulls(Collection argument, String name) {
        ArgCheck.isNotNull(argument, name);
        int i = 0;
        for (Object object : argument) {
            if (object == null) {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotContainNullValue.text(name, i));
            }
            ++i;
        }
    }

    public static void containsNoNulls(Object[] argument, String name) {
        ArgCheck.isNotNull(argument, name);
        int i = 0;
        for (Object object : argument) {
            if (object == null) {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotContainNullValue.text(name, i));
            }
            ++i;
        }
    }

    private ArgCheck() {
    }
}

