/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.jboss.dna.common.util.ArgCheck;

public class IoUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int numRead = 0;
            while ((numRead = stream.read(buffer)) > -1) {
                output.write(buffer, 0, numRead);
            }
        }
        finally {
            stream.close();
        }
        output.flush();
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        char[] buffer = new char[1024];
        StringBuffer sb = new StringBuffer();
        try {
            int numRead = 0;
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public static String read(InputStream stream) throws IOException {
        return stream == null ? "" : IoUtil.read(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String content, OutputStream stream) throws IOException {
        ArgCheck.isNotNull(stream, "destination stream");
        try {
            if (content != null) {
                byte[] bytes = content.getBytes();
                stream.write(bytes, 0, bytes.length);
            }
        }
        finally {
            try {
                stream.flush();
            }
            finally {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String content, Writer writer) throws IOException {
        ArgCheck.isNotNull(writer, "destination writer");
        try {
            if (content != null) {
                writer.write(content);
            }
        }
        finally {
            try {
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream input, OutputStream stream) throws IOException {
        block12: {
            ArgCheck.isNotNull(stream, "destination stream");
            try {
                if (input == null) break block12;
                byte[] buffer = new byte[1024];
                try {
                    int numRead = 0;
                    while ((numRead = input.read(buffer)) > -1) {
                        stream.write(buffer, 0, numRead);
                    }
                }
                finally {
                    input.close();
                }
            }
            finally {
                try {
                    stream.flush();
                }
                finally {
                    stream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Reader input, Writer writer) throws IOException {
        block12: {
            ArgCheck.isNotNull(writer, "destination writer");
            try {
                if (input == null) break block12;
                char[] buffer = new char[1024];
                try {
                    int numRead = 0;
                    while ((numRead = input.read(buffer)) > -1) {
                        writer.write(buffer, 0, numRead);
                    }
                }
                finally {
                    input.close();
                }
            }
            finally {
                try {
                    writer.flush();
                }
                finally {
                    writer.close();
                }
            }
        }
    }

    private IoUtil() {
    }
}

