/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.monitor;

import java.util.Locale;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.ProgressMonitorWrapper;
import org.jboss.dna.common.util.Logger;

public class LoggingProgressMonitor
extends ProgressMonitorWrapper {
    private final Logger logger;
    private final Logger.Level level;
    private final Locale locale;

    public LoggingProgressMonitor(ProgressMonitor delegate, Logger logger, Logger.Level level) {
        this(delegate, logger, level, null);
    }

    public LoggingProgressMonitor(ProgressMonitor delegate, Logger logger, Logger.Level level, Locale locale) {
        super(delegate);
        assert (level != null);
        assert (logger != null);
        this.level = level;
        this.logger = logger;
        this.locale = locale;
    }

    public void beginTask(double totalWork, I18n name, Object ... params) {
        super.beginTask(totalWork, name, params);
        this.logger.log(this.level, CommonI18n.progressMonitorBeginTask, this.getActivityName(), name.text(params));
    }

    public void done() {
        super.done();
        this.logger.log(this.level, CommonI18n.progressMonitorStatus, super.getStatus(this.locale));
    }

    public void setCancelled(boolean value) {
        super.setCancelled(value);
        this.logger.log(this.level, CommonI18n.progressMonitorStatus, super.getStatus(this.locale));
    }

    public void worked(double work) {
        super.worked(work);
        this.logger.log(this.level, CommonI18n.progressMonitorStatus, super.getStatus(this.locale));
    }
}

