/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.monitor;

import java.util.Locale;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.ProgressStatus;

public class SubProgressMonitor
implements ProgressMonitor {
    @GuardedBy(value="lock")
    private I18n taskName;
    @GuardedBy(value="lock")
    private Object[] params;
    @GuardedBy(value="lock")
    private double totalWork;
    @GuardedBy(value="lock")
    private double parentWorkScaleFactor;
    @GuardedBy(value="lock")
    private double submittedToParent;
    private final double subtaskTotalInParent;
    private final ProgressMonitor parent;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public SubProgressMonitor(ProgressMonitor parent, double subtaskTotalInParent) {
        assert (subtaskTotalInParent > 0.0);
        assert (parent != null);
        this.parent = parent;
        this.subtaskTotalInParent = subtaskTotalInParent;
    }

    public String getActivityName() {
        return this.parent.getActivityName();
    }

    public ProgressMonitor getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(double totalWork, I18n name, Object ... params) {
        assert (totalWork > 0.0);
        try {
            this.lock.writeLock().lock();
            this.taskName = name;
            this.params = params;
            this.totalWork = totalWork;
            this.parentWorkScaleFactor = (float)this.subtaskTotalInParent / (float)totalWork;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ProgressMonitor createSubtask(double subtaskWork) {
        return new SubProgressMonitor(this, subtaskWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        double workInParentRemaining = 0.0;
        try {
            this.lock.writeLock().lock();
            double totalWorkInParent = this.totalWork * this.parentWorkScaleFactor;
            workInParentRemaining = totalWorkInParent - this.submittedToParent;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.parent.worked(workInParentRemaining);
    }

    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    public boolean isDone() {
        return this.parent.isDone();
    }

    public void setCancelled(boolean value) {
        this.parent.setCancelled(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worked(double work) {
        if (this.isCancelled()) {
            return;
        }
        if (work > 0.0) {
            double workInParent = 0.0;
            try {
                this.lock.writeLock().lock();
                workInParent = work * this.parentWorkScaleFactor;
                this.submittedToParent += workInParent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.parent.worked(workInParent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressStatus getStatus(Locale locale) {
        try {
            this.lock.readLock().lock();
            ProgressStatus progressStatus = new ProgressStatus(this.getActivityName(), this.taskName.text(locale, this.params), this.submittedToParent, this.subtaskTotalInParent, this.isCancelled());
            return progressStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Problems getProblems() {
        return this.parent.getProblems();
    }
}

