/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.dna.common.CommonI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckArg {
    public static void isNotLessThan(int argument, int notLessThanValue, String name) {
        if (argument < notLessThanValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeLessThan.text(name, argument, notLessThanValue));
        }
    }

    public static void isNotGreaterThan(int argument, int notGreaterThanValue, String name) {
        if (argument > notGreaterThanValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeGreaterThan.text(name, argument, notGreaterThanValue));
        }
    }

    public static void isGreaterThan(int argument, int greaterThanValue, String name) {
        if (argument <= greaterThanValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeGreaterThan.text(name, argument, greaterThanValue));
        }
    }

    public static void isLessThan(int argument, int lessThanValue, String name) {
        if (argument >= lessThanValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeLessThan.text(name, argument, lessThanValue));
        }
    }

    public static void isGreaterThanOrEqualTo(int argument, int greaterThanOrEqualToValue, String name) {
        if (argument < greaterThanOrEqualToValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeGreaterThanOrEqualTo.text(name, argument, greaterThanOrEqualToValue));
        }
    }

    public static void isLessThanOrEqualTo(int argument, int lessThanOrEqualToValue, String name) {
        if (argument > lessThanOrEqualToValue) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeLessThanOrEqualTo.text(name, argument, lessThanOrEqualToValue));
        }
    }

    public static void isNonNegative(int argument, String name) {
        if (argument < 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(int argument, String name) {
        if (argument > 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(int argument, String name) {
        if (argument >= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(int argument, String name) {
        if (argument <= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNonNegative(long argument, String name) {
        if (argument < 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(long argument, String name) {
        if (argument > 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(long argument, String name) {
        if (argument >= 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNonNegative(double argument, String name) {
        if (argument < 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNegative.text(name, argument));
        }
    }

    public static void isNonPositive(double argument, String name) {
        if (argument > 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBePositive.text(name, argument));
        }
    }

    public static void isNegative(double argument, String name) {
        if (argument >= 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNegative.text(name, argument));
        }
    }

    public static void isPositive(double argument, String name) {
        if (argument <= 0.0) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBePositive.text(name, argument));
        }
    }

    public static void isNotNan(double argument, String name) {
        if (Double.isNaN(argument)) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNumber.text(name));
        }
    }

    public static void isNotZeroLength(String argument, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.length() <= 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNullOrZeroLength.text(name));
        }
    }

    public static void isNotEmpty(String argument, String name) {
        CheckArg.isNotZeroLength(argument, name);
        if (argument != null && argument.trim().length() == 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNullOrZeroLengthOrEmpty.text(name));
        }
    }

    public static void isNotNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeNull.text(name));
        }
    }

    public static <T> T getNotNull(T argument, String name) {
        CheckArg.isNotNull(argument, name);
        return argument;
    }

    public static void isNull(Object argument, String name) {
        if (argument != null) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeNull.text(name));
        }
    }

    public static void isInstanceOf(Object argument, Class<?> expectedClass, String name) {
        CheckArg.isNotNull(argument, name);
        if (!expectedClass.isInstance(argument)) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeInstanceOf.text(name, argument.getClass(), expectedClass.getName()));
        }
    }

    public static <C> C getInstanceOf(Object argument, Class<C> expectedClass, String name) {
        CheckArg.isInstanceOf(argument, expectedClass, name);
        return expectedClass.cast(argument);
    }

    public static <T> void isSame(T argument, String argumentName, T object, String objectName) {
        if (argument != object) {
            if (objectName == null) {
                objectName = CheckArg.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustBeSameAs.text(argumentName, objectName));
        }
    }

    public static <T> void isNotSame(T argument, String argumentName, T object, String objectName) {
        if (argument == object) {
            if (objectName == null) {
                objectName = CheckArg.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustNotBeSameAs.text(argumentName, objectName));
        }
    }

    public static <T> void isEquals(T argument, String argumentName, T object, String objectName) {
        if (!argument.equals(object)) {
            if (objectName == null) {
                objectName = CheckArg.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustBeEquals.text(argumentName, objectName));
        }
    }

    public static <T> void isNotEquals(T argument, String argumentName, T object, String objectName) {
        if (argument.equals(object)) {
            if (objectName == null) {
                objectName = CheckArg.getObjectName(object);
            }
            throw new IllegalArgumentException(CommonI18n.argumentMustNotBeEquals.text(argumentName, objectName));
        }
    }

    public static void isNotEmpty(Iterator<?> argument, String name) {
        CheckArg.isNotNull(argument, name);
        if (!argument.hasNext()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Collection<?> argument, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Map<?, ?> argument, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    public static void isNotEmpty(Object[] argument, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(name));
        }
    }

    protected static String getObjectName(Object obj) {
        return obj == null ? null : "'" + obj.toString() + "'";
    }

    public static void contains(Collection<?> argument, Object value, String name) {
        CheckArg.isNotNull(argument, name);
        if (!argument.contains(value)) {
            throw new IllegalArgumentException(CommonI18n.argumentDidNotContainObject.text(name, CheckArg.getObjectName(value)));
        }
    }

    public static void containsKey(Map<?, ?> argument, Object key, String name) {
        CheckArg.isNotNull(argument, name);
        if (!argument.containsKey(key)) {
            throw new IllegalArgumentException(CommonI18n.argumentDidNotContainKey.text(name, CheckArg.getObjectName(key)));
        }
    }

    public static void containsNoNulls(Iterable<?> argument, String name) {
        CheckArg.isNotNull(argument, name);
        int i = 0;
        for (Object object : argument) {
            if (object == null) {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotContainNullValue.text(name, i));
            }
            ++i;
        }
    }

    public static void containsNoNulls(Object[] argument, String name) {
        CheckArg.isNotNull(argument, name);
        int i = 0;
        for (Object object : argument) {
            if (object == null) {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotContainNullValue.text(name, i));
            }
            ++i;
        }
    }

    public static void hasSizeOfAtLeast(Collection<?> argument, int minimumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.size() < minimumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Collection.class.getSimpleName(), argument.size(), minimumSize));
        }
    }

    public static void hasSizeOfAtMost(Collection<?> argument, int maximumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.size() > maximumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Collection.class.getSimpleName(), argument.size(), maximumSize));
        }
    }

    public static void hasSizeOfAtLeast(Map<?, ?> argument, int minimumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.size() < minimumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Map.class.getSimpleName(), argument.size(), minimumSize));
        }
    }

    public static void hasSizeOfAtMost(Map<?, ?> argument, int maximumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.size() > maximumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Map.class.getSimpleName(), argument.size(), maximumSize));
        }
    }

    public static void hasSizeOfAtLeast(Object[] argument, int minimumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.length < minimumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Object[].class.getSimpleName(), argument.length, minimumSize));
        }
    }

    public static void hasSizeOfAtMost(Object[] argument, int maximumSize, String name) {
        CheckArg.isNotNull(argument, name);
        if (argument.length > maximumSize) {
            throw new IllegalArgumentException(CommonI18n.argumentMustBeOfMinimumSize.text(name, Object[].class.getSimpleName(), argument.length, maximumSize));
        }
    }

    private CheckArg() {
    }
}

