/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.CommonI18n;

@ThreadSafe
public class DateUtil {
    public static final String ISO_8601_2004_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static Calendar getCalendarFromStandardString(String dateString) throws ParseException {
        String dayOfMonth;
        String regex = "^(\\d{4})-?(([wW]([012345]\\d)-?([1234567])?)|(([01]\\d)(-([0123]\\d))?)|([01]\\d)([0123]\\d)|([0123]\\d\\d))?(T([012]\\d):?([012345]\\d)(:?([012345]\\d)(.(\\d{1,3}))?)?((Z)|(([+-])(\\d{2})):?(\\d{2})?)?)?$";
        Pattern pattern = Pattern.compile("^(\\d{4})-?(([wW]([012345]\\d)-?([1234567])?)|(([01]\\d)(-([0123]\\d))?)|([01]\\d)([0123]\\d)|([0123]\\d\\d))?(T([012]\\d):?([012345]\\d)(:?([012345]\\d)(.(\\d{1,3}))?)?((Z)|(([+-])(\\d{2})):?(\\d{2})?)?)?$");
        Matcher matcher = pattern.matcher(dateString);
        if (!matcher.matches()) {
            throw new ParseException(CommonI18n.dateParsingFailure.text(dateString), 0);
        }
        String year = matcher.group(1);
        String week = matcher.group(4);
        String dayOfWeek = matcher.group(5);
        String month = matcher.group(7);
        if (month == null) {
            month = matcher.group(10);
        }
        if ((dayOfMonth = matcher.group(9)) == null) {
            dayOfMonth = matcher.group(11);
        }
        String dayOfYear = matcher.group(12);
        String hourOfDay = matcher.group(14);
        String minutesOfHour = matcher.group(15);
        String seconds = matcher.group(17);
        String milliseconds = matcher.group(19);
        String timeZoneSign = matcher.group(23);
        String timeZoneHour = matcher.group(24);
        String timeZoneMinutes = matcher.group(25);
        if (matcher.group(21) != null) {
            timeZoneHour = "00";
            timeZoneMinutes = "00";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (year != null) {
            calendar.set(1, Integer.parseInt(year));
        }
        if (month != null) {
            calendar.set(2, Integer.parseInt(month) - 1);
            if (dayOfMonth != null) {
                calendar.set(5, Integer.parseInt(dayOfMonth));
            }
        } else if (week != null) {
            calendar.set(3, Integer.parseInt(week));
            if (dayOfWeek != null) {
                calendar.set(7, Integer.parseInt(dayOfWeek));
            }
        } else if (dayOfYear != null) {
            calendar.set(6, Integer.parseInt(dayOfYear));
        }
        if (hourOfDay != null) {
            calendar.set(11, Integer.parseInt(hourOfDay));
        }
        if (minutesOfHour != null) {
            calendar.set(12, Integer.parseInt(minutesOfHour));
        }
        if (seconds != null) {
            calendar.set(13, Integer.parseInt(seconds));
        }
        if (milliseconds != null) {
            calendar.set(14, Integer.parseInt(milliseconds));
        }
        if (timeZoneHour != null) {
            int zoneOffsetInMillis = Integer.parseInt(timeZoneHour) * 60 * 60 * 1000;
            if ("-".equals(timeZoneSign)) {
                zoneOffsetInMillis *= -1;
            }
            if (timeZoneMinutes != null) {
                int minuteOffsetInMillis = Integer.parseInt(timeZoneMinutes) * 60 * 1000;
                zoneOffsetInMillis = zoneOffsetInMillis < 0 ? (zoneOffsetInMillis -= minuteOffsetInMillis) : (zoneOffsetInMillis += minuteOffsetInMillis);
            }
            calendar.set(15, zoneOffsetInMillis);
        }
        return calendar;
    }

    public static Date getDateFromStandardString(String dateString) throws ParseException {
        return DateUtil.getCalendarFromStandardString(dateString).getTime();
    }

    public static String getDateAsStandardString(long millisecondsSinceEpoch) {
        return DateUtil.getDateAsStandardString(new Date(millisecondsSinceEpoch));
    }

    public static String getDateAsStandardString(Calendar date) {
        return DateUtil.getDateAsStandardString(date.getTime());
    }

    public static String getDateAsStandardString(Date date) {
        return new SimpleDateFormat(ISO_8601_2004_FORMAT).format(date);
    }

    public static String getDateAsStringForCurrentLocale(Date date) {
        return DateUtil.getDateAsStringForLocale(date, Locale.getDefault());
    }

    public static String getDateAsStringForLocale(Date date, Locale locale) {
        return DateFormat.getDateTimeInstance(2, 1).format(date);
    }

    private DateUtil() {
    }
}

