/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.stats;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.math.MathOperations;
import org.jboss.dna.common.stats.Histogram;
import org.jboss.dna.common.stats.SimpleStatistics;
import org.jboss.dna.common.text.Inflector;
import org.jboss.dna.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DetailedStatistics<T extends Number>
extends SimpleStatistics<T> {
    private T median;
    private Double medianValue = 0.0;
    private double s = 0.0;
    private double sigma = 0.0;
    private final List<T> values = new LinkedList<T>();
    private final List<T> unmodifiableValues = Collections.unmodifiableList(this.values);
    private Histogram<T> histogram;

    public DetailedStatistics(MathOperations<T> operations) {
        super(operations);
        this.median = (Number)this.math.createZeroValue();
    }

    public List<T> getValues() {
        return this.unmodifiableValues;
    }

    @Override
    protected void doAddValue(T value) {
        if (value == null) {
            return;
        }
        double previousMean = this.getMeanValue();
        super.doAddValue(value);
        this.values.add(value);
        this.medianValue = null;
        int count = this.getCount();
        if (count == 1) {
            this.s = 0.0;
            this.sigma = 0.0;
        } else {
            double dValue = ((Number)value).doubleValue();
            double dCount = count;
            double meanValue = previousMean + (dValue - previousMean) / dCount;
            this.s += (dValue - previousMean) * (dValue - meanValue);
            this.sigma = Math.sqrt(this.s / dCount);
        }
    }

    public T getMedian() {
        this.getMedianValue();
        return this.median;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMedianValue() {
        Lock lock = this.getLock().writeLock();
        try {
            lock.lock();
            int count = this.values.size();
            if (count == 0) {
                double d = 0.0;
                return d;
            }
            if (this.medianValue == null) {
                Comparator comparator = this.math.getComparator();
                Collections.sort(this.values, comparator);
                this.medianValue = 0.0;
                if (count == 1) {
                    this.medianValue = ((Number)this.values.get(0)).doubleValue();
                } else if (count % 2 != 0) {
                    this.medianValue = ((Number)this.values.get((count + 1) / 2 - 1)).doubleValue();
                } else {
                    int upperMiddleValueIndex = count / 2;
                    int lowerMiddleValueIndex = upperMiddleValueIndex - 1;
                    double lowerValue = ((Number)this.values.get(lowerMiddleValueIndex)).doubleValue();
                    double upperValue = ((Number)this.values.get(upperMiddleValueIndex)).doubleValue();
                    this.medianValue = (lowerValue + upperValue) / 2.0;
                }
                this.median = (Number)this.math.create(this.medianValue);
                this.histogram = null;
            }
        }
        finally {
            lock.unlock();
        }
        return this.medianValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStandardDeviation() {
        Lock lock = this.getLock().readLock();
        lock.lock();
        try {
            double d = this.sigma;
            return d;
        }
        finally {
            lock.unlock();
        }
    }

    public Histogram<T> getHistogram() {
        return this.getHistogram(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Histogram<T> getHistogram(int numSigmas) {
        Lock lock = this.getLock().writeLock();
        lock.lock();
        try {
            Histogram<T> hist = new Histogram<T>(this.math, this.values);
            if (numSigmas > 0) {
                hist.setStrategy(this.getMedianValue(), this.getStandardDeviation(), numSigmas);
            }
            Histogram<T> histogram = this.histogram = hist;
            return histogram;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void doReset() {
        super.doReset();
        this.medianValue = 0.0;
        this.median = (Number)this.math.createZeroValue();
        this.s = 0.0;
        this.sigma = 0.0;
        this.values.clear();
    }

    @Override
    public String toString() {
        int count = this.getCount();
        String samples = Inflector.getInstance().pluralize("sample", count);
        return StringUtil.createString("{0} {1}: min={2}; avg={3}; median={4}; stddev={5}; max={6}", count, samples, this.getMinimum(), this.getMean(), this.getMedian(), this.getStandardDeviation(), this.getMaximum());
    }
}

