/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.stats;

import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.math.Duration;
import org.jboss.dna.common.math.DurationOperations;
import org.jboss.dna.common.stats.DetailedStatistics;
import org.jboss.dna.common.stats.Histogram;
import org.jboss.dna.common.stats.SimpleStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Stopwatch
implements Comparable<Stopwatch> {
    private long lastStarted;
    private final SimpleStatistics<Duration> stats;
    private final DetailedStatistics<Duration> detailedStats;
    private String description;

    public Stopwatch() {
        this(true);
    }

    public Stopwatch(boolean detailedStats) {
        this(detailedStats, null);
    }

    public Stopwatch(boolean detailedStats, String description) {
        this.description = description != null ? description : "";
        this.detailedStats = detailedStats ? new DetailedStatistics<Duration>(new DurationOperations()) : null;
        this.stats = detailedStats ? this.detailedStats : new SimpleStatistics<Duration>(new DurationOperations());
        this.reset();
    }

    public String getDescription() {
        return this.description;
    }

    public void start() {
        if (!this.isRunning()) {
            this.lastStarted = System.nanoTime();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            long duration = System.nanoTime() - this.lastStarted;
            this.lastStarted = 0L;
            this.stats.add(new Duration(duration));
        }
    }

    public int getCount() {
        return this.stats.getCount();
    }

    public boolean isRunning() {
        return this.lastStarted != 0L;
    }

    public Duration getTotalDuration() {
        return this.stats.getTotal();
    }

    public Duration getAverageDuration() {
        return this.stats.getMean();
    }

    public Duration getMedianDuration() {
        return this.detailedStats != null ? this.detailedStats.getMedian() : new Duration(0L);
    }

    public Duration getMinimumDuration() {
        return this.stats.getMinimum();
    }

    public Duration getMaximumDuration() {
        return this.stats.getMaximum();
    }

    public SimpleStatistics<Duration> getSimpleStatistics() {
        return this.stats;
    }

    public DetailedStatistics<Duration> getDetailedStatistics() {
        return this.detailedStats;
    }

    public boolean isDetailedStatistics() {
        return this.detailedStats != null;
    }

    public Histogram<Duration> getHistogram(int numSigmas) {
        return this.detailedStats != null ? this.detailedStats.getHistogram(numSigmas) : new Histogram(this.stats.getMathOperations(), (Number[])new Duration[0]);
    }

    public void reset() {
        this.lastStarted = 0L;
        this.stats.reset();
    }

    @Override
    public int compareTo(Stopwatch that) {
        return this.getTotalDuration().compareTo(that.getTotalDuration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTotalDuration());
        if (this.stats.getCount() > 1) {
            sb.append(" (");
            sb.append(this.stats.getCount()).append(" samples, avg=");
            sb.append(this.getAverageDuration());
            sb.append("; median=");
            sb.append(this.getMedianDuration());
            sb.append("; min=");
            sb.append(this.getMinimumDuration());
            sb.append("; max=");
            sb.append(this.getMaximumDuration());
            sb.append(")");
        }
        return sb.toString();
    }
}

