/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import java.text.StringCharacterIterator;
import java.util.BitSet;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;

@Immutable
public class UrlEncoder
implements TextEncoder,
TextDecoder {
    private static final BitSet RFC2396_UNRESERVED_CHARACTERS = new BitSet(256);
    private static final BitSet RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS;
    public static final char ESCAPE_CHARACTER = '%';
    private boolean slashEncoded = true;

    public String encode(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        BitSet safeChars = this.isSlashEncoded() ? RFC2396_UNRESERVED_CHARACTERS : RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS;
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            if (safeChars.get(c)) {
                result.append(c);
            } else {
                result.append('%');
                result.append(Character.toLowerCase(Character.forDigit(c / 16, 16)));
                result.append(Character.toLowerCase(Character.forDigit(c % 16, 16)));
            }
            c = iter.next();
        }
        return result.toString();
    }

    public String decode(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        if (encodedText.length() == 0) {
            return encodedText;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(encodedText);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char hexChar2;
                boolean foundEscapedCharacter = false;
                char hexChar1 = iter.next();
                char c2 = hexChar2 = hexChar1 != '\uffff' ? (char)iter.next() : (char)'\uffff';
                if (hexChar2 != '\uffff') {
                    int hexNum1 = Character.digit(hexChar1, 16);
                    int hexNum2 = Character.digit(hexChar2, 16);
                    if (hexNum1 > -1 && hexNum2 > -1) {
                        foundEscapedCharacter = true;
                        result.append((char)(hexNum1 * 16 + hexNum2));
                    }
                }
                if (!foundEscapedCharacter) {
                    result.append(c);
                    if (hexChar1 != '\uffff') {
                        result.append(hexChar1);
                    }
                    if (hexChar2 != '\uffff') {
                        result.append(hexChar2);
                    }
                }
            } else {
                result.append(c);
            }
            c = iter.next();
        }
        return result.toString();
    }

    public boolean isSlashEncoded() {
        return this.slashEncoded;
    }

    public UrlEncoder setSlashEncoded(boolean slashEncoded) {
        this.slashEncoded = slashEncoded;
        return this;
    }

    static {
        RFC2396_UNRESERVED_CHARACTERS.set(97, 123);
        RFC2396_UNRESERVED_CHARACTERS.set(65, 91);
        RFC2396_UNRESERVED_CHARACTERS.set(48, 58);
        RFC2396_UNRESERVED_CHARACTERS.set(45);
        RFC2396_UNRESERVED_CHARACTERS.set(95);
        RFC2396_UNRESERVED_CHARACTERS.set(46);
        RFC2396_UNRESERVED_CHARACTERS.set(33);
        RFC2396_UNRESERVED_CHARACTERS.set(126);
        RFC2396_UNRESERVED_CHARACTERS.set(42);
        RFC2396_UNRESERVED_CHARACTERS.set(39);
        RFC2396_UNRESERVED_CHARACTERS.set(40);
        RFC2396_UNRESERVED_CHARACTERS.set(41);
        RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS = (BitSet)RFC2396_UNRESERVED_CHARACTERS.clone();
        RFC2396_UNRESERVED_WITH_SLASH_CHARACTERS.set(47);
    }
}

