/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern NORMALIZE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern PARAMETER_COUNT_PATTERN = Pattern.compile("\\{(\\d+)\\}");
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String combineLines(String[] lines) {
        return StringUtil.combineLines(lines, '\n');
    }

    public static String combineLines(String[] lines, char separator) {
        if (lines == null || lines.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != lines.length; ++i) {
            String line = lines[i];
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(line);
        }
        return sb.toString();
    }

    public static List<String> splitLines(String content) {
        if (content == null || content.length() == 0) {
            return Collections.emptyList();
        }
        String[] lines = content.split("[\\r]?\\n");
        return Arrays.asList(lines);
    }

    public static String createString(String pattern, Object ... parameters) {
        CheckArg.isNotNull(pattern, "pattern");
        if (parameters == null) {
            parameters = EMPTY_STRING_ARRAY;
        }
        Matcher matcher = PARAMETER_COUNT_PATTERN.matcher(pattern);
        StringBuffer text = new StringBuffer();
        int requiredParameterCount = 0;
        boolean err = false;
        while (matcher.find()) {
            int ndx = Integer.valueOf(matcher.group(1));
            if (requiredParameterCount <= ndx) {
                requiredParameterCount = ndx + 1;
            }
            if (ndx >= parameters.length) {
                err = true;
                matcher.appendReplacement(text, matcher.group());
                continue;
            }
            List<Object> parameter = parameters[ndx];
            if (parameter != null && parameter.getClass().isArray()) {
                parameter = Arrays.asList((Object[])parameter);
            }
            matcher.appendReplacement(text, Matcher.quoteReplacement(parameter == null ? "null" : parameter.toString()));
        }
        if (err || requiredParameterCount < parameters.length) {
            throw new IllegalArgumentException(CommonI18n.requiredToSuppliedParameterMismatch.text(parameters.length, parameters.length == 1 ? "" : "s", requiredParameterCount, requiredParameterCount == 1 ? "" : "s", pattern, text.toString()));
        }
        matcher.appendTail(text);
        return text.toString();
    }

    public static String createString(char charToRepeat, int numberOfRepeats) {
        assert (numberOfRepeats >= 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfRepeats; ++i) {
            sb.append(charToRepeat);
        }
        return sb.toString();
    }

    public static String setLength(String original, int length, char padChar) {
        return StringUtil.justifyLeft(original, length, padChar, false);
    }

    public static String justifyRight(String str, int width, char padWithChar) {
        assert (width > 0);
        int length = (str = str != null ? str.trim() : "").length();
        int addChars = width - length;
        if (addChars < 0) {
            return ((Object)str.subSequence(length - width, length)).toString();
        }
        StringBuilder sb = new StringBuilder();
        while (addChars > 0) {
            sb.append(padWithChar);
            --addChars;
        }
        sb.append(str);
        return sb.toString();
    }

    public static String justifyLeft(String str, int width, char padWithChar) {
        return StringUtil.justifyLeft(str, width, padWithChar, true);
    }

    protected static String justifyLeft(String str, int width, char padWithChar, boolean trimWhitespace) {
        int addChars;
        str = str != null ? (trimWhitespace ? str.trim() : str) : "";
        if (addChars < 0) {
            return ((Object)str.subSequence(0, width)).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        for (addChars = width - str.length(); addChars > 0; --addChars) {
            sb.append(padWithChar);
        }
        return sb.toString();
    }

    public static String justifyCenter(String str, int width, char padWithChar) {
        int prependNumber;
        int addChars = width - (str = str != null ? str.trim() : "").length();
        if (addChars < 0) {
            return ((Object)str.subSequence(0, width)).toString();
        }
        int appendNumber = prependNumber = addChars / 2;
        if (prependNumber + appendNumber != addChars) {
            ++prependNumber;
        }
        StringBuilder sb = new StringBuilder();
        while (prependNumber > 0) {
            sb.append(padWithChar);
            --prependNumber;
        }
        sb.append(str);
        while (appendNumber > 0) {
            sb.append(padWithChar);
            --appendNumber;
        }
        return sb.toString();
    }

    public static String truncate(Object obj, int maxLength) {
        return StringUtil.truncate(obj, maxLength, null);
    }

    public static String truncate(Object obj, int maxLength, String suffix) {
        int maxNumChars;
        CheckArg.isNonNegative(maxLength, "maxLength");
        if (obj == null || maxLength == 0) {
            return "";
        }
        String str = obj.toString();
        if (str.length() <= maxLength) {
            return str;
        }
        if (suffix == null) {
            suffix = "...";
        }
        if ((maxNumChars = maxLength - suffix.length()) < 0) {
            str = suffix.substring(0, maxLength);
        } else if (str.length() > maxNumChars) {
            str = str.substring(0, maxNumChars) + suffix;
        }
        return str;
    }

    public static String read(Reader reader) throws IOException {
        return IoUtil.read(reader);
    }

    public static String read(InputStream stream) throws IOException {
        return IoUtil.read(stream);
    }

    public static void write(String content, OutputStream stream) throws IOException {
        IoUtil.write(content, stream);
    }

    public static void write(String content, Writer writer) throws IOException {
        IoUtil.write(content, writer);
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bas);
        throwable.printStackTrace(pw);
        pw.close();
        return bas.toString();
    }

    public static String normalize(String text) {
        CheckArg.isNotNull(text, "text");
        return NORMALIZE_PATTERN.matcher(text).replaceAll(" ").trim();
    }

    public static String getHexString(byte[] bytes) throws UnsupportedEncodingException {
        byte[] hex = new byte[2 * bytes.length];
        int index = 0;
        for (byte b : bytes) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex, "ASCII");
    }

    private StringUtil() {
    }
}

