/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.component;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.component.ClassLoaderFactory;

@Immutable
public class StandardClassLoaderFactory
implements ClassLoaderFactory {
    private final ClassLoader delegate;
    private final boolean useCurrentThreadContextClassLoader;

    public StandardClassLoaderFactory() {
        this(true, null);
    }

    public StandardClassLoaderFactory(ClassLoader delegate) {
        this(true, delegate);
    }

    public StandardClassLoaderFactory(boolean useCurrentThreadContextClassLoader, ClassLoader delegate) {
        this.delegate = delegate != null ? delegate : this.getClass().getClassLoader();
        this.useCurrentThreadContextClassLoader = useCurrentThreadContextClassLoader;
    }

    public ClassLoader getClassLoader(String ... classpath) {
        ClassLoader result = null;
        if (this.useCurrentThreadContextClassLoader) {
            result = Thread.currentThread().getContextClassLoader();
        }
        if (result == null) {
            result = this.delegate;
        }
        return result;
    }
}

