/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.i18n;

import java.net.URL;
import java.util.Locale;
import org.jboss.dna.common.i18n.LocalizationRepository;

public class ClasspathLocalizationRepository
implements LocalizationRepository {
    private final ClassLoader classLoader;

    public ClasspathLocalizationRepository() {
        this(null);
    }

    public ClasspathLocalizationRepository(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public URL getLocalizationBundle(String bundleName, Locale locale) {
        URL url = null;
        String pathPfx = bundleName.replaceAll("\\.", "/");
        String variant = '_' + locale.toString();
        do {
            if ((url = this.classLoader.getResource(pathPfx + variant + ".properties")) != null) continue;
            int ndx = variant.lastIndexOf(95);
            if (ndx < 0) break;
            variant = variant.substring(0, ndx);
        } while (url == null);
        return url;
    }
}

