/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import java.util.BitSet;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.UrlEncoder;

@Immutable
public class FilenameEncoder
extends UrlEncoder {
    private static final BitSet SAFE_CHARACTERS = new BitSet(256);
    private static final BitSet SAFE_WITH_SLASH_CHARACTERS;
    public static final char ESCAPE_CHARACTER = '%';

    public String encode(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        return this.encode(text, this.isSlashEncoded() ? SAFE_CHARACTERS : SAFE_WITH_SLASH_CHARACTERS);
    }

    public FilenameEncoder setSlashEncoded(boolean slashEncoded) {
        super.setSlashEncoded(slashEncoded);
        return this;
    }

    static {
        SAFE_CHARACTERS.set(97, 123);
        SAFE_CHARACTERS.set(65, 91);
        SAFE_CHARACTERS.set(48, 58);
        SAFE_CHARACTERS.set(45);
        SAFE_CHARACTERS.set(95);
        SAFE_CHARACTERS.set(46);
        SAFE_CHARACTERS.set(33);
        SAFE_CHARACTERS.set(126);
        SAFE_CHARACTERS.set(39);
        SAFE_CHARACTERS.set(40);
        SAFE_CHARACTERS.set(41);
        SAFE_WITH_SLASH_CHARACTERS = (BitSet)SAFE_CHARACTERS.clone();
        SAFE_WITH_SLASH_CHARACTERS.set(47);
    }
}

