/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import java.text.StringCharacterIterator;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;

@Immutable
public class Jsr283Encoder
implements TextEncoder,
TextDecoder {
    public String encode(String publicName) {
        if (publicName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(publicName);
        int c = iter.first();
        while (c != 65535) {
            int mapped = c;
            if (c == 42) {
                mapped = 61482;
            } else if (c == 47) {
                mapped = 61487;
            } else if (c == 58) {
                mapped = 61498;
            } else if (c == 91) {
                mapped = 61531;
            } else if (c == 93) {
                mapped = 61533;
            } else if (c == 124) {
                mapped = 61564;
            }
            sb.append((char)mapped);
            c = iter.next();
        }
        return sb.toString();
    }

    public String decode(String jcrNodeName) {
        if (jcrNodeName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(jcrNodeName);
        int c = iter.first();
        while (c != 65535) {
            int mapped = c;
            if (c == 61482) {
                mapped = 42;
            } else if (c == 61487) {
                mapped = 47;
            } else if (c == 61498) {
                mapped = 58;
            } else if (c == 61531) {
                mapped = 91;
            } else if (c == 61533) {
                mapped = 93;
            } else if (c == 61564) {
                mapped = 124;
            }
            sb.append((char)mapped);
            c = iter.next();
        }
        return sb.toString();
    }
}

