/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MimeTypeUtil {
    public static final String MIME_TYPE_EXTENSIONS_RESOURCE_PATH = "org/jboss/dna/mime.types";
    private final Map<String, String> mimeTypesByExtension;

    public MimeTypeUtil() {
        this(null, true);
    }

    public MimeTypeUtil(Map<String, String> extensionsToMimeTypes) {
        this(extensionsToMimeTypes, true);
    }

    public MimeTypeUtil(Map<String, String> extensionsToMimeTypes, boolean initWithDefaults) {
        HashMap<String, String> mappings;
        HashMap<String, String> hashMap = mappings = initWithDefaults ? MimeTypeUtil.getDefaultMappings() : new HashMap<String, String>();
        if (extensionsToMimeTypes != null) {
            for (Map.Entry<String, String> entry : extensionsToMimeTypes.entrySet()) {
                String mimeType;
                String extensionString = entry.getKey();
                if (extensionString == null || (extensionString = extensionString.toLowerCase().trim().replaceAll("^[.]+", "")).length() == 0 || (mimeType = entry.getValue()) == null || (mimeType = entry.getValue().trim()).length() == 0) continue;
                assert (extensionString.length() != 0);
                assert (mimeType.length() != 0);
                mappings.put(extensionString, mimeType);
            }
        }
        HashMap<String, String> mappingsByAnyCharExtension = new HashMap<String, String>();
        for (Map.Entry entry : mappings.entrySet()) {
            String extensionString = (String)entry.getKey();
            String mimeType = (String)entry.getValue();
            assert (extensionString != null);
            assert (extensionString.length() != 0);
            assert (mimeType != null);
            assert (mimeType.length() != 0);
            mappingsByAnyCharExtension.put("." + extensionString, mimeType);
        }
        this.mimeTypesByExtension = Collections.unmodifiableMap(mappingsByAnyCharExtension);
    }

    protected static Map<String, String> getDefaultMappings() {
        HashMap<String, Set<String>> duplicates = new HashMap<String, Set<String>>();
        return MimeTypeUtil.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(MIME_TYPE_EXTENSIONS_RESOURCE_PATH), duplicates);
    }

    public static Map<String, String> load(InputStream stream, Map<String, Set<String>> duplicateMimeTypesByExtension) {
        CheckArg.isNotNull(stream, "stream");
        Pattern linePattern = Pattern.compile("\\s*([^\\s=]+)\\s*=?\\s*(.*)");
        List<String> lines = null;
        try {
            String content = IoUtil.read(stream);
            lines = StringUtil.splitLines(content);
        }
        catch (IOException e) {
            I18n msg = CommonI18n.unableToAccessResourceFileFromClassLoader;
            Logger.getLogger(MimeTypeUtil.class).warn(e, msg, MIME_TYPE_EXTENSIONS_RESOURCE_PATH);
        }
        HashMap<String, String> mimeTypesByExtension = new HashMap<String, String>();
        if (lines != null) {
            for (String line : lines) {
                Matcher matcher;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(matcher = linePattern.matcher(line)).matches()) continue;
                String mimeType = matcher.group(1).trim().toLowerCase();
                String extensions = matcher.group(2).trim().toLowerCase();
                if (extensions.length() == 0) continue;
                for (String extensionString : extensions.split("\\s+")) {
                    String existingMimeType;
                    if ((extensionString = extensionString.trim()).length() == 0 || (existingMimeType = mimeTypesByExtension.put(extensionString, mimeType)) == null) continue;
                    mimeTypesByExtension.put(extensionString, existingMimeType);
                    if (duplicateMimeTypesByExtension == null) continue;
                    Set<String> dups = duplicateMimeTypesByExtension.get(extensionString);
                    if (dups == null) {
                        dups = new HashSet<String>();
                        duplicateMimeTypesByExtension.put(extensionString, dups);
                    }
                    dups.add(existingMimeType);
                    dups.add(mimeType);
                }
            }
        }
        return mimeTypesByExtension;
    }

    public String mimeTypeOf(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        String trimmedName = filename.trim();
        if (trimmedName.length() == 0) {
            return null;
        }
        int indexOfDelimiter = trimmedName.lastIndexOf(46);
        if (indexOfDelimiter < 0) {
            return null;
        }
        String extension = trimmedName.substring(indexOfDelimiter).toLowerCase();
        return this.mimeTypesByExtension.get(extension);
    }

    public String mimeTypeOf(File file) {
        if (file == null) {
            return null;
        }
        return this.mimeTypeOf(file.getName());
    }
}

