/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.FederatedRepositoryConfig;
import org.jboss.dna.connector.federation.FederatedRepositoryConnection;
import org.jboss.dna.connector.federation.executor.FederatingCommandExecutor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.commands.executor.CommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.graph.connectors.RepositorySourceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederatedRepository {
    private final ExecutionContext context;
    private final RepositoryConnectionFactory connectionFactory;
    private FederatedRepositoryConfig config;
    private final AtomicInteger openExecutors = new AtomicInteger(0);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<RepositorySourceListener> listeners = new CopyOnWriteArrayList();

    public FederatedRepository(ExecutionContext context, RepositoryConnectionFactory connectionFactory, FederatedRepositoryConfig config) {
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)config, (String)"config");
        this.context = context;
        this.connectionFactory = connectionFactory;
        this.config = config;
    }

    public String getName() {
        return this.config.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public synchronized void start() {
    }

    public boolean isRunning() {
        return !this.shutdownRequested.get();
    }

    public synchronized void shutdown() {
        this.shutdownRequested.set(true);
        if (this.openExecutors.get() <= 0) {
            this.shutdownLatch.countDown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    public boolean isTerminated() {
        return this.openExecutors.get() != 0;
    }

    public boolean addListener(RepositorySourceListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(RepositorySourceListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    public List<RepositorySourceListener> getListeners() {
        return this.listeners;
    }

    public RepositoryConnection createConnection(RepositorySource source, String username, Object credentials) {
        return new FederatedRepositoryConnection(this, source.getName());
    }

    public FederatedRepositoryConfig getConfiguration() {
        return this.config;
    }

    public void setConfiguration(FederatedRepositoryConfig config) {
        CheckArg.isNotNull((Object)config, (String)"config");
        this.config = config;
    }

    protected CommandExecutor getExecutor(ExecutionContext context, String sourceName) {
        FederatedRepositoryConfig config = this.getConfiguration();
        return new FederatingCommandExecutor(context, sourceName, config.getCacheProjection(), config.getDefaultCachePolicy(), config.getSourceProjections(), this.getConnectionFactory());
    }

    void register(FederatedRepositoryConnection connection) {
        this.openExecutors.incrementAndGet();
    }

    void unregister(FederatedRepositoryConnection connection) {
        if (this.openExecutors.decrementAndGet() <= 0 && this.shutdownRequested.get()) {
            this.shutdownLatch.countDown();
        }
    }
}

