/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.federation.FederatedRepository;
import org.jboss.dna.connector.federation.FederatedRepositoryConfig;
import org.jboss.dna.connector.federation.FederationException;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.ProjectionParser;
import org.jboss.dna.connector.federation.executor.FederatingCommandExecutor;
import org.jboss.dna.connector.federation.executor.SingleProjectionCommandExecutor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.ExecutionContextFactory;
import org.jboss.dna.graph.cache.BasicCachePolicy;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.CompositeCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.basic.BasicCompositeCommand;
import org.jboss.dna.graph.commands.basic.BasicGetChildrenCommand;
import org.jboss.dna.graph.commands.basic.BasicGetNodeCommand;
import org.jboss.dna.graph.commands.executor.CommandExecutor;
import org.jboss.dna.graph.commands.executor.LoggingCommandExecutor;
import org.jboss.dna.graph.commands.executor.NoOpCommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositoryContext;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.graph.connectors.RepositorySourceCapabilities;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.InvalidPathException;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederatedRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 7587346948013486977L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_CONFIGURATION_SOURCE_PATH = "/";
    protected static final String REPOSITORY_NAME = "repositoryName";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String CONFIGURATION_SOURCE_NAME = "configurationSourceName";
    protected static final String CONFIGURATION_SOURCE_PATH = "configurationSourcePath";
    protected static final String SECURITY_DOMAIN = "securityDomain";
    protected static final String RETRY_LIMIT = "retryLimit";
    public static final String PATH_TO_CONFIGURATION_INFORMATION = "/dna:system/dna:federation";
    public static final String DNA_CACHE_SEGMENT = "dna:cache";
    public static final String DNA_PROJECTIONS_SEGMENT = "dna:projections";
    public static final String PROJECTION_RULES_CONFIG_PROPERTY_NAME = "dna:projectionRules";
    public static final String CACHE_POLICY_TIME_TO_LIVE_CONFIG_PROPERTY_NAME = "dna:timeToCache";
    private String repositoryName;
    private String sourceName;
    private String username;
    private String password;
    private String configurationSourceName;
    private String configurationSourcePath = "/";
    private String securityDomain;
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private transient FederatedRepository repository;
    private transient RepositoryContext repositoryContext;

    public FederatedRepositorySource() {
    }

    public FederatedRepositorySource(String repositoryName) {
        CheckArg.isNotNull((Object)repositoryName, (String)REPOSITORY_NAME);
        this.repositoryName = repositoryName;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public synchronized String getName() {
        return this.sourceName;
    }

    public synchronized void setName(String sourceName) {
        if (this.sourceName == sourceName || this.sourceName != null && this.sourceName.equals(sourceName)) {
            return;
        }
        this.sourceName = sourceName;
        this.changeRepositoryConfig();
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public String getConfigurationSourceName() {
        return this.configurationSourceName;
    }

    public void setConfigurationSourceName(String sourceName) {
        if (this.configurationSourceName == sourceName || this.configurationSourceName != null && this.configurationSourceName.equals(sourceName)) {
            return;
        }
        this.configurationSourceName = sourceName;
        this.changeRepositoryConfig();
    }

    public String getConfigurationSourcePath() {
        return this.configurationSourcePath;
    }

    public void setConfigurationSourcePath(String pathInSourceToConfigurationRoot) {
        if (this.configurationSourcePath == pathInSourceToConfigurationRoot || this.configurationSourcePath != null && this.configurationSourcePath.equals(pathInSourceToConfigurationRoot)) {
            return;
        }
        this.configurationSourcePath = pathInSourceToConfigurationRoot != null ? pathInSourceToConfigurationRoot : DEFAULT_CONFIGURATION_SOURCE_PATH;
        this.changeRepositoryConfig();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        if (this.securityDomain != null && this.securityDomain.equals(securityDomain)) {
            return;
        }
        this.securityDomain = securityDomain;
        this.changeRepositoryConfig();
    }

    public synchronized String getRepositoryName() {
        return this.repositoryName;
    }

    public synchronized void setRepositoryName(String repositoryName) {
        CheckArg.isNotEmpty((String)repositoryName, (String)REPOSITORY_NAME);
        if (this.repositoryName != null && this.repositoryName.equals(repositoryName)) {
            return;
        }
        this.repositoryName = repositoryName;
        this.changeRepositoryConfig();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.username != null && this.username.equals(username)) {
            return;
        }
        this.username = username;
        this.changeRepositoryConfig();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (this.password != null && this.password.equals(password)) {
            return;
        }
        this.password = password;
        this.changeRepositoryConfig();
    }

    protected synchronized void changeRepositoryConfig() {
        RepositoryContext repositoryContext;
        if (this.repository != null && (repositoryContext = this.getRepositoryContext()) != null) {
            ExecutionContext context = this.getExecutionContext();
            RepositoryConnectionFactory factory = this.getRepositoryContext().getRepositoryConnectionFactory();
            FederatedRepositoryConfig newConfig = this.getRepositoryConfiguration(context, factory);
            this.repository.setConfiguration(newConfig);
        }
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        String credentials;
        String username;
        if (this.getName() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.getRepositoryContext() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"repository context"}));
        }
        if (this.getUsername() != null && this.getSecurityDomain() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"security domain"}));
        }
        FederatedRepository repository = this.getRepository();
        RepositoryConnection connection = repository.createConnection(this, username = this.username, credentials = this.password);
        if (connection == null) {
            I18n msg = FederationI18n.unableToAuthenticateConnectionToFederatedRepository;
            throw new RepositorySourceException(msg.text(new Object[]{this.repositoryName, username}));
        }
        return connection;
    }

    protected synchronized FederatedRepository getRepository() throws RepositorySourceException {
        if (this.repository == null) {
            ExecutionContext context = this.getExecutionContext();
            RepositoryConnectionFactory connectionFactory = this.getRepositoryContext().getRepositoryConnectionFactory();
            FederatedRepositoryConfig config = this.getRepositoryConfiguration(context, connectionFactory);
            this.repository = new FederatedRepository(context, connectionFactory, config);
        }
        return this.repository;
    }

    protected ExecutionContext getExecutionContext() {
        ExecutionContextFactory factory = this.getRepositoryContext().getExecutionContextFactory();
        CallbackHandler handler = this.createCallbackHandler();
        try {
            String securityDomain = this.getSecurityDomain();
            if (securityDomain != null || this.getUsername() != null) {
                return factory.create(securityDomain, handler);
            }
            return factory.create();
        }
        catch (LoginException e) {
            I18n msg = FederationI18n.unableToCreateExecutionContext;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{this.sourceName, this.securityDomain}), (Throwable)e);
        }
    }

    protected CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(FederatedRepositorySource.this.getUsername());
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(FederatedRepositorySource.this.getPassword().toCharArray());
                }
            }
        };
    }

    protected synchronized FederatedRepositoryConfig getRepositoryConfiguration(ExecutionContext context, RepositoryConnectionFactory connectionFactory) {
        FederatedRepositoryConfig federatedRepositoryConfig;
        SimpleProblems problems = new SimpleProblems();
        ValueFactories valueFactories = context.getValueFactories();
        PathFactory pathFactory = valueFactories.getPathFactory();
        NameFactory nameFactory = valueFactories.getNameFactory();
        ValueFactory longFactory = valueFactories.getLongFactory();
        ProjectionParser projectionParser = ProjectionParser.getInstance();
        String ruleStr = "/dna:system => " + this.getConfigurationSourcePath();
        Projection.Rule[] rules = projectionParser.rulesFromStrings(context, ruleStr);
        Projection configurationProjection = new Projection(this.getConfigurationSourceName(), rules);
        String configurationSourceName = configurationProjection.getSourceName();
        List<Projection> projections = Collections.singletonList(configurationProjection);
        Object executor = null;
        executor = configurationProjection.getRules().size() == 0 ? new NoOpCommandExecutor(context, configurationSourceName) : (configurationProjection.isSimple() ? new SingleProjectionCommandExecutor(context, configurationSourceName, configurationProjection, connectionFactory) : new FederatingCommandExecutor(context, configurationSourceName, projections, connectionFactory));
        executor = new LoggingCommandExecutor((CommandExecutor)executor, context.getLogger(this.getClass()), Logger.Level.DEBUG);
        Path configNode = (Path)pathFactory.create(PATH_TO_CONFIGURATION_INFORMATION);
        try {
            BasicGetNodeCommand getRepository = new BasicGetNodeCommand(configNode);
            executor.execute((GetNodeCommand)getRepository);
            if (getRepository.hasError()) {
                throw new FederationException(FederationI18n.federatedRepositoryCannotBeFound.text(new Object[]{this.repositoryName}));
            }
            Path cacheNode = pathFactory.create(configNode, new org.jboss.dna.graph.properties.Name[]{(org.jboss.dna.graph.properties.Name)nameFactory.create(DNA_CACHE_SEGMENT)});
            BasicGetChildrenCommand getCacheSource = new BasicGetChildrenCommand(cacheNode);
            executor.execute((GetChildrenCommand)getCacheSource);
            if (getCacheSource.hasError() || getCacheSource.getChildren().size() < 1) {
                I18n msg = FederationI18n.requiredNodeDoesNotExistRelativeToNode;
                throw new FederationException(msg.text(new Object[]{DNA_CACHE_SEGMENT, configNode}));
            }
            Path pathToCacheRegion = pathFactory.create(cacheNode, new Path.Segment[]{(Path.Segment)getCacheSource.getChildren().get(0)});
            BasicGetNodeCommand getCacheRegion = new BasicGetNodeCommand(pathToCacheRegion);
            executor.execute((GetNodeCommand)getCacheRegion);
            Projection cacheProjection = this.createProjection(context, projectionParser, getCacheRegion.getPath(), getCacheRegion.getPropertiesByName(), (Problems)problems);
            if (getCacheRegion.hasError()) {
                I18n msg = FederationI18n.requiredNodeDoesNotExistRelativeToNode;
                throw new FederationException(msg.text(new Object[]{DNA_CACHE_SEGMENT, configNode}));
            }
            Path projectionsNode = pathFactory.create(configNode, new org.jboss.dna.graph.properties.Name[]{(org.jboss.dna.graph.properties.Name)nameFactory.create(DNA_PROJECTIONS_SEGMENT)});
            BasicGetChildrenCommand getProjections = new BasicGetChildrenCommand(projectionsNode);
            executor.execute((GetChildrenCommand)getProjections);
            if (getProjections.hasError()) {
                I18n msg = FederationI18n.requiredNodeDoesNotExistRelativeToNode;
                throw new FederationException(msg.text(new Object[]{DNA_PROJECTIONS_SEGMENT, configNode}));
            }
            LinkedList<Projection> sourceProjections = new LinkedList<Projection>();
            if (getProjections.hasNoError() && !getProjections.getChildren().isEmpty()) {
                BasicCompositeCommand commands = new BasicCompositeCommand();
                for (Path.Segment child : getProjections.getChildren()) {
                    Path pathToSource = pathFactory.create(projectionsNode, new Path.Segment[]{child});
                    commands.add((GraphCommand)new BasicGetNodeCommand(pathToSource));
                }
                executor.execute((CompositeCommand)commands);
                for (GraphCommand command : commands) {
                    Projection projection;
                    BasicGetNodeCommand getProjectionCommand = (BasicGetNodeCommand)command;
                    if (!getProjectionCommand.hasNoError() || (projection = this.createProjection(context, projectionParser, getProjectionCommand.getPath(), getProjectionCommand.getPropertiesByName(), (Problems)problems)) == null) continue;
                    Logger logger = context.getLogger(this.getClass());
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding projection to federated repository {0}: {1}", new Object[]{this.getRepositoryName(), projection});
                    }
                    sourceProjections.add(projection);
                }
            }
            BasicCachePolicy cachePolicy = new BasicCachePolicy();
            Property timeToLiveProperty = (Property)getRepository.getPropertiesByName().get(nameFactory.create(CACHE_POLICY_TIME_TO_LIVE_CONFIG_PROPERTY_NAME));
            if (timeToLiveProperty != null && !timeToLiveProperty.isEmpty()) {
                cachePolicy.setTimeToLive(((Long)longFactory.create(timeToLiveProperty.getValues().next())).longValue(), TimeUnit.MILLISECONDS);
            }
            CachePolicy defaultCachePolicy = cachePolicy.isEmpty() ? null : cachePolicy.getUnmodifiable();
            federatedRepositoryConfig = new FederatedRepositoryConfig(this.repositoryName, cacheProjection, sourceProjections, defaultCachePolicy);
            Object var32_36 = null;
        }
        catch (InvalidPathException err) {
            try {
                I18n msg = FederationI18n.federatedRepositoryCannotBeFound;
                throw new FederationException(msg.text(new Object[]{this.repositoryName}));
            }
            catch (Throwable throwable) {
                Object var32_37 = null;
                executor.close();
                throw throwable;
            }
        }
        executor.close();
        return federatedRepositoryConfig;
    }

    protected Projection createProjection(ExecutionContext context, ProjectionParser projectionParser, Path path, Map<org.jboss.dna.graph.properties.Name, Property> properties, Problems problems) {
        String[] projectionRuleStrs;
        ValueFactories valueFactories = context.getValueFactories();
        NameFactory nameFactory = valueFactories.getNameFactory();
        ValueFactory stringFactory = valueFactories.getStringFactory();
        String sourceName = path.getLastSegment().getName().getLocalName();
        Projection.Rule[] projectionRules = null;
        Property projectionRulesProperty = properties.get(nameFactory.create(PROJECTION_RULES_CONFIG_PROPERTY_NAME));
        if (projectionRulesProperty != null && !projectionRulesProperty.isEmpty() && (projectionRuleStrs = (String[])stringFactory.create(projectionRulesProperty.getValuesAsArray())) != null && projectionRuleStrs.length != 0) {
            projectionRules = projectionParser.rulesFromStrings(context, projectionRuleStrs);
        }
        if (problems.hasErrors()) {
            return null;
        }
        Projection region = new Projection(sourceName, projectionRules);
        return region;
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getRepositoryName() != null) {
            ref.add(new StringRefAddr(REPOSITORY_NAME, this.getRepositoryName()));
        }
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getUsername() != null) {
            ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        }
        if (this.getPassword() != null) {
            ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        }
        if (this.getConfigurationSourceName() != null) {
            ref.add(new StringRefAddr(CONFIGURATION_SOURCE_NAME, this.getConfigurationSourceName()));
        }
        if (this.getConfigurationSourcePath() != null) {
            ref.add(new StringRefAddr(CONFIGURATION_SOURCE_PATH, this.getConfigurationSourcePath()));
        }
        if (this.getSecurityDomain() != null) {
            ref.add(new StringRefAddr(SECURITY_DOMAIN, this.getSecurityDomain()));
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, String> values = new HashMap<String, String>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr subref = en.nextElement();
                if (!(subref instanceof StringRefAddr)) continue;
                String key = subref.getType();
                Object value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
            }
            String repositoryName = (String)values.get(REPOSITORY_NAME);
            String sourceName = (String)values.get(SOURCE_NAME);
            String username = (String)values.get(USERNAME);
            String password = (String)values.get(PASSWORD);
            String configurationSourceName = (String)values.get(CONFIGURATION_SOURCE_NAME);
            String configurationSourcePath = (String)values.get(CONFIGURATION_SOURCE_PATH);
            String securityDomain = (String)values.get(SECURITY_DOMAIN);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            FederatedRepositorySource source = new FederatedRepositorySource();
            if (repositoryName != null) {
                source.setRepositoryName(repositoryName);
            }
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (username != null) {
                source.setUsername(username);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (configurationSourceName != null) {
                source.setConfigurationSourceName(configurationSourceName);
            }
            if (configurationSourcePath != null) {
                source.setConfigurationSourcePath(configurationSourcePath);
            }
            if (securityDomain != null) {
                source.setSecurityDomain(securityDomain);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    public int hashCode() {
        return this.repositoryName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedRepositorySource) {
            FederatedRepositorySource that = (FederatedRepositorySource)obj;
            if (!this.getRepositoryName().equals(that.getRepositoryName())) {
                return false;
            }
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new Capabilities();
    }

    protected class Capabilities
    implements RepositorySourceCapabilities {
        protected Capabilities() {
        }

        public boolean supportsSameNameSiblings() {
            return true;
        }

        public boolean supportsUpdates() {
            return true;
        }
    }
}

