/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionStatistics {
    static final boolean RECORD = false;
    private static final ConcurrentMap<Stats, AtomicLong> DATA = new ConcurrentHashMap<Stats, AtomicLong>();

    static void record(int propertyCount, int childrenCount) {
        Stats key = new Stats(propertyCount, childrenCount);
        AtomicLong existing = DATA.putIfAbsent(key, new AtomicLong(1L));
        if (existing != null) {
            existing.incrementAndGet();
        }
    }

    public boolean isRecording() {
        return false;
    }

    public static Map<Stats, AtomicLong> getData() {
        return new HashMap<Stats, AtomicLong>(DATA);
    }

    public static List<Data> getTop(int n) {
        CheckArg.isPositive((int)n, (String)"n");
        LinkedList<Data> results = new LinkedList<Data>();
        for (Map.Entry entry : DATA.entrySet()) {
            long value = ((AtomicLong)entry.getValue()).get();
            if (results.size() >= n) {
                Data last = results.getLast();
                if (value <= last.getInstanceCount()) continue;
                results.removeLast();
            }
            results.add(new Data((Stats)entry.getKey(), value));
            Collections.sort(results);
        }
        return results;
    }

    public static final class Stats {
        private final int propertyCount;
        private final int childrenCount;

        protected Stats(int propertyCount, int childrenCount) {
            this.propertyCount = propertyCount;
            this.childrenCount = childrenCount;
        }

        public int getChildrenCount() {
            return this.childrenCount;
        }

        public int getPropertyCount() {
            return this.propertyCount;
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.propertyCount, this.childrenCount});
        }

        public boolean equals(Object obj) {
            if (obj instanceof Stats) {
                Stats that = (Stats)obj;
                if (this.propertyCount != that.propertyCount) {
                    return false;
                }
                return this.childrenCount == that.childrenCount;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Data
    implements Comparable<Data> {
        private final int propertyCount;
        private final int childrenCount;
        private final long instanceCount;

        protected Data(Stats stats, long instanceCount) {
            this.propertyCount = stats.getPropertyCount();
            this.childrenCount = stats.getChildrenCount();
            this.instanceCount = instanceCount;
        }

        public int getChildrenCount() {
            return this.childrenCount;
        }

        public int getPropertyCount() {
            return this.propertyCount;
        }

        public long getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public int compareTo(Data that) {
            long diff = that.getInstanceCount() - this.getInstanceCount();
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.propertyCount, this.childrenCount, this.instanceCount});
        }

        public boolean equals(Object obj) {
            if (obj instanceof Data) {
                Data that = (Data)obj;
                if (this.propertyCount != that.propertyCount) {
                    return false;
                }
                if (this.childrenCount != that.childrenCount) {
                    return false;
                }
                return this.instanceCount == that.instanceCount;
            }
            return false;
        }

        public String toString() {
            return "(# props=" + this.getPropertyCount() + ", # children=" + this.getChildrenCount() + ") => " + this.getInstanceCount();
        }
    }
}

