/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.OneContributionMergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.SimpleMergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.NodeConflictBehavior;
import org.jboss.dna.graph.commands.basic.BasicCreateNodeCommand;
import org.jboss.dna.graph.commands.basic.BasicGetNodeCommand;
import org.jboss.dna.graph.commands.executor.AbstractCommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.basic.BasicSingleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class FederatingCommandExecutor
extends AbstractCommandExecutor {
    private final Name uuidPropertyName;
    private final Name mergePlanPropertyName;
    private final CachePolicy defaultCachePolicy;
    private final Projection cacheProjection;
    private final List<Projection> sourceProjections;
    private final Set<String> sourceNames;
    private final RepositoryConnectionFactory connectionFactory;
    private MergeStrategy mergingStrategy;
    private final Map<String, RepositoryConnection> connectionsBySourceName;
    private RepositoryConnection cacheConnection;
    private Logger logger;

    public FederatingCommandExecutor(ExecutionContext context, String sourceName, List<Projection> sourceProjections, RepositoryConnectionFactory connectionFactory) {
        this(context, sourceName, null, null, sourceProjections, connectionFactory);
    }

    public FederatingCommandExecutor(ExecutionContext context, String sourceName, Projection cacheProjection, CachePolicy defaultCachePolicy, List<Projection> sourceProjections, RepositoryConnectionFactory connectionFactory) {
        super(context, sourceName);
        assert (sourceProjections != null);
        assert (connectionFactory != null);
        assert (cacheProjection == null ? defaultCachePolicy == null : defaultCachePolicy != null);
        this.cacheProjection = cacheProjection;
        this.defaultCachePolicy = defaultCachePolicy;
        this.sourceProjections = sourceProjections;
        this.connectionFactory = connectionFactory;
        this.logger = context.getLogger(((Object)((Object)this)).getClass());
        this.connectionsBySourceName = new HashMap<String, RepositoryConnection>();
        this.uuidPropertyName = (Name)context.getValueFactories().getNameFactory().create(DnaLexicon.UUID);
        this.mergePlanPropertyName = (Name)context.getValueFactories().getNameFactory().create(DnaLexicon.MERGE_PLAN);
        this.sourceNames = new HashSet<String>();
        for (Projection projection : this.sourceProjections) {
            this.sourceNames.add(projection.getSourceName());
        }
        this.setMergingStrategy(null);
    }

    public void setMergingStrategy(MergeStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy != null ? mergingStrategy : (this.sourceProjections.size() == 1 && this.sourceProjections.get(0).isSimple() ? new OneContributionMergeStrategy() : new SimpleMergeStrategy());
        assert (this.mergingStrategy != null);
    }

    public List<Projection> getSourceProjections() {
        return Collections.unmodifiableList(this.sourceProjections);
    }

    public Projection getCacheProjection() {
        return this.cacheProjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        super.close();
        Object var2_1 = null;
        for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
            if (connection == null) continue;
            try {
                connection.close();
            }
            catch (Throwable t) {
                this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
            }
        }
        this.connectionsBySourceName.clear();
        try {
            if (this.cacheConnection != null) {
                this.cacheConnection.close();
            }
            Object var7_9 = null;
            this.cacheConnection = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.cacheConnection = null;
            throw throwable;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
                }
            }
            this.connectionsBySourceName.clear();
            try {
                if (this.cacheConnection != null) {
                    this.cacheConnection.close();
                }
                Object var7_11 = null;
                this.cacheConnection = null;
            }
            catch (Throwable throwable2) {
                Object var7_12 = null;
                this.cacheConnection = null;
                throw throwable2;
            }
            throw throwable;
        }
    }

    protected RepositoryConnection getConnectionToCache() throws RepositorySourceException {
        if (this.cacheConnection == null) {
            this.cacheConnection = this.getConnection(this.cacheProjection);
        }
        assert (this.cacheConnection != null);
        return this.cacheConnection;
    }

    protected RepositoryConnection getConnection(Projection projection) throws RepositorySourceException {
        String sourceName = projection.getSourceName();
        RepositoryConnection connection = this.connectionsBySourceName.get(sourceName);
        if (connection == null) {
            connection = this.connectionFactory.createConnection(sourceName);
            this.connectionsBySourceName.put(sourceName, connection);
        }
        return connection;
    }

    protected Set<String> getOpenConnections() {
        return this.connectionsBySourceName.keySet();
    }

    public void execute(GetNodeCommand command) throws RepositorySourceException {
        BasicGetNodeCommand nodeInfo = this.getNode(command.getPath());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            command.setProperty(property);
        }
        for (Path.Segment child : nodeInfo.getChildren()) {
            command.addChild(child, nodeInfo.getChildIdentityProperties(child));
        }
    }

    public void execute(GetPropertiesCommand command) throws RepositorySourceException {
        BasicGetNodeCommand nodeInfo = this.getNode(command.getPath());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            command.setProperty(property);
        }
    }

    public void execute(GetChildrenCommand command) throws RepositorySourceException {
        BasicGetNodeCommand nodeInfo = this.getNode(command.getPath());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Path.Segment child : nodeInfo.getChildren()) {
            command.addChild(child, nodeInfo.getChildIdentityProperties(child));
        }
    }

    protected BasicGetNodeCommand getNode(Path path) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        RepositoryConnection cacheConnection = this.getConnectionToCache();
        BasicGetNodeCommand fromCache = new BasicGetNodeCommand(path);
        cacheConnection.execute(context, new GraphCommand[]{fromCache});
        HashSet sourceNames = null;
        LinkedList<Contribution> contributions = new LinkedList<Contribution>();
        if (fromCache.hasError()) {
            Throwable error = fromCache.getError();
            if (!(error instanceof PathNotFoundException)) {
                return fromCache;
            }
            PathNotFoundException notFound = (PathNotFoundException)fromCache.getError();
            Path lowestExistingAncestor = notFound.getLowestAncestorThatDoesExist();
            Path ancestor = path.getParent();
            if (!ancestor.equals(lowestExistingAncestor)) {
                Path pathToLoad = path.getParent();
                while (!pathToLoad.equals(lowestExistingAncestor)) {
                    this.loadContributionsFromSources(pathToLoad, null, contributions);
                    FederatedNode mergedNode = this.createFederatedNode(null, pathToLoad, contributions, true);
                    if (mergedNode == null) {
                        I18n msg = FederationI18n.nodeDoesNotExistAtPath;
                        fromCache.setError((Throwable)new PathNotFoundException(path, ancestor, msg.text(new Object[]{path, ancestor})));
                        return fromCache;
                    }
                    contributions.clear();
                    pathToLoad = pathToLoad.getParent();
                }
            }
        } else {
            MergePlan mergePlan = this.getMergePlan(fromCache);
            if (mergePlan != null) {
                DateTime now = this.getCurrentTimeInUtc();
                if (mergePlan.isExpired(now)) {
                    for (Contribution contribution : mergePlan) {
                        if (this.sourceNames.contains(contribution.getSourceName())) continue;
                    }
                    return fromCache;
                }
                if (mergePlan.getContributionCount() > 0) {
                    sourceNames = new HashSet(sourceNames);
                    for (Contribution contribution : mergePlan) {
                        if (contribution.isExpired(now)) continue;
                        sourceNames.remove(contribution.getSourceName());
                        contributions.add(contribution);
                    }
                }
            }
        }
        this.loadContributionsFromSources(path, sourceNames, contributions);
        FederatedNode mergedNode = this.createFederatedNode(fromCache, path, contributions, true);
        if (mergedNode == null) {
            Path ancestor = path.getParent();
            I18n msg = FederationI18n.nodeDoesNotExistAtPath;
            fromCache.setError((Throwable)new PathNotFoundException(path, ancestor, msg.text(new Object[]{path, ancestor})));
            return fromCache;
        }
        return mergedNode;
    }

    protected FederatedNode createFederatedNode(BasicGetNodeCommand fromCache, Path path, List<Contribution> contributions, boolean updateCache) throws RepositorySourceException {
        Property uuidProperty;
        boolean foundNonEmptyContribution = false;
        for (Contribution contribution : contributions) {
            assert (contribution != null);
            if (contribution.isEmpty()) continue;
            foundNonEmptyContribution = true;
            break;
        }
        if (!foundNonEmptyContribution) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Loaded {0} from sources, resulting in these contributions:", new Object[]{path});
            int i = 0;
            for (Contribution contribution : contributions) {
                this.logger.trace("  {0} {1}", new Object[]{++i, contribution});
            }
        }
        ExecutionContext context = this.getExecutionContext();
        assert (context != null);
        UUID uuid = null;
        if (fromCache != null && (uuidProperty = (Property)fromCache.getPropertiesByName().get(DnaLexicon.UUID)) != null && !uuidProperty.isEmpty()) {
            uuid = (UUID)context.getValueFactories().getUuidFactory().create(uuidProperty.getValues().next());
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        FederatedNode mergedNode = new FederatedNode(path, uuid);
        assert (contributions.size() > 0);
        this.mergingStrategy.merge(mergedNode, contributions, context);
        if (mergedNode.getCachePolicy() == null) {
            mergedNode.setCachePolicy(this.defaultCachePolicy);
        }
        if (updateCache) {
            this.updateCache(mergedNode);
        }
        return mergedNode;
    }

    protected void loadContributionsFromSources(Path path, Set<String> sourceNames, List<Contribution> contributions) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        for (Projection projection : this.sourceProjections) {
            Set<Path> pathsInSource;
            RepositoryConnection sourceConnection;
            String source = projection.getSourceName();
            if (sourceNames != null && !sourceNames.contains(source) || (sourceConnection = this.getConnection(projection)) == null) continue;
            CachePolicy cachePolicy = sourceConnection.getDefaultCachePolicy();
            if (cachePolicy == null) {
                cachePolicy = this.defaultCachePolicy;
            }
            DateTime expirationTime = null;
            if (cachePolicy != null) {
                expirationTime = this.getCurrentTimeInUtc().plus(cachePolicy.getTimeToLive(), TimeUnit.MILLISECONDS);
            }
            if ((pathsInSource = projection.getPathsInSource(path, pathFactory)).isEmpty()) {
                Contribution contribution = null;
                List<Path> topLevelPaths = projection.getTopLevelPathsInRepository(pathFactory);
                switch (topLevelPaths.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Path topLevelPath = topLevelPaths.iterator().next();
                        if (!path.isAncestorOf(topLevelPath)) break;
                        assert (topLevelPath.size() > path.size());
                        Path.Segment child = topLevelPath.getSegment(path.size());
                        contribution = Contribution.createPlaceholder(source, path, expirationTime, child);
                        break;
                    }
                    default: {
                        ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(topLevelPaths.size());
                        for (Path topLevelPath : topLevelPaths) {
                            if (!path.isAncestorOf(topLevelPath)) continue;
                            assert (topLevelPath.size() > path.size());
                            Path.Segment child = topLevelPath.getSegment(path.size());
                            children.add(child);
                        }
                        if (children.size() <= 0) break;
                        contribution = Contribution.createPlaceholder(source, path, expirationTime, children);
                    }
                }
                if (contribution == null) {
                    contribution = Contribution.create(source, expirationTime);
                }
                contributions.add(contribution);
                continue;
            }
            int numPaths = pathsInSource.size();
            if (numPaths == 1) {
                Path pathInSource = pathsInSource.iterator().next();
                BasicGetNodeCommand fromSource = new BasicGetNodeCommand(pathInSource);
                sourceConnection.execute(this.getExecutionContext(), new GraphCommand[]{fromSource});
                if (fromSource.hasError()) continue;
                Collection properties = fromSource.getProperties();
                List children = fromSource.getChildren();
                DateTime expTime = fromSource.getCachePolicy() == null ? expirationTime : this.getCurrentTimeInUtc().plus(fromSource.getCachePolicy().getTimeToLive(), TimeUnit.MILLISECONDS);
                Contribution contribution = Contribution.create(source, pathInSource, expTime, properties, children);
                contributions.add(contribution);
                continue;
            }
            BasicGetNodeCommand[] fromSourceCommands = new BasicGetNodeCommand[numPaths];
            int i = 0;
            for (Path pathInSource : pathsInSource) {
                fromSourceCommands[i++] = new BasicGetNodeCommand(pathInSource);
            }
            sourceConnection.execute(context, (GraphCommand[])fromSourceCommands);
            for (BasicGetNodeCommand fromSource : fromSourceCommands) {
                if (fromSource.hasError()) continue;
                Collection properties = fromSource.getProperties();
                List children = fromSource.getChildren();
                DateTime expTime = fromSource.getCachePolicy() == null ? expirationTime : this.getCurrentTimeInUtc().plus(fromSource.getCachePolicy().getTimeToLive(), TimeUnit.MILLISECONDS);
                Contribution contribution = Contribution.create(source, fromSource.getPath(), expTime, properties, children);
                contributions.add(contribution);
            }
        }
    }

    protected MergePlan getMergePlan(BasicGetNodeCommand command) {
        Property mergePlanProperty = (Property)command.getPropertiesByName().get(this.mergePlanPropertyName);
        if (mergePlanProperty == null || mergePlanProperty.isEmpty()) {
            return null;
        }
        Object value = mergePlanProperty.getValues().next();
        return value instanceof MergePlan ? (MergePlan)value : null;
    }

    protected void updateCache(FederatedNode mergedNode) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        RepositoryConnection cacheConnection = this.getConnectionToCache();
        Path path = mergedNode.getPath();
        NodeConflictBehavior conflictBehavior = NodeConflictBehavior.UPDATE;
        ArrayList<BasicSingleValueProperty> properties = new ArrayList<BasicSingleValueProperty>(mergedNode.getPropertiesByName().size() + 1);
        properties.add(new BasicSingleValueProperty(this.uuidPropertyName, (Object)mergedNode.getUuid()));
        BasicCreateNodeCommand newNode = new BasicCreateNodeCommand(path, properties, conflictBehavior);
        List children = mergedNode.getChildren();
        GraphCommand[] intoCache = new GraphCommand[1 + children.size()];
        int i = 0;
        intoCache[i++] = newNode;
        List noProperties = Collections.emptyList();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        for (Path.Segment child : mergedNode.getChildren()) {
            newNode = new BasicCreateNodeCommand(pathFactory.create(path, new Path.Segment[]{child}), noProperties, conflictBehavior);
            intoCache[i++] = newNode;
        }
        cacheConnection.execute(context, intoCache);
    }
}

