/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.executor;

import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.executor.ProjectedCopyBranchCommand;
import org.jboss.dna.connector.federation.executor.ProjectedCopyNodeCommand;
import org.jboss.dna.connector.federation.executor.ProjectedCreateNodeCommand;
import org.jboss.dna.connector.federation.executor.ProjectedDeleteBranchCommand;
import org.jboss.dna.connector.federation.executor.ProjectedGetChildrenCommand;
import org.jboss.dna.connector.federation.executor.ProjectedGetNodeCommand;
import org.jboss.dna.connector.federation.executor.ProjectedGetPropertiesCommand;
import org.jboss.dna.connector.federation.executor.ProjectedMoveBranchCommand;
import org.jboss.dna.connector.federation.executor.ProjectedRecordBranchCommand;
import org.jboss.dna.connector.federation.executor.ProjectedSetPropertiesCommand;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.commands.CopyBranchCommand;
import org.jboss.dna.graph.commands.CopyNodeCommand;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.DeleteBranchCommand;
import org.jboss.dna.graph.commands.GetChildrenCommand;
import org.jboss.dna.graph.commands.GetNodeCommand;
import org.jboss.dna.graph.commands.GetPropertiesCommand;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.MoveBranchCommand;
import org.jboss.dna.graph.commands.RecordBranchCommand;
import org.jboss.dna.graph.commands.SetPropertiesCommand;
import org.jboss.dna.graph.commands.executor.AbstractCommandExecutor;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;

@NotThreadSafe
public class SingleProjectionCommandExecutor
extends AbstractCommandExecutor {
    private final Projection projection;
    private final PathFactory pathFactory;
    private final RepositoryConnectionFactory connectionFactory;
    private RepositoryConnection connection;

    public SingleProjectionCommandExecutor(ExecutionContext context, String sourceName, Projection projection, RepositoryConnectionFactory connectionFactory) {
        this(context, sourceName, null, projection, connectionFactory);
    }

    public SingleProjectionCommandExecutor(ExecutionContext context, String sourceName, DateTime now, Projection projection, RepositoryConnectionFactory connectionFactory) {
        super(context, sourceName, now);
        assert (connectionFactory != null);
        assert (projection != null);
        assert (projection.getRules().size() == 1);
        this.projection = projection;
        this.connectionFactory = connectionFactory;
        this.pathFactory = context.getValueFactories().getPathFactory();
        assert (this.pathFactory != null);
    }

    protected RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.connection == null) {
            this.connection = this.connectionFactory.createConnection(this.projection.getSourceName());
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
        super.close();
    }

    public void execute(GetChildrenCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedGetChildrenCommand(command, pathInSource)});
    }

    public void execute(GetPropertiesCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedGetPropertiesCommand(command, pathInSource)});
    }

    public void execute(GetNodeCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedGetNodeCommand(command, pathInSource)});
    }

    public void execute(CreateNodeCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedCreateNodeCommand(command, pathInSource)});
    }

    public void execute(SetPropertiesCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedSetPropertiesCommand(command, pathInSource)});
    }

    public void execute(DeleteBranchCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedDeleteBranchCommand(command, pathInSource)});
    }

    public void execute(MoveBranchCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        Path newPathInSource = this.getPathInSource(command.getNewPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedMoveBranchCommand(command, pathInSource, newPathInSource)});
    }

    public void execute(RecordBranchCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedRecordBranchCommand(command, pathInSource)});
    }

    public void execute(CopyBranchCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        Path newPathInSource = this.getPathInSource(command.getNewPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedCopyBranchCommand(command, pathInSource, newPathInSource)});
    }

    public void execute(CopyNodeCommand command) throws RepositorySourceException {
        Path pathInSource = this.getPathInSource(command.getPath());
        Path newPathInSource = this.getPathInSource(command.getNewPath());
        this.getConnection().execute(this.getExecutionContext(), new GraphCommand[]{new ProjectedCopyNodeCommand(command, pathInSource, newPathInSource)});
    }

    protected Path getPathInSource(Path pathInRepository) {
        Set<Path> paths = this.projection.getPathsInSource(pathInRepository, this.pathFactory);
        if (!paths.isEmpty()) {
            return paths.iterator().next();
        }
        return this.projection.getPathsInSource(pathInRepository, this.pathFactory).iterator().next();
    }

    protected Path getPathInRepository(Path pathInSource) {
        return this.projection.getPathsInRepository(pathInSource, this.pathFactory).iterator().next();
    }
}

