/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.UUID;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.graph.commands.CreateNodeCommand;
import org.jboss.dna.graph.commands.NodeConflictBehavior;
import org.jboss.dna.graph.commands.basic.BasicGetNodeCommand;
import org.jboss.dna.graph.properties.Path;

public class FederatedNode
extends BasicGetNodeCommand
implements CreateNodeCommand {
    protected static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.UPDATE;
    private static final long serialVersionUID = 1L;
    private UUID uuid;
    private MergePlan mergePlan;
    private NodeConflictBehavior nodeConflictBehavior = DEFAULT_CONFLICT_BEHAVIOR;

    public FederatedNode(Path path, UUID uuid) {
        super(path);
        assert (uuid != null);
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public MergePlan getMergePlan() {
        return this.mergePlan;
    }

    public void setMergePlan(MergePlan mergePlan) {
        this.mergePlan = mergePlan;
    }

    public int compareTo(CreateNodeCommand that) {
        if (this == that) {
            return 0;
        }
        return this.getPath().compareTo((Object)that.getPath());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedNode) {
            FederatedNode that = (FederatedNode)((Object)obj);
            if (this.getPath().equals(that.getPath())) {
                return true;
            }
            if (this.getUuid().equals(that.getUuid())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getPath().toString() + " (" + this.getUuid() + ")";
    }

    public NodeConflictBehavior getConflictBehavior() {
        return this.nodeConflictBehavior;
    }

    public void setConflictBehavior(NodeConflictBehavior nodeConflictBehavior) {
        this.nodeConflictBehavior = nodeConflictBehavior != null ? nodeConflictBehavior : DEFAULT_CONFLICT_BEHAVIOR;
    }
}

