/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge.strategy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.UuidFactory;
import org.jboss.dna.graph.properties.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OneContributionMergeStrategy
implements MergeStrategy {
    public static final boolean DEFAULT_REUSE_UUID_FROM_CONTRIBUTION = true;
    private boolean useUuidFromContribution = true;

    public boolean isContributionUuidUsedForFederatedNode() {
        return this.useUuidFromContribution;
    }

    public void setContributionUuidUsedForFederatedNode(boolean useUuidFromContribution) {
        this.useUuidFromContribution = useUuidFromContribution;
    }

    @Override
    public void merge(FederatedNode federatedNode, List<Contribution> contributions, ExecutionContext context) {
        assert (federatedNode != null);
        assert (context != null);
        assert (contributions != null);
        assert (contributions.size() > 0);
        Contribution contribution = contributions.get(0);
        assert (contribution != null);
        boolean findUuid = this.isContributionUuidUsedForFederatedNode();
        List children = federatedNode.getChildren();
        children.clear();
        Iterator<Path.Segment> childIterator = contribution.getChildren();
        while (childIterator.hasNext()) {
            Path.Segment child = childIterator.next();
            children.add(child);
        }
        Map properties = federatedNode.getPropertiesByName();
        properties.clear();
        UUID uuid = null;
        UuidFactory uuidFactory = null;
        Iterator<Property> propertyIterator = contribution.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            if (findUuid && uuid == null && property.getName().getLocalName().equals("uuid")) {
                if (!property.isSingle()) continue;
                if (uuidFactory == null) {
                    uuidFactory = context.getValueFactories().getUuidFactory();
                }
                try {
                    uuid = (UUID)uuidFactory.create(property.getValues().next());
                }
                catch (ValueFormatException e) {}
                continue;
            }
            properties.put(property.getName(), property);
        }
        if (uuid != null) {
            federatedNode.setUuid(uuid);
        }
        Property uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{federatedNode.getUuid()});
        properties.put(uuidProperty.getName(), uuidProperty);
        MergePlan mergePlan = MergePlan.create(contributions);
        federatedNode.setMergePlan(mergePlan);
    }
}

