/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge.strategy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.properties.IoException;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.UuidFactory;
import org.jboss.dna.graph.properties.ValueComparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SimpleMergeStrategy
implements MergeStrategy {
    private boolean removeDuplicateProperties = true;

    public boolean isRemoveDuplicateProperties() {
        return this.removeDuplicateProperties;
    }

    public void setRemoveDuplicateProperties(boolean removeDuplicateProperties) {
        this.removeDuplicateProperties = removeDuplicateProperties;
    }

    @Override
    public void merge(FederatedNode federatedNode, List<Contribution> contributions, ExecutionContext context) {
        assert (federatedNode != null);
        assert (context != null);
        assert (contributions != null);
        assert (contributions.size() > 0);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        List children = federatedNode.getChildren();
        children.clear();
        HashMap<Name, Integer> childNames = new HashMap<Name, Integer>();
        Map properties = federatedNode.getPropertiesByName();
        properties.clear();
        UUID uuid = null;
        UuidFactory uuidFactory = null;
        boolean removeDuplicateProperties = this.isRemoveDuplicateProperties();
        for (Contribution contribution : contributions) {
            Path.Segment child;
            Iterator<Path.Segment> childIterator;
            if (contribution.isPlaceholder()) {
                childIterator = contribution.getChildren();
                while (childIterator.hasNext()) {
                    child = childIterator.next();
                    if (childNames.containsKey(child.getName())) continue;
                    childNames.put(child.getName(), 1);
                    children.add(pathFactory.createSegment(child.getName()));
                }
                continue;
            }
            childIterator = contribution.getChildren();
            while (childIterator.hasNext()) {
                child = childIterator.next();
                int index = -1;
                Integer previous = childNames.put(child.getName(), 1);
                if (previous != null) {
                    int previousValue = previous;
                    childNames.put(child.getName(), ++previousValue);
                    index = previousValue;
                }
                children.add(pathFactory.createSegment(child.getName(), index));
            }
            Iterator<Property> propertyIterator = contribution.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.next();
                if (federatedNode.getPath().isRoot() && property.getName().getLocalName().equals("uuid")) continue;
                Property existing = properties.put(property.getName(), property);
                if (existing != null) {
                    Property merged = this.merge(existing, property, context.getPropertyFactory(), removeDuplicateProperties);
                    properties.put(property.getName(), merged);
                }
                if (uuid != null || !property.getName().getLocalName().equals("uuid") || !property.isSingle()) continue;
                if (uuidFactory == null) {
                    uuidFactory = context.getValueFactories().getUuidFactory();
                }
                try {
                    uuid = (UUID)uuidFactory.create(property.getValues().next());
                }
                catch (IoException e) {
                    assert (uuid == null);
                }
            }
        }
        if (uuid != null) {
            federatedNode.setUuid(uuid);
        }
        Property uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{federatedNode.getUuid()});
        properties.put(uuidProperty.getName(), uuidProperty);
        MergePlan mergePlan = MergePlan.create(contributions);
        federatedNode.setMergePlan(mergePlan);
    }

    protected Property merge(Property property1, Property property2, PropertyFactory factory, boolean removeDuplicates) {
        assert (property1 != null);
        assert (property2 != null);
        assert (property1.getName().equals(property2.getName()));
        if (property1.isEmpty()) {
            return property2;
        }
        if (property2.isEmpty()) {
            return property1;
        }
        if (property1.isSingle() && property2.isSingle()) {
            Object value1 = property1.getValues().next();
            Object value2 = property2.getValues().next();
            if (removeDuplicates && ValueComparators.OBJECT_COMPARATOR.compare(value1, value2) == 0) {
                return property1;
            }
            return factory.create(property1.getName(), new Object[]{value1, value2});
        }
        if (!removeDuplicates) {
            DualIterator valueIterator = new DualIterator(property1.getValues(), property2.getValues());
            return factory.create(property1.getName(), (Iterator)valueIterator);
        }
        Object[] values = new Object[property1.size() + property2.size()];
        int index = 0;
        for (Object property1Value : property1) {
            values[index++] = property1Value;
        }
        assert (index == property1.size());
        for (Object property2Value : property2) {
            boolean matched = false;
            for (Object property1Value : property1) {
                if (ValueComparators.OBJECT_COMPARATOR.compare(property1Value, property2Value) != 0) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            values[index++] = property2Value;
        }
        if (index != values.length) {
            Object[] newValues = new Object[index];
            System.arraycopy(values, 0, newValues, 0, index);
            values = newValues;
        }
        return factory.create(property1.getName(), values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DualIterator
    implements Iterator<Object> {
        private final Iterator<?>[] iterators;
        private Iterator<?> current;
        private int index = 0;

        protected DualIterator(Iterator<?> ... iterators) {
            assert (iterators != null);
            assert (iterators.length > 0);
            this.iterators = iterators;
            this.current = this.iterators[0];
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return this.current.hasNext();
            }
            return false;
        }

        @Override
        public Object next() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                if (++this.index < this.iterators.length) {
                    this.current = this.iterators[this.index];
                    continue;
                }
                this.current = null;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

