/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.ThreadSafeProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.graph.cache.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FederatedRepositoryConfig
implements Comparable<FederatedRepositoryConfig> {
    private final Projection cacheProjection;
    private final List<Projection> sourceProjections;
    private final Problems problems;
    private final String name;
    private final CachePolicy defaultCachePolicy;

    public FederatedRepositoryConfig(String repositoryName, Projection cacheProjection, Iterable<Projection> sourceProjections, CachePolicy defaultCachePolicy) {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        CheckArg.isNotNull((Object)cacheProjection, (String)"cacheProjection");
        this.name = repositoryName;
        this.problems = new ThreadSafeProblems();
        this.defaultCachePolicy = defaultCachePolicy;
        this.cacheProjection = cacheProjection;
        ArrayList<Projection> projectionList = new ArrayList<Projection>();
        for (Projection projection : sourceProjections) {
            if (projection == null || projectionList.contains(projection)) continue;
            projectionList.add(projection);
        }
        this.sourceProjections = Collections.unmodifiableList(projectionList);
        CheckArg.isNotEmpty(this.sourceProjections, (String)"sourceProjections");
    }

    public String getName() {
        return this.name;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public Projection getCacheProjection() {
        return this.cacheProjection;
    }

    public List<Projection> getSourceProjections() {
        return this.sourceProjections;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedRepositoryConfig) {
            FederatedRepositoryConfig that = (FederatedRepositoryConfig)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            if (!this.getCacheProjection().equals(that.getCacheProjection())) {
                return false;
            }
            return ((Object)this.getSourceProjections()).equals(that.getSourceProjections());
        }
        return false;
    }

    @Override
    public int compareTo(FederatedRepositoryConfig that) {
        if (that == this) {
            return 0;
        }
        int diff = this.getName().compareTo(that.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.getCacheProjection().compareTo(that.getCacheProjection());
        if (diff != 0) {
            return diff;
        }
        Iterator<Projection> thisIter = this.getSourceProjections().iterator();
        Iterator<Projection> thatIter = that.getSourceProjections().iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            diff = thisIter.next().compareTo(thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }
}

