/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.FederatedRepository;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.connectors.RepositorySourceListener;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.processor.RequestProcessor;

@ThreadSafe
public class FederatedRepositoryConnection
implements RepositoryConnection {
    protected static final RepositorySourceListener NO_OP_LISTENER = new RepositorySourceListener(){

        public void notify(String sourceName, Object ... events) {
        }
    };
    private final FederatedRepository repository;
    private final String sourceName;
    private final AtomicReference<RepositorySourceListener> listener;

    protected FederatedRepositoryConnection(FederatedRepository repository, String sourceName) {
        assert (sourceName != null);
        assert (repository != null);
        this.sourceName = sourceName;
        this.repository = repository;
        this.listener = new AtomicReference<RepositorySourceListener>(NO_OP_LISTENER);
        this.repository.register(this);
    }

    protected FederatedRepository getRepository() {
        return this.repository;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.repository.getConfiguration().getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public void setListener(RepositorySourceListener listener) {
        if (listener == null) {
            listener = NO_OP_LISTENER;
        }
        RepositorySourceListener oldListener = this.listener.getAndSet(listener);
        this.repository.addListener(listener);
        if (oldListener != NO_OP_LISTENER) {
            this.repository.removeListener(oldListener);
        }
    }

    public boolean ping(long time, TimeUnit unit) {
        return this.repository.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        if (!this.repository.isRunning()) {
            throw new RepositorySourceException(FederationI18n.repositoryHasBeenShutDown.text(new Object[]{this.repository.getName()}));
        }
        if (request == null) {
            return;
        }
        RequestProcessor processor = this.repository.getProcessor(context, this.sourceName);
        assert (processor != null);
        try {
            processor.process(request);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            processor.close();
            throw throwable;
        }
        processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.repository.removeListener(this.listener.get());
            Object var2_1 = null;
            this.repository.unregister(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.repository.unregister(this);
            throw throwable;
        }
    }
}

