/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.EmptyContribution;
import org.jboss.dna.connector.federation.contribution.MultiChildContribution;
import org.jboss.dna.connector.federation.contribution.MultiPropertyContribution;
import org.jboss.dna.connector.federation.contribution.NodeContribution;
import org.jboss.dna.connector.federation.contribution.OneChildContribution;
import org.jboss.dna.connector.federation.contribution.OnePropertyContribution;
import org.jboss.dna.connector.federation.contribution.PlaceholderContribution;
import org.jboss.dna.connector.federation.contribution.ThreePropertyContribution;
import org.jboss.dna.connector.federation.contribution.TwoChildContribution;
import org.jboss.dna.connector.federation.contribution.TwoPropertyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.basic.JodaDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class Contribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Iterator<Property> EMPTY_PROPERTY_ITERATOR = new EmptyIterator<Property>();
    protected static final Iterator<Location> EMPTY_CHILDREN_ITERATOR = new EmptyIterator<Location>();
    private final String sourceName;
    private DateTime expirationTimeInUtc;

    public static Contribution create(String sourceName, DateTime expirationTime) {
        return new EmptyContribution(sourceName, expirationTime);
    }

    public static Contribution create(String sourceName, Location locationInSource, DateTime expirationTime, Property property) {
        if (property == null) {
            return new EmptyContribution(sourceName, expirationTime);
        }
        return new OnePropertyContribution(sourceName, locationInSource, expirationTime, property);
    }

    public static Contribution create(String sourceName, Location locationInSource, DateTime expirationTime, Location child) {
        if (child == null) {
            return new EmptyContribution(sourceName, expirationTime);
        }
        return new OneChildContribution(sourceName, locationInSource, expirationTime, child);
    }

    public static Contribution create(String sourceName, Location locationInSource, DateTime expirationTime, Location child1, Location child2) {
        if (child1 != null) {
            if (child2 != null) {
                return new TwoChildContribution(sourceName, locationInSource, expirationTime, child1, child2);
            }
            return new OneChildContribution(sourceName, locationInSource, expirationTime, child1);
        }
        if (child2 != null) {
            return new OneChildContribution(sourceName, locationInSource, expirationTime, child2);
        }
        return new EmptyContribution(sourceName, expirationTime);
    }

    public static Contribution create(String sourceName, Location locationInSource, DateTime expirationTime, Collection<Property> properties, List<Location> children) {
        if (properties == null || properties.isEmpty()) {
            if (children == null || children.isEmpty()) {
                return new EmptyContribution(sourceName, expirationTime);
            }
            if (children.size() == 1) {
                return new OneChildContribution(sourceName, locationInSource, expirationTime, children.iterator().next());
            }
            if (children.size() == 2) {
                Iterator<Location> iter = children.iterator();
                return new TwoChildContribution(sourceName, locationInSource, expirationTime, iter.next(), iter.next());
            }
            return new MultiChildContribution(sourceName, locationInSource, expirationTime, children);
        }
        if (children == null || children.isEmpty()) {
            if (properties.size() == 1) {
                return new OnePropertyContribution(sourceName, locationInSource, expirationTime, properties.iterator().next());
            }
            if (properties.size() == 2) {
                Iterator<Property> iter = properties.iterator();
                return new TwoPropertyContribution(sourceName, locationInSource, expirationTime, iter.next(), iter.next());
            }
            if (properties.size() == 3) {
                Iterator<Property> iter = properties.iterator();
                return new ThreePropertyContribution(sourceName, locationInSource, expirationTime, iter.next(), iter.next(), iter.next());
            }
            return new MultiPropertyContribution(sourceName, locationInSource, expirationTime, properties);
        }
        return new NodeContribution(sourceName, locationInSource, expirationTime, properties, children);
    }

    public static Contribution createPlaceholder(String sourceName, Location locationInSource, DateTime expirationTime, Location child) {
        if (child == null) {
            return new EmptyContribution(sourceName, expirationTime);
        }
        return new PlaceholderContribution(sourceName, locationInSource, expirationTime, Collections.singletonList(child));
    }

    public static Contribution createPlaceholder(String sourceName, Location locationInSource, DateTime expirationTime, List<Location> children) {
        if (children == null || children.isEmpty()) {
            return new EmptyContribution(sourceName, expirationTime);
        }
        return new PlaceholderContribution(sourceName, locationInSource, expirationTime, children);
    }

    protected Contribution(String sourceName, DateTime expirationTime) {
        assert (sourceName != null && sourceName.trim().length() != 0);
        assert (expirationTime == null || expirationTime.equals(expirationTime.toUtcTimeZone()));
        this.sourceName = sourceName;
        this.expirationTimeInUtc = expirationTime;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public abstract Location getLocationInSource();

    public boolean isExpired(DateTime utcTime) {
        assert (utcTime != null);
        assert (utcTime.toUtcTimeZone().equals(utcTime));
        return !this.expirationTimeInUtc.isAfter(utcTime);
    }

    public DateTime getExpirationTimeInUtc() {
        return this.expirationTimeInUtc;
    }

    public Iterator<Property> getProperties() {
        return EMPTY_PROPERTY_ITERATOR;
    }

    public int getPropertyCount() {
        return 0;
    }

    public Property getProperty(Name name) {
        return null;
    }

    public Iterator<Location> getChildren() {
        return EMPTY_CHILDREN_ITERATOR;
    }

    public int getChildrenCount() {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isPlaceholder() {
        return false;
    }

    public int hashCode() {
        return this.sourceName.hashCode();
    }

    public String toString() {
        boolean first;
        StringBuffer sb = new StringBuffer();
        sb.append("Contribution from \"");
        sb.append(this.getSourceName());
        if (this.isExpired(new JodaDateTime().toUtcTimeZone())) {
            sb.append("\": expired ");
        } else {
            sb.append("\": expires ");
        }
        sb.append(this.getExpirationTimeInUtc().getString());
        if (this.getPropertyCount() != 0) {
            sb.append(" { ");
            first = true;
            Iterator<Property> propIter = this.getProperties();
            while (propIter.hasNext()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(propIter.next());
            }
            sb.append(" }");
        }
        if (this.getChildrenCount() != 0) {
            sb.append("< ");
            first = true;
            Iterator<Location> childIter = this.getChildren();
            while (childIter.hasNext()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(childIter.next());
            }
            sb.append(" >");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Contribution) {
            Contribution that = (Contribution)obj;
            return this.getSourceName().equals(that.getSourceName());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ThreeValueIterator<T>
    implements Iterator<T> {
        private final T value1;
        private final T value2;
        private final T value3;
        private int next = 3;

        protected ThreeValueIterator(T value1, T value2, T value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        @Override
        public boolean hasNext() {
            return this.next > 0;
        }

        @Override
        public T next() {
            if (this.next == 3) {
                this.next = 2;
                return this.value1;
            }
            if (this.next == 2) {
                this.next = 1;
                return this.value2;
            }
            if (this.next == 1) {
                this.next = 0;
                return this.value3;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TwoValueIterator<T>
    implements Iterator<T> {
        private final T value1;
        private final T value2;
        private int next = 2;

        protected TwoValueIterator(T value1, T value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        @Override
        public boolean hasNext() {
            return this.next > 0;
        }

        @Override
        public T next() {
            if (this.next == 2) {
                this.next = 1;
                return this.value1;
            }
            if (this.next == 1) {
                this.next = 0;
                return this.value2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OneValueIterator<T>
    implements Iterator<T> {
        private final T value;
        private boolean next = true;

        protected OneValueIterator(T value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public T next() {
            if (this.next) {
                this.next = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EmptyIterator<T>
    implements Iterator<T> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ImmutableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iter;

        protected ImmutableIterator(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

