/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.MultiPropertyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class NodeContribution
extends MultiPropertyContribution {
    private static final long serialVersionUID = 1L;
    private List<Location> children;

    public NodeContribution(String sourceName, Location locationInSource, DateTime expirationTime, Iterable<Property> properties, Iterable<Location> children) {
        super(sourceName, locationInSource, expirationTime, properties);
        assert (children != null);
        this.children = new LinkedList<Location>();
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
        assert (!this.children.isEmpty());
    }

    @Override
    public Iterator<Location> getChildren() {
        return new Contribution.ImmutableIterator<Location>(this.children.iterator());
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }
}

