/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.NonEmptyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ThreePropertyContribution
extends NonEmptyContribution {
    private static final long serialVersionUID = 1L;
    private final Property property1;
    private final Property property2;
    private final Property property3;

    public ThreePropertyContribution(String sourceName, Location locationInSource, DateTime expirationTime, Property property1, Property property2, Property property3) {
        super(sourceName, locationInSource, expirationTime);
        assert (property1 != null);
        assert (!property1.isEmpty());
        assert (property2 != null);
        assert (!property2.isEmpty());
        assert (property3 != null);
        assert (!property3.isEmpty());
        this.property1 = property1;
        this.property2 = property2;
        this.property3 = property3;
    }

    @Override
    public Iterator<Property> getProperties() {
        return new Contribution.ThreeValueIterator<Property>(this.property1, this.property2, this.property3);
    }

    @Override
    public int getPropertyCount() {
        return 3;
    }

    @Override
    public Property getProperty(Name name) {
        if (this.property1.getName().equals(name)) {
            return this.property1;
        }
        if (this.property2.getName().equals(name)) {
            return this.property2;
        }
        if (this.property3.getName().equals(name)) {
            return this.property3;
        }
        return null;
    }
}

