/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.OneContributionMergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.SimpleMergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CompositeRequest;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.ReadNodeRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;
import org.jboss.dna.graph.requests.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class FederatingCommandExecutor
extends RequestProcessor {
    private final CachePolicy defaultCachePolicy;
    private final Projection cacheProjection;
    private final List<Projection> sourceProjections;
    private final Set<String> sourceNames;
    private final RepositoryConnectionFactory connectionFactory;
    private MergeStrategy mergingStrategy;
    private final Map<String, RepositoryConnection> connectionsBySourceName;
    private RepositoryConnection cacheConnection;
    private Logger logger;

    public FederatingCommandExecutor(ExecutionContext context, String sourceName, List<Projection> sourceProjections, RepositoryConnectionFactory connectionFactory) {
        this(context, sourceName, null, null, sourceProjections, connectionFactory);
    }

    public FederatingCommandExecutor(ExecutionContext context, String sourceName, Projection cacheProjection, CachePolicy defaultCachePolicy, List<Projection> sourceProjections, RepositoryConnectionFactory connectionFactory) {
        super(sourceName, context);
        CheckArg.isNotNull(sourceProjections, (String)"sourceProjections");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        assert (cacheProjection == null ? defaultCachePolicy == null : defaultCachePolicy != null);
        this.cacheProjection = cacheProjection;
        this.defaultCachePolicy = defaultCachePolicy;
        this.sourceProjections = sourceProjections;
        this.connectionFactory = connectionFactory;
        this.logger = context.getLogger(((Object)((Object)this)).getClass());
        this.connectionsBySourceName = new HashMap<String, RepositoryConnection>();
        this.sourceNames = new HashSet<String>();
        for (Projection projection : this.sourceProjections) {
            this.sourceNames.add(projection.getSourceName());
        }
        this.setMergingStrategy(null);
    }

    public void setMergingStrategy(MergeStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy != null ? mergingStrategy : (this.sourceProjections.size() == 1 && this.sourceProjections.get(0).isSimple() ? new OneContributionMergeStrategy() : new SimpleMergeStrategy());
        assert (this.mergingStrategy != null);
    }

    public List<Projection> getSourceProjections() {
        return Collections.unmodifiableList(this.sourceProjections);
    }

    public Projection getCacheProjection() {
        return this.cacheProjection;
    }

    protected DateTime getCurrentTimeInUtc() {
        return this.getExecutionContext().getValueFactories().getDateFactory().createUtc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        super.close();
        Object var2_1 = null;
        for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
            if (connection == null) continue;
            try {
                connection.close();
            }
            catch (Throwable t) {
                this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
            }
        }
        this.connectionsBySourceName.clear();
        try {
            if (this.cacheConnection != null) {
                this.cacheConnection.close();
            }
            Object var7_9 = null;
            this.cacheConnection = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.cacheConnection = null;
            throw throwable;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
                }
            }
            this.connectionsBySourceName.clear();
            try {
                if (this.cacheConnection != null) {
                    this.cacheConnection.close();
                }
                Object var7_11 = null;
                this.cacheConnection = null;
            }
            catch (Throwable throwable2) {
                Object var7_12 = null;
                this.cacheConnection = null;
                throw throwable2;
            }
            throw throwable;
        }
    }

    protected RepositoryConnection getConnectionToCache() throws RepositorySourceException {
        if (this.cacheConnection == null) {
            this.cacheConnection = this.getConnection(this.cacheProjection);
        }
        assert (this.cacheConnection != null);
        return this.cacheConnection;
    }

    protected RepositoryConnection getConnection(Projection projection) throws RepositorySourceException {
        String sourceName = projection.getSourceName();
        RepositoryConnection connection = this.connectionsBySourceName.get(sourceName);
        if (connection == null) {
            connection = this.connectionFactory.createConnection(sourceName);
            this.connectionsBySourceName.put(sourceName, connection);
        }
        return connection;
    }

    protected Set<String> getOpenConnections() {
        return this.connectionsBySourceName.keySet();
    }

    public void process(ReadAllChildrenRequest request) {
        ReadNodeRequest nodeInfo = this.getNode(request.of());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Location child : nodeInfo.getChildren()) {
            request.addChild(child);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(ReadAllPropertiesRequest request) {
        ReadNodeRequest nodeInfo = this.getNode(request.at());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            request.addProperty(property);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(ReadNodeRequest request) {
        ReadNodeRequest nodeInfo = this.getNode(request.at());
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            request.addProperty(property);
        }
        for (Location child : nodeInfo.getChildren()) {
            request.addChild(child);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(CopyBranchRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(CreateNodeRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(DeleteBranchRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(MoveBranchRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(UpdatePropertiesRequest request) {
        throw new UnsupportedOperationException();
    }

    protected ReadNodeRequest getNode(Location location) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        RepositoryConnection cacheConnection = this.getConnectionToCache();
        ReadNodeRequest fromCache = new ReadNodeRequest(location);
        cacheConnection.execute(context, (Request)fromCache);
        HashSet sourceNames = null;
        LinkedList<Contribution> contributions = new LinkedList<Contribution>();
        if (fromCache.hasError()) {
            Path path;
            Path ancestor;
            Throwable error = fromCache.getError();
            if (!(error instanceof PathNotFoundException)) {
                return fromCache;
            }
            PathNotFoundException notFound = (PathNotFoundException)fromCache.getError();
            Path lowestExistingAncestor = notFound.getLowestAncestorThatDoesExist();
            if (location.hasPath() && !(ancestor = (path = location.getPath()).getParent()).equals(lowestExistingAncestor)) {
                Path pathToLoad = ancestor;
                while (!pathToLoad.equals(lowestExistingAncestor)) {
                    Location locationToLoad = new Location(pathToLoad);
                    this.loadContributionsFromSources(locationToLoad, null, contributions);
                    FederatedNode mergedNode = this.createFederatedNode(locationToLoad, contributions, true);
                    if (mergedNode == null) {
                        I18n msg = FederationI18n.nodeDoesNotExistAtPath;
                        fromCache.setError((Throwable)new PathNotFoundException(location, ancestor, msg.text(new Object[]{path, ancestor})));
                        return fromCache;
                    }
                    contributions.clear();
                    pathToLoad = pathToLoad.getParent();
                }
            }
        } else {
            MergePlan mergePlan = this.getMergePlan(fromCache);
            if (mergePlan != null) {
                DateTime now = this.getCurrentTimeInUtc();
                if (mergePlan.isExpired(now)) {
                    for (Contribution contribution : mergePlan) {
                        if (this.sourceNames.contains(contribution.getSourceName())) continue;
                    }
                    return fromCache;
                }
                if (mergePlan.getContributionCount() > 0) {
                    sourceNames = new HashSet(sourceNames);
                    for (Contribution contribution : mergePlan) {
                        if (contribution.isExpired(now)) continue;
                        sourceNames.remove(contribution.getSourceName());
                        contributions.add(contribution);
                    }
                }
            }
        }
        if ((location = fromCache.getActualLocationOfNode()) == null) {
            location = fromCache.at();
        }
        this.loadContributionsFromSources(location, sourceNames, contributions);
        FederatedNode mergedNode = this.createFederatedNode(location, contributions, true);
        if (mergedNode == null) {
            if (location.hasPath()) {
                Path ancestor = location.getPath().getParent();
                I18n msg = FederationI18n.nodeDoesNotExistAtPath;
                fromCache.setError((Throwable)new PathNotFoundException(location, ancestor, msg.text(new Object[]{location, ancestor})));
                return fromCache;
            }
            I18n msg = FederationI18n.nodeDoesNotExistAtLocation;
            fromCache.setError((Throwable)new PathNotFoundException(location, null, msg.text(new Object[]{location})));
            return fromCache;
        }
        return mergedNode;
    }

    protected FederatedNode createFederatedNode(Location location, List<Contribution> contributions, boolean updateCache) throws RepositorySourceException {
        assert (location != null);
        boolean foundNonEmptyContribution = false;
        for (Contribution contribution : contributions) {
            assert (contribution != null);
            if (contribution.isEmpty()) continue;
            foundNonEmptyContribution = true;
            break;
        }
        if (!foundNonEmptyContribution) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Loaded {0} from sources, resulting in these contributions:", new Object[]{location});
            int i = 0;
            for (Contribution contribution : contributions) {
                this.logger.trace("  {0} {1}", new Object[]{++i, contribution});
            }
        }
        ExecutionContext context = this.getExecutionContext();
        assert (context != null);
        UUID uuid = null;
        Property uuidProperty = location.getIdProperty(DnaLexicon.UUID);
        if (uuidProperty == null || uuidProperty.isEmpty()) {
            uuid = context.getValueFactories().getUuidFactory().create();
            uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{uuid});
            location = location.with(uuidProperty);
        } else {
            assert (!uuidProperty.isEmpty());
            uuid = (UUID)context.getValueFactories().getUuidFactory().create(uuidProperty.getValues().next());
        }
        assert (uuid != null);
        FederatedNode mergedNode = new FederatedNode(location, uuid);
        assert (contributions.size() > 0);
        this.mergingStrategy.merge(mergedNode, contributions, context);
        if (mergedNode.getCachePolicy() == null) {
            mergedNode.setCachePolicy(this.defaultCachePolicy);
        }
        if (updateCache) {
            this.updateCache(mergedNode);
        }
        return mergedNode;
    }

    protected void loadContributionsFromSources(Location location, Set<String> sourceNames, List<Contribution> contributions) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        if (!location.hasPath()) {
            for (Projection projection : this.sourceProjections) {
                RepositoryConnection sourceConnection;
                String source = projection.getSourceName();
                if (sourceNames != null && !sourceNames.contains(source) || (sourceConnection = this.getConnection(projection)) == null) continue;
                CachePolicy cachePolicy = sourceConnection.getDefaultCachePolicy();
                if (cachePolicy == null) {
                    cachePolicy = this.defaultCachePolicy;
                }
                DateTime expirationTime = null;
                if (cachePolicy != null) {
                    expirationTime = this.getCurrentTimeInUtc().plus(cachePolicy.getTimeToLive(), TimeUnit.MILLISECONDS);
                }
                ReadNodeRequest request = new ReadNodeRequest(location);
                sourceConnection.execute(context, (Request)request);
                if (request.hasError()) continue;
                DateTime expTime = request.getCachePolicy() == null ? expirationTime : this.getCurrentTimeInUtc().plus(request.getCachePolicy().getTimeToLive(), TimeUnit.MILLISECONDS);
                Contribution contribution = Contribution.create(source, request.getActualLocationOfNode(), expTime, request.getProperties(), request.getChildren());
                contributions.add(contribution);
            }
        }
        Path path = location.getPath();
        for (Projection projection : this.sourceProjections) {
            Contribution contribution;
            DateTime expTime;
            Set<Path> pathsInSource;
            RepositoryConnection sourceConnection;
            String source = projection.getSourceName();
            if (sourceNames != null && !sourceNames.contains(source) || (sourceConnection = this.getConnection(projection)) == null) continue;
            CachePolicy cachePolicy = sourceConnection.getDefaultCachePolicy();
            if (cachePolicy == null) {
                cachePolicy = this.defaultCachePolicy;
            }
            DateTime expirationTime = null;
            if (cachePolicy != null) {
                expirationTime = this.getCurrentTimeInUtc().plus(cachePolicy.getTimeToLive(), TimeUnit.MILLISECONDS);
            }
            if ((pathsInSource = projection.getPathsInSource(path, pathFactory)).isEmpty()) {
                Contribution contribution2 = null;
                List<Path> topLevelPaths = projection.getTopLevelPathsInRepository(pathFactory);
                Location input = new Location(path);
                switch (topLevelPaths.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Path topLevelPath = topLevelPaths.iterator().next();
                        if (!path.isAncestorOf(topLevelPath)) break;
                        Location child = new Location(topLevelPath);
                        contribution2 = Contribution.createPlaceholder(source, input, expirationTime, child);
                        break;
                    }
                    default: {
                        ArrayList<Location> children = new ArrayList<Location>(topLevelPaths.size());
                        for (Path topLevelPath : topLevelPaths) {
                            if (!path.isAncestorOf(topLevelPath)) continue;
                            children.add(new Location(topLevelPath));
                        }
                        if (children.size() <= 0) break;
                        contribution2 = Contribution.createPlaceholder(source, input, expirationTime, children);
                    }
                }
                if (contribution2 == null) {
                    contribution2 = Contribution.create(source, expirationTime);
                }
                contributions.add(contribution2);
                continue;
            }
            int numPaths = pathsInSource.size();
            if (numPaths == 1) {
                Path pathInSource = pathsInSource.iterator().next();
                ReadNodeRequest fromSource = new ReadNodeRequest(new Location(pathInSource));
                sourceConnection.execute(this.getExecutionContext(), (Request)fromSource);
                if (fromSource.hasError()) continue;
                Collection properties = fromSource.getProperties();
                List children = fromSource.getChildren();
                expTime = fromSource.getCachePolicy() == null ? expirationTime : this.getCurrentTimeInUtc().plus(fromSource.getCachePolicy().getTimeToLive(), TimeUnit.MILLISECONDS);
                Location actualLocation = fromSource.getActualLocationOfNode();
                contribution = Contribution.create(source, actualLocation, expTime, properties, children);
                contributions.add(contribution);
                continue;
            }
            ArrayList<ReadNodeRequest> fromSourceCommands = new ArrayList<ReadNodeRequest>(numPaths);
            for (Path pathInSource : pathsInSource) {
                fromSourceCommands.add(new ReadNodeRequest(new Location(pathInSource)));
            }
            Request request = CompositeRequest.with(fromSourceCommands);
            sourceConnection.execute(context, request);
            for (ReadNodeRequest fromSource : fromSourceCommands) {
                if (fromSource.hasError()) continue;
                expTime = fromSource.getCachePolicy() == null ? expirationTime : this.getCurrentTimeInUtc().plus(fromSource.getCachePolicy().getTimeToLive(), TimeUnit.MILLISECONDS);
                List children = fromSource.getChildren();
                contribution = Contribution.create(source, fromSource.getActualLocationOfNode(), expTime, fromSource.getProperties(), children);
                contributions.add(contribution);
            }
        }
    }

    protected MergePlan getMergePlan(ReadNodeRequest request) {
        Property mergePlanProperty = (Property)request.getPropertiesByName().get(DnaLexicon.MERGE_PLAN);
        if (mergePlanProperty == null || mergePlanProperty.isEmpty()) {
            return null;
        }
        Object value = mergePlanProperty.getValues().next();
        return value instanceof MergePlan ? (MergePlan)value : null;
    }

    protected void updateCache(FederatedNode mergedNode) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        RepositoryConnection cacheConnection = this.getConnectionToCache();
        Location path = mergedNode.at();
        ArrayList<CreateNodeRequest> requests = new ArrayList<CreateNodeRequest>();
        requests.add(new CreateNodeRequest(path, (Iterable)mergedNode.getProperties()));
        for (Location child : mergedNode.getChildren()) {
            requests.add(new CreateNodeRequest(child, new Property[0]));
        }
        cacheConnection.execute(context, CompositeRequest.with(requests));
    }
}

