/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.executor;

import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySourceException;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.requests.CopyBranchRequest;
import org.jboss.dna.graph.requests.CreateNodeRequest;
import org.jboss.dna.graph.requests.DeleteBranchRequest;
import org.jboss.dna.graph.requests.MoveBranchRequest;
import org.jboss.dna.graph.requests.ReadAllChildrenRequest;
import org.jboss.dna.graph.requests.ReadAllPropertiesRequest;
import org.jboss.dna.graph.requests.ReadNodeRequest;
import org.jboss.dna.graph.requests.Request;
import org.jboss.dna.graph.requests.UpdatePropertiesRequest;
import org.jboss.dna.graph.requests.processor.RequestProcessor;

@NotThreadSafe
public class SingleProjectionCommandExecutor
extends RequestProcessor {
    private final Projection projection;
    private final PathFactory pathFactory;
    private final RepositoryConnectionFactory connectionFactory;
    private RepositoryConnection connection;

    public SingleProjectionCommandExecutor(ExecutionContext context, String sourceName, Projection projection, RepositoryConnectionFactory connectionFactory) {
        this(context, sourceName, null, projection, connectionFactory);
    }

    public SingleProjectionCommandExecutor(ExecutionContext context, String sourceName, DateTime now, Projection projection, RepositoryConnectionFactory connectionFactory) {
        super(sourceName, context, now);
        assert (connectionFactory != null);
        assert (projection != null);
        assert (projection.getRules().size() == 1);
        this.projection = projection;
        this.connectionFactory = connectionFactory;
        this.pathFactory = context.getValueFactories().getPathFactory();
        assert (this.pathFactory != null);
    }

    protected RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.connection == null) {
            this.connection = this.connectionFactory.createConnection(this.projection.getSourceName());
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
        super.close();
    }

    public void process(ReadAllChildrenRequest request) {
        Location locationInSource = this.projectIntoSource(request.of());
        ReadAllChildrenRequest projected = new ReadAllChildrenRequest(locationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            return;
        }
        for (Location child : projected.getChildren()) {
            request.addChild(child);
        }
    }

    public void process(ReadAllPropertiesRequest request) {
        Location locationInSource = this.projectIntoSource(request.at());
        ReadAllPropertiesRequest projected = new ReadAllPropertiesRequest(locationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, request.at(), (Request)request);
            return;
        }
        for (Property property : projected.getProperties()) {
            request.addProperty(property);
        }
    }

    public void process(ReadNodeRequest request) {
        Location locationInSource = this.projectIntoSource(request.at());
        ReadNodeRequest projected = new ReadNodeRequest(locationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, request.at(), (Request)request);
            return;
        }
        for (Property property : projected.getProperties()) {
            request.addProperty(property);
        }
        for (Location child : projected.getChildren()) {
            request.addChild(child);
        }
    }

    public void process(CreateNodeRequest request) {
        Location locationInSource = this.projectIntoSource(request.at());
        CreateNodeRequest projected = new CreateNodeRequest(locationInSource, (Iterable)request.properties());
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, request.at(), (Request)request);
            return;
        }
    }

    public void process(UpdatePropertiesRequest request) {
        Location locationInSource = this.projectIntoSource(request.on());
        UpdatePropertiesRequest projected = new UpdatePropertiesRequest(locationInSource, (Iterable)request.properties());
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, request.on(), (Request)request);
            return;
        }
    }

    public void process(DeleteBranchRequest request) {
        Location locationInSource = this.projectIntoSource(request.at());
        DeleteBranchRequest projected = new DeleteBranchRequest(locationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, request.at(), (Request)request);
            return;
        }
    }

    public void process(MoveBranchRequest request) {
        Location fromLocationInSource = this.projectIntoSource(request.from());
        Location intoLocationInSource = this.projectIntoSource(request.into());
        MoveBranchRequest projected = new MoveBranchRequest(fromLocationInSource, intoLocationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, null, (Request)request);
            return;
        }
    }

    public void process(CopyBranchRequest request) {
        Location fromLocationInSource = this.projectIntoSource(request.from());
        Location intoLocationInSource = this.projectIntoSource(request.into());
        CopyBranchRequest projected = new CopyBranchRequest(fromLocationInSource, intoLocationInSource);
        this.getConnection().execute(this.getExecutionContext(), (Request)projected);
        if (projected.hasError()) {
            this.projectError((Request)projected, null, (Request)request);
            return;
        }
    }

    protected Location projectIntoSource(Location pathInRepository) {
        Path path = pathInRepository.getPath();
        CheckArg.isNotNull((Object)path, (String)"pathInRepository.getPath()");
        Set<Path> paths = this.projection.getPathsInSource(path, this.pathFactory);
        if (paths.isEmpty()) {
            return null;
        }
        Path projectedPath = paths.iterator().next();
        Location location = null;
        if (pathInRepository.hasIdProperties()) {
            location = new Location(projectedPath, (Iterable)pathInRepository.getIdProperties());
        } else {
            new Location(projectedPath);
        }
        return location;
    }

    protected Location projectIntoRepository(Location pathInSource) {
        Path path = pathInSource.getPath();
        CheckArg.isNotNull((Object)path, (String)"pathInSource.getPath()");
        Path projectedPath = this.projection.getPathsInRepository(path, this.pathFactory).iterator().next();
        Location location = null;
        if (pathInSource.hasIdProperties()) {
            location = new Location(projectedPath, (Iterable)pathInSource.getIdProperties());
        } else {
            new Location(projectedPath);
        }
        return location;
    }

    protected void projectError(Request original, Location originalLocation, Request projected) {
        Throwable error = original.getError();
        if (error instanceof PathNotFoundException) {
            PathNotFoundException pnf = (PathNotFoundException)error;
            Path lowestExisting = pnf.getLowestAncestorThatDoesExist();
            if (lowestExisting != null) {
                lowestExisting = this.projectIntoRepository(new Location(lowestExisting)).getPath();
            }
            if (originalLocation == null) {
                originalLocation = this.projectIntoRepository(pnf.getLocation());
            }
            error = new PathNotFoundException(originalLocation, lowestExisting, pnf.getMessage());
        }
        projected.setError(error);
    }
}

