/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FiveContributionMergePlan;
import org.jboss.dna.connector.federation.merge.FourContributionMergePlan;
import org.jboss.dna.connector.federation.merge.MultipleContributionMergePlan;
import org.jboss.dna.connector.federation.merge.OneContributionMergePlan;
import org.jboss.dna.connector.federation.merge.ThreeContributionMergePlan;
import org.jboss.dna.connector.federation.merge.TwoContributionMergePlan;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class MergePlan
implements Serializable,
Iterable<Contribution> {
    private static final long serialVersionUID = 1L;
    private final ReadWriteLock annotationLock = new ReentrantReadWriteLock();
    private DateTime expirationTimeInUtc;
    @GuardedBy(value="annotationLock")
    private Map<Name, Property> annotations = null;

    public static MergePlan create(Contribution ... contributions) {
        CheckArg.isNotNull((Object)contributions, (String)"contributions");
        switch (contributions.length) {
            case 0: {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(new Object[]{"contributions"}));
            }
            case 1: {
                return new OneContributionMergePlan(contributions[0]);
            }
            case 2: {
                return new TwoContributionMergePlan(contributions[0], contributions[1]);
            }
            case 3: {
                return new ThreeContributionMergePlan(contributions[0], contributions[1], contributions[2]);
            }
            case 4: {
                return new FourContributionMergePlan(contributions[0], contributions[1], contributions[2], contributions[3]);
            }
            case 5: {
                return new FiveContributionMergePlan(contributions[0], contributions[1], contributions[2], contributions[3], contributions[4]);
            }
        }
        return new MultipleContributionMergePlan(contributions);
    }

    public static MergePlan create(Collection<Contribution> contributions) {
        CheckArg.isNotNull(contributions, (String)"contributions");
        Iterator<Contribution> iter = contributions.iterator();
        switch (contributions.size()) {
            case 0: {
                throw new IllegalArgumentException(CommonI18n.argumentMayNotBeEmpty.text(new Object[]{"contributions"}));
            }
            case 1: {
                return new OneContributionMergePlan(iter.next());
            }
            case 2: {
                return new TwoContributionMergePlan(iter.next(), iter.next());
            }
            case 3: {
                return new ThreeContributionMergePlan(iter.next(), iter.next(), iter.next());
            }
            case 4: {
                return new FourContributionMergePlan(iter.next(), iter.next(), iter.next(), iter.next());
            }
            case 5: {
                return new FiveContributionMergePlan(iter.next(), iter.next(), iter.next(), iter.next(), iter.next());
            }
        }
        return new MultipleContributionMergePlan(contributions);
    }

    public static MergePlan addContribution(MergePlan plan, Contribution contribution) {
        CheckArg.isNotNull((Object)plan, (String)"plan");
        CheckArg.isNotNull((Object)contribution, (String)"contribution");
        if (plan instanceof MultipleContributionMergePlan) {
            ((MultipleContributionMergePlan)plan).addContribution(contribution);
            return plan;
        }
        MergePlan newPlan = null;
        if (plan instanceof OneContributionMergePlan) {
            newPlan = new TwoContributionMergePlan((Contribution)plan.iterator().next(), contribution);
        } else if (plan instanceof TwoContributionMergePlan) {
            Iterator iter = plan.iterator();
            newPlan = new ThreeContributionMergePlan((Contribution)iter.next(), (Contribution)iter.next(), contribution);
        } else if (plan instanceof ThreeContributionMergePlan) {
            Iterator iter = plan.iterator();
            newPlan = new FourContributionMergePlan((Contribution)iter.next(), (Contribution)iter.next(), (Contribution)iter.next(), contribution);
        } else if (plan instanceof FourContributionMergePlan) {
            Iterator iter = plan.iterator();
            newPlan = new FiveContributionMergePlan((Contribution)iter.next(), (Contribution)iter.next(), (Contribution)iter.next(), (Contribution)iter.next(), contribution);
        } else {
            MultipleContributionMergePlan multiPlan = new MultipleContributionMergePlan(new Contribution[0]);
            for (Contribution existingContribution : plan) {
                multiPlan.addContribution(existingContribution);
            }
            multiPlan.addContribution(contribution);
            newPlan = multiPlan;
        }
        newPlan.setAnnotations(plan.getAnnotations());
        return newPlan;
    }

    protected MergePlan() {
    }

    public boolean isExpired(DateTime utcTime) {
        assert (utcTime != null);
        assert (utcTime.toUtcTimeZone().equals(utcTime));
        return utcTime.isAfter(this.getExpirationTimeInUtc());
    }

    public DateTime getExpirationTimeInUtc() {
        if (this.expirationTimeInUtc == null) {
            DateTime earliest = null;
            for (Contribution contribution : this) {
                DateTime contributionTime = contribution.getExpirationTimeInUtc();
                if (earliest != null && (contributionTime == null || !contributionTime.isBefore(earliest))) continue;
                earliest = contributionTime;
            }
            this.expirationTimeInUtc = earliest;
        }
        return this.expirationTimeInUtc;
    }

    public abstract Contribution getContributionFrom(String var1);

    public abstract boolean isSource(String var1);

    public abstract int getContributionCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getAnnotation(Name name) {
        if (name == null) {
            return null;
        }
        try {
            this.annotationLock.readLock().lock();
            if (this.annotations == null) {
                Property property = null;
                return property;
            }
            Property property = this.annotations.get(name);
            return property;
        }
        finally {
            this.annotationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property setAnnotation(Property annotation) {
        if (annotation == null) {
            return null;
        }
        try {
            this.annotationLock.writeLock().lock();
            if (this.annotations == null) {
                this.annotations = new HashMap<Name, Property>();
            }
            Property property = this.annotations.put(annotation.getName(), annotation);
            return property;
        }
        finally {
            this.annotationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAnnotationCount() {
        try {
            this.annotationLock.readLock().lock();
            if (this.annotations == null) {
                int n = 0;
                return n;
            }
            int n = this.annotations.size();
            return n;
        }
        finally {
            this.annotationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Name> getAnnotationNames() {
        try {
            this.annotationLock.readLock().lock();
            if (this.annotations == null) {
                Set<Name> set = Collections.emptySet();
                return set;
            }
            Set<Name> set = Collections.unmodifiableSet(this.annotations.keySet());
            return set;
        }
        finally {
            this.annotationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(Map<Name, Property> annotations) {
        try {
            this.annotationLock.writeLock().lock();
            this.annotations = annotations == null || annotations.isEmpty() ? null : annotations;
        }
        finally {
            this.annotationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Name, Property> getAnnotations() {
        Map<Name, Property> result = null;
        try {
            this.annotationLock.writeLock().lock();
            result = this.annotations != null && !this.annotations.isEmpty() ? new HashMap<Name, Property>(this.annotations) : Collections.emptyMap();
        }
        finally {
            this.annotationLock.writeLock().unlock();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Contribution contribution : this) {
            if (!first) {
                first = false;
                sb.append(", ");
            }
            sb.append(contribution);
        }
        sb.append(this.getAnnotations());
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MergePlan) {
            MergePlan that = (MergePlan)obj;
            if (this.getContributionCount() != that.getContributionCount()) {
                return false;
            }
            Iterator thisContribution = this.iterator();
            Iterator thatContribution = that.iterator();
            while (thisContribution.hasNext() && thatContribution.hasNext()) {
                if (((Contribution)thisContribution.next()).equals(thatContribution.next())) continue;
                return false;
            }
            if (this.getAnnotationCount() != that.getAnnotationCount()) {
                return false;
            }
            return ((Object)this.getAnnotations()).equals(that.getAnnotations());
        }
        return false;
    }

    protected boolean checkEachContributionIsFromDistinctSource() {
        HashSet<String> sourceNames = new HashSet<String>();
        for (Contribution contribution : this) {
            boolean added = sourceNames.add(contribution.getSourceName());
            if (added) continue;
            return false;
        }
        return true;
    }
}

