/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.MergePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OneContributionMergePlan
extends MergePlan {
    private static final long serialVersionUID = 1L;
    private final Contribution contribution;

    OneContributionMergePlan(Contribution contribution) {
        assert (contribution != null);
        this.contribution = contribution;
    }

    @Override
    public int getContributionCount() {
        return 1;
    }

    @Override
    public Contribution getContributionFrom(String sourceName) {
        return this.isSource(sourceName) ? this.contribution : null;
    }

    @Override
    public Iterator<Contribution> iterator() {
        return new Iterator<Contribution>(){
            private boolean next = true;

            @Override
            public boolean hasNext() {
                return this.next;
            }

            @Override
            public Contribution next() {
                if (this.next) {
                    this.next = false;
                    return OneContributionMergePlan.this.contribution;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSource(String sourceName) {
        return this.contribution.getSourceName().equals(sourceName);
    }

    public int hashCode() {
        return this.contribution.hashCode();
    }
}

