/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.MergePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ThreeContributionMergePlan
extends MergePlan {
    private static final long serialVersionUID = 1L;
    private final Contribution contribution1;
    private final Contribution contribution2;
    private final Contribution contribution3;

    ThreeContributionMergePlan(Contribution contribution1, Contribution contribution2, Contribution contribution3) {
        assert (contribution1 != null);
        assert (contribution2 != null);
        assert (contribution3 != null);
        this.contribution1 = contribution1;
        this.contribution2 = contribution2;
        this.contribution3 = contribution3;
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    @Override
    public int getContributionCount() {
        return 3;
    }

    @Override
    public Contribution getContributionFrom(String sourceName) {
        if (this.contribution1.getSourceName().equals(sourceName)) {
            return this.contribution1;
        }
        if (this.contribution2.getSourceName().equals(sourceName)) {
            return this.contribution2;
        }
        if (this.contribution3.getSourceName().equals(sourceName)) {
            return this.contribution3;
        }
        return null;
    }

    @Override
    public Iterator<Contribution> iterator() {
        return new Iterator<Contribution>(){
            private int next = 3;

            @Override
            public boolean hasNext() {
                return this.next > 0;
            }

            @Override
            public Contribution next() {
                if (this.next == 3) {
                    this.next = 2;
                    return ThreeContributionMergePlan.this.contribution1;
                }
                if (this.next == 2) {
                    this.next = 1;
                    return ThreeContributionMergePlan.this.contribution2;
                }
                if (this.next == 1) {
                    this.next = 0;
                    return ThreeContributionMergePlan.this.contribution3;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSource(String sourceName) {
        if (this.contribution1.getSourceName().equals(sourceName)) {
            return true;
        }
        if (this.contribution2.getSourceName().equals(sourceName)) {
            return true;
        }
        return this.contribution3.getSourceName().equals(sourceName);
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.contribution1, this.contribution2, this.contribution3});
    }
}

