/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge.strategy;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OneContributionMergeStrategy
implements MergeStrategy {
    @Override
    public void merge(FederatedNode federatedNode, List<Contribution> contributions, ExecutionContext context) {
        UUID uuid;
        assert (federatedNode != null);
        assert (context != null);
        assert (contributions != null);
        assert (contributions.size() > 0);
        Contribution contribution = contributions.get(0);
        assert (contribution != null);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Location location = federatedNode.getActualLocationOfNode();
        Iterator<Location> childIterator = contribution.getChildren();
        while (childIterator.hasNext()) {
            Location child = this.translateChildFromSourceToRepository(pathFactory, location, childIterator.next());
            federatedNode.addChild(child);
        }
        Property uuidProperty = null;
        Property dnaUuidProperty = null;
        Iterator<Property> propertyIterator = contribution.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            federatedNode.addProperty(property);
            if (!property.isSingle()) continue;
            if (property.getName().equals(DnaLexicon.UUID) && this.hasUuidValue(context, property)) {
                dnaUuidProperty = property;
                continue;
            }
            if (!property.getName().getLocalName().equals("uuid") || !this.hasUuidValue(context, property)) continue;
            uuidProperty = property;
        }
        if (dnaUuidProperty != null) {
            uuidProperty = dnaUuidProperty;
        }
        if (uuidProperty != null && !uuidProperty.isEmpty()) {
            uuid = (UUID)context.getValueFactories().getUuidFactory().create(uuidProperty.getValues().next());
            federatedNode.setUuid(uuid);
            if (dnaUuidProperty == null) {
                uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{uuid});
            }
            federatedNode.setActualLocationOfNode(federatedNode.getActualLocationOfNode().with(uuidProperty));
        } else {
            uuidProperty = federatedNode.getActualLocationOfNode().getIdProperty(DnaLexicon.UUID);
            if (uuidProperty == null || uuidProperty.isEmpty()) {
                uuid = federatedNode.getUuid();
                if (uuid == null) {
                    uuid = context.getValueFactories().getUuidFactory().create();
                    federatedNode.setUuid(uuid);
                }
                uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{uuid});
            }
            federatedNode.addProperty(uuidProperty);
        }
        MergePlan mergePlan = MergePlan.create(contributions);
        federatedNode.setMergePlan(mergePlan);
    }

    private boolean hasUuidValue(ExecutionContext context, Property property) {
        assert (property.isSingle());
        try {
            context.getValueFactories().getUuidFactory().create(property.getValues().next());
            return true;
        }
        catch (ValueFormatException e) {
            return false;
        }
    }

    protected Location translateChildFromSourceToRepository(PathFactory factory, Location parent, Location childInSource) {
        Path parentPath = parent.getPath();
        if (parentPath == null) {
            return childInSource;
        }
        Path newPath = factory.create(parentPath, new Path.Segment[]{childInSource.getPath().getLastSegment()});
        return childInSource.with(newPath);
    }
}

