/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge.strategy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.ValueComparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SimpleMergeStrategy
implements MergeStrategy {
    private boolean removeDuplicateProperties = true;

    public boolean isRemoveDuplicateProperties() {
        return this.removeDuplicateProperties;
    }

    public void setRemoveDuplicateProperties(boolean removeDuplicateProperties) {
        this.removeDuplicateProperties = removeDuplicateProperties;
    }

    @Override
    public void merge(FederatedNode federatedNode, List<Contribution> contributions, ExecutionContext context) {
        Property uuidProperty;
        assert (federatedNode != null);
        assert (context != null);
        assert (contributions != null);
        assert (contributions.size() > 0);
        Location location = federatedNode.getActualLocationOfNode();
        boolean isRoot = location.hasPath() && location.getPath().isRoot();
        boolean removeDuplicateProperties = this.isRemoveDuplicateProperties();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        HashMap<Name, Integer> childNames = new HashMap<Name, Integer>();
        Map properties = federatedNode.getPropertiesByName();
        properties.clear();
        HashMap<Name, Property> idProperties = new HashMap<Name, Property>();
        for (Property idProperty : location) {
            idProperties.put(idProperty.getName(), idProperty);
        }
        for (Contribution contribution : contributions) {
            if (contribution.isEmpty()) continue;
            if (contribution.isPlaceholder()) {
                Iterator<Location> childIterator = contribution.getChildren();
                while (childIterator.hasNext()) {
                    Location child = childIterator.next();
                    Name childName = child.getPath().getLastSegment().getName();
                    if (childNames.containsKey(childName)) continue;
                    childNames.put(childName, 1);
                    Path pathToChild = pathFactory.create(location.getPath(), new Name[]{childName});
                    federatedNode.addChild(new Location(pathToChild));
                }
                continue;
            }
            Location contributionLocation = contribution.getLocationInSource();
            for (Property idProperty : contributionLocation) {
                Property existing = properties.put(idProperty.getName(), idProperty);
                if (existing == null) continue;
                Property merged = this.merge(existing, idProperty, context.getPropertyFactory(), removeDuplicateProperties);
                properties.put(merged.getName(), merged);
            }
            Iterator<Location> childIterator = contribution.getChildren();
            while (childIterator.hasNext()) {
                Location child = childIterator.next();
                Name childName = child.getPath().getLastSegment().getName();
                int index = -1;
                Integer previous = childNames.put(childName, 1);
                if (previous != null) {
                    int previousValue = previous;
                    childNames.put(childName, ++previousValue);
                    index = previousValue;
                }
                Path pathToChild = pathFactory.create(location.getPath(), childName, index);
                federatedNode.addChild(new Location(pathToChild));
            }
            Iterator<Property> propertyIter = contribution.getProperties();
            while (propertyIter.hasNext()) {
                Property existing;
                Property property = propertyIter.next();
                if (isRoot && property.getName().getLocalName().equals("uuid") || (existing = properties.put(property.getName(), property)) == null) continue;
                Property merged = this.merge(existing, property, context.getPropertyFactory(), removeDuplicateProperties);
                properties.put(property.getName(), merged);
            }
        }
        if (idProperties.size() != 0) {
            Location newLocation = new Location(location.getPath(), idProperties.values());
            federatedNode.setActualLocationOfNode(newLocation);
            uuidProperty = (Property)idProperties.get(DnaLexicon.UUID);
            if (uuidProperty != null && !uuidProperty.isEmpty()) {
                UUID uuid = (UUID)context.getValueFactories().getUuidFactory().create(uuidProperty.getValues().next());
                federatedNode.setUuid(uuid);
                properties.put(uuidProperty.getName(), uuidProperty);
            }
        } else {
            UUID uuid = federatedNode.getUuid();
            if (uuid == null) {
                uuid = context.getValueFactories().getUuidFactory().create();
                federatedNode.setUuid(uuid);
            }
            uuidProperty = context.getPropertyFactory().create(DnaLexicon.UUID, new Object[]{uuid});
            properties.put(uuidProperty.getName(), uuidProperty);
        }
        MergePlan mergePlan = MergePlan.create(contributions);
        federatedNode.setMergePlan(mergePlan);
    }

    protected Property merge(Property property1, Property property2, PropertyFactory factory, boolean removeDuplicates) {
        assert (property1 != null);
        assert (property2 != null);
        assert (property1.getName().equals(property2.getName()));
        if (property1.isEmpty()) {
            return property2;
        }
        if (property2.isEmpty()) {
            return property1;
        }
        if (property1.isSingle() && property2.isSingle()) {
            Object value1 = property1.getValues().next();
            Object value2 = property2.getValues().next();
            if (removeDuplicates && ValueComparators.OBJECT_COMPARATOR.compare(value1, value2) == 0) {
                return property1;
            }
            return factory.create(property1.getName(), new Object[]{value1, value2});
        }
        if (!removeDuplicates) {
            DualIterator valueIterator = new DualIterator(property1.getValues(), property2.getValues());
            return factory.create(property1.getName(), (Iterator)valueIterator);
        }
        Object[] values = new Object[property1.size() + property2.size()];
        int index = 0;
        for (Object property1Value : property1) {
            values[index++] = property1Value;
        }
        assert (index == property1.size());
        for (Object property2Value : property2) {
            boolean matched = false;
            for (Object property1Value : property1) {
                if (ValueComparators.OBJECT_COMPARATOR.compare(property1Value, property2Value) != 0) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            values[index++] = property2Value;
        }
        if (index != values.length) {
            Object[] newValues = new Object[index];
            System.arraycopy(values, 0, newValues, 0, index);
            values = newValues;
        }
        return factory.create(property1.getName(), values);
    }

    protected static class Child {
        private final Location location;
        private final boolean placeholder;

        protected Child(Location location, boolean placeholder) {
            assert (location != null);
            this.location = location;
            this.placeholder = placeholder;
        }

        public int hashCode() {
            return this.location.hasIdProperties() ? ((Object)this.location.getIdProperties()).hashCode() : this.location.getPath().getLastSegment().getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Child) {
                Child that = (Child)obj;
                if (this.placeholder && that.placeholder) {
                    assert (this.location.hasPath());
                    assert (that.location.hasPath());
                    Name thisName = this.location.getPath().getLastSegment().getName();
                    Name thatName = that.location.getPath().getLastSegment().getName();
                    return thisName.equals(thatName);
                }
                if (this.location.hasIdProperties() && that.location.hasIdProperties()) {
                    List thisIds = this.location.getIdProperties();
                    List thatIds = that.location.getIdProperties();
                    if (thisIds.size() != thatIds.size()) {
                        return false;
                    }
                    return thisIds.containsAll(thatIds);
                }
                return this.location.equals((Object)that.location);
            }
            return false;
        }

        public String toString() {
            return this.location.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DualIterator
    implements Iterator<Object> {
        private final Iterator<?>[] iterators;
        private Iterator<?> current;
        private int index = 0;

        protected DualIterator(Iterator<?> ... iterators) {
            assert (iterators != null);
            assert (iterators.length > 0);
            this.iterators = iterators;
            this.current = this.iterators[0];
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return this.current.hasNext();
            }
            return false;
        }

        @Override
        public Object next() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                if (++this.index < this.iterators.length) {
                    this.current = this.iterators[this.index];
                    continue;
                }
                this.current = null;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

