/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.FederatedLexicon;
import org.jboss.dna.connector.federation.FederatedRepository;
import org.jboss.dna.connector.federation.FederatedWorkspace;
import org.jboss.dna.connector.federation.FederationException;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.ProjectionParser;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.SubgraphNode;
import org.jboss.dna.graph.cache.BasicCachePolicy;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.ValueFactories;
import org.jboss.dna.graph.property.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederatedRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 7587346948013486977L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_CONFIGURATION_SOURCE_PATH = "/";
    protected static final RepositorySourceCapabilities CAPABILITIES = new RepositorySourceCapabilities(true, true);
    protected static final String REPOSITORY_NAME = "repositoryName";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String CONFIGURATION_SOURCE_NAME = "configurationSourceName";
    protected static final String CONFIGURATION_SOURCE_PATH = "configurationSourcePath";
    protected static final String SECURITY_DOMAIN = "securityDomain";
    protected static final String RETRY_LIMIT = "retryLimit";
    private String repositoryName;
    private String sourceName;
    private String username;
    private String password;
    private String configurationSourceName;
    private String configurationWorkspaceName;
    private String configurationSourcePath = "/";
    private String securityDomain;
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private transient FederatedRepository repository;
    private transient RepositoryContext repositoryContext;

    public FederatedRepositorySource() {
    }

    public FederatedRepositorySource(String repositoryName) {
        CheckArg.isNotNull((Object)repositoryName, (String)REPOSITORY_NAME);
        this.repositoryName = repositoryName;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public synchronized String getName() {
        return this.sourceName;
    }

    public synchronized void setName(String sourceName) {
        if (this.sourceName == sourceName || this.sourceName != null && this.sourceName.equals(sourceName)) {
            return;
        }
        this.sourceName = sourceName;
        this.changeRepositoryConfig();
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public String getConfigurationSourceName() {
        return this.configurationSourceName;
    }

    public void setConfigurationSourceName(String sourceName) {
        if (this.configurationSourceName == sourceName || this.configurationSourceName != null && this.configurationSourceName.equals(sourceName)) {
            return;
        }
        this.configurationSourceName = sourceName;
        this.changeRepositoryConfig();
    }

    public String getConfigurationWorkspaceName() {
        return this.configurationWorkspaceName;
    }

    public void setConfigurationWorkspaceName(String workspaceName) {
        if (this.configurationWorkspaceName == workspaceName || this.configurationWorkspaceName != null && this.configurationWorkspaceName.equals(workspaceName)) {
            return;
        }
        this.configurationWorkspaceName = workspaceName;
        this.changeRepositoryConfig();
    }

    public String getConfigurationSourcePath() {
        return this.configurationSourcePath;
    }

    public void setConfigurationSourcePath(String pathInSourceToConfigurationRoot) {
        if (this.configurationSourcePath == pathInSourceToConfigurationRoot || this.configurationSourcePath != null && this.configurationSourcePath.equals(pathInSourceToConfigurationRoot)) {
            return;
        }
        String path = pathInSourceToConfigurationRoot != null ? pathInSourceToConfigurationRoot : DEFAULT_CONFIGURATION_SOURCE_PATH;
        this.configurationSourcePath = path = (DEFAULT_CONFIGURATION_SOURCE_PATH + path).replaceAll("^/+", DEFAULT_CONFIGURATION_SOURCE_PATH).replaceAll("/+$", "") + DEFAULT_CONFIGURATION_SOURCE_PATH;
        this.changeRepositoryConfig();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        if (this.securityDomain != null && this.securityDomain.equals(securityDomain)) {
            return;
        }
        this.securityDomain = securityDomain;
        this.changeRepositoryConfig();
    }

    public synchronized String getRepositoryName() {
        return this.repositoryName;
    }

    public synchronized void setRepositoryName(String repositoryName) {
        CheckArg.isNotEmpty((String)repositoryName, (String)REPOSITORY_NAME);
        if (this.repositoryName != null && this.repositoryName.equals(repositoryName)) {
            return;
        }
        this.repositoryName = repositoryName;
        this.changeRepositoryConfig();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.username != null && this.username.equals(username)) {
            return;
        }
        this.username = username;
        this.changeRepositoryConfig();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (this.password != null && this.password.equals(password)) {
            return;
        }
        this.password = password;
        this.changeRepositoryConfig();
    }

    protected synchronized void changeRepositoryConfig() {
        RepositoryContext repositoryContext;
        if (this.repository != null && (repositoryContext = this.getRepositoryContext()) != null) {
            this.repository = this.getRepository();
        }
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        String credentials;
        String username;
        if (this.getName() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.getRepositoryContext() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"repository context"}));
        }
        if (this.getUsername() != null && this.getSecurityDomain() == null) {
            I18n msg = FederationI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"security domain"}));
        }
        FederatedRepository repository = this.getRepository();
        RepositoryConnection connection = repository.createConnection(this, username = this.username, credentials = this.password);
        if (connection == null) {
            I18n msg = FederationI18n.unableToAuthenticateConnectionToFederatedRepository;
            throw new RepositorySourceException(msg.text(new Object[]{this.repositoryName, username}));
        }
        return connection;
    }

    protected synchronized FederatedRepository getRepository() throws RepositorySourceException {
        if (this.repository == null) {
            ExecutionContext context = this.getExecutionContext();
            RepositoryConnectionFactory connectionFactory = this.getRepositoryContext().getRepositoryConnectionFactory();
            List<FederatedWorkspace> configs = this.getWorkspaceConfigurations(context, connectionFactory);
            this.repository = new FederatedRepository(this.repositoryName, context, connectionFactory, configs);
        }
        return this.repository;
    }

    protected ExecutionContext getExecutionContext() {
        ExecutionContext factory = this.getRepositoryContext().getExecutionContext();
        CallbackHandler handler = this.createCallbackHandler();
        try {
            String securityDomain = this.getSecurityDomain();
            if (securityDomain != null || this.getUsername() != null) {
                return factory.with(securityDomain, handler);
            }
            return factory;
        }
        catch (LoginException e) {
            I18n msg = FederationI18n.unableToCreateExecutionContext;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{this.sourceName, this.securityDomain}), (Throwable)e);
        }
    }

    protected CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(FederatedRepositorySource.this.getUsername());
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(FederatedRepositorySource.this.getPassword().toCharArray());
                }
            }
        };
    }

    protected synchronized List<FederatedWorkspace> getWorkspaceConfigurations(ExecutionContext context, RepositoryConnectionFactory connectionFactory) {
        SubgraphNode workspacesNode;
        SimpleProblems problems = new SimpleProblems();
        ValueFactories valueFactories = context.getValueFactories();
        ValueFactory strings = valueFactories.getStringFactory();
        ValueFactory longs = valueFactories.getLongFactory();
        ProjectionParser projectionParser = ProjectionParser.getInstance();
        Graph config = Graph.create((String)this.configurationSourceName, (RepositoryConnectionFactory)connectionFactory, (ExecutionContext)context);
        if (this.configurationWorkspaceName != null) {
            config.useWorkspace(this.configurationWorkspaceName);
        }
        String configurationWorkspaceName = config.getCurrentWorkspaceName();
        Subgraph repositories = (Subgraph)config.getSubgraphOfDepth(5).at(this.getConfigurationSourcePath());
        String defaultWorkspaceName = null;
        Property defaultWorkspaceNameProperty = repositories.getRoot().getProperty(FederatedLexicon.DEFAULT_WORKSPACE_NAME);
        if (defaultWorkspaceNameProperty != null) {
            defaultWorkspaceName = (String)strings.create(defaultWorkspaceNameProperty.getFirstValue());
        }
        if ((workspacesNode = repositories.getNode(FederatedLexicon.WORKSPACES)) == null) {
            I18n msg = FederationI18n.requiredNodeDoesNotExistRelativeToNode;
            String name = FederatedLexicon.WORKSPACES.getString(context.getNamespaceRegistry());
            String relativeTo = repositories.getLocation().getPath().getString(context.getNamespaceRegistry());
            throw new FederationException(msg.text(new Object[]{name, relativeTo, configurationWorkspaceName, this.configurationSourceName}));
        }
        LinkedList<FederatedWorkspace> workspaces = new LinkedList<FederatedWorkspace>();
        for (Location workspace : workspacesNode) {
            SubgraphNode projectionsNode;
            String workspaceName = null;
            SubgraphNode workspaceNode = (SubgraphNode)repositories.getNode(workspace);
            Property workspaceNameProperty = workspaceNode.getProperty(FederatedLexicon.WORKSPACE_NAME);
            if (workspaceNameProperty != null) {
                workspaceName = (String)strings.create(workspaceNameProperty.getFirstValue());
            }
            if (workspaceName == null) {
                workspaceName = workspace.getPath().getLastSegment().getName().getLocalName();
            }
            Projection cacheProjection = null;
            CachePolicy cachePolicy = null;
            SubgraphNode cacheNode = workspaceNode.getNode(FederatedLexicon.CACHE);
            if (cacheNode != null) {
                cacheProjection = this.createProjection(context, projectionParser, (Node)cacheNode, (Problems)problems);
                Property timeToExpire = cacheNode.getProperty(FederatedLexicon.TIME_TO_EXPIRE);
                if (timeToExpire != null && !timeToExpire.isEmpty()) {
                    long timeToCacheInMillis = (Long)longs.create(timeToExpire.getFirstValue());
                    cachePolicy = new BasicCachePolicy(timeToCacheInMillis, TimeUnit.MILLISECONDS).getUnmodifiable();
                }
            }
            if ((projectionsNode = workspaceNode.getNode(FederatedLexicon.PROJECTIONS)) == null) {
                I18n msg = FederationI18n.requiredNodeDoesNotExistRelativeToNode;
                String name = FederatedLexicon.PROJECTIONS.getString(context.getNamespaceRegistry());
                String relativeTo = workspaceNode.getLocation().getPath().getString(context.getNamespaceRegistry());
                throw new FederationException(msg.text(new Object[]{name, relativeTo, configurationWorkspaceName, this.configurationSourceName}));
            }
            LinkedList<Projection> sourceProjections = new LinkedList<Projection>();
            for (Location projection : projectionsNode) {
                Node projectionNode = repositories.getNode(projection);
                sourceProjections.add(this.createProjection(context, projectionParser, projectionNode, (Problems)problems));
            }
            FederatedWorkspace space = new FederatedWorkspace(workspaceName, cacheProjection, sourceProjections, cachePolicy);
            if (workspaceName.equals(defaultWorkspaceName)) {
                workspaces.addFirst(space);
                continue;
            }
            workspaces.add(space);
        }
        return workspaces;
    }

    protected Projection createProjection(ExecutionContext context, ProjectionParser projectionParser, Node node, Problems problems) {
        String[] projectionRuleStrs;
        ValueFactory strings = context.getValueFactories().getStringFactory();
        Path path = node.getLocation().getPath();
        String sourceName = path.getLastSegment().getName().getLocalName();
        Property sourceNameProperty = node.getProperty(FederatedLexicon.SOURCE_NAME);
        if (sourceNameProperty != null && !sourceNameProperty.isEmpty()) {
            sourceName = (String)strings.create(sourceNameProperty.getFirstValue());
        }
        assert (sourceName != null);
        String workspaceName = null;
        Property workspaceNameProperty = node.getProperty(FederatedLexicon.WORKSPACE_NAME);
        if (workspaceNameProperty != null && !workspaceNameProperty.isEmpty()) {
            workspaceName = (String)strings.create(workspaceNameProperty.getFirstValue());
        }
        Projection.Rule[] projectionRules = null;
        Property projectionRulesProperty = node.getProperty(FederatedLexicon.PROJECTION_RULES);
        if (projectionRulesProperty != null && !projectionRulesProperty.isEmpty() && (projectionRuleStrs = (String[])strings.create(projectionRulesProperty.getValuesAsArray())) != null && projectionRuleStrs.length != 0) {
            projectionRules = projectionParser.rulesFromStrings(context, projectionRuleStrs);
        }
        if (problems.hasErrors()) {
            return null;
        }
        return new Projection(sourceName, workspaceName, projectionRules);
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getRepositoryName() != null) {
            ref.add(new StringRefAddr(REPOSITORY_NAME, this.getRepositoryName()));
        }
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getUsername() != null) {
            ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        }
        if (this.getPassword() != null) {
            ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        }
        if (this.getConfigurationSourceName() != null) {
            ref.add(new StringRefAddr(CONFIGURATION_SOURCE_NAME, this.getConfigurationSourceName()));
        }
        if (this.getConfigurationSourcePath() != null) {
            ref.add(new StringRefAddr(CONFIGURATION_SOURCE_PATH, this.getConfigurationSourcePath()));
        }
        if (this.getSecurityDomain() != null) {
            ref.add(new StringRefAddr(SECURITY_DOMAIN, this.getSecurityDomain()));
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, String> values = new HashMap<String, String>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr subref = en.nextElement();
                if (!(subref instanceof StringRefAddr)) continue;
                String key = subref.getType();
                Object value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
            }
            String repositoryName = (String)values.get(REPOSITORY_NAME);
            String sourceName = (String)values.get(SOURCE_NAME);
            String username = (String)values.get(USERNAME);
            String password = (String)values.get(PASSWORD);
            String configurationSourceName = (String)values.get(CONFIGURATION_SOURCE_NAME);
            String configurationSourcePath = (String)values.get(CONFIGURATION_SOURCE_PATH);
            String securityDomain = (String)values.get(SECURITY_DOMAIN);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            FederatedRepositorySource source = new FederatedRepositorySource();
            if (repositoryName != null) {
                source.setRepositoryName(repositoryName);
            }
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (username != null) {
                source.setUsername(username);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (configurationSourceName != null) {
                source.setConfigurationSourceName(configurationSourceName);
            }
            if (configurationSourcePath != null) {
                source.setConfigurationSourcePath(configurationSourcePath);
            }
            if (securityDomain != null) {
                source.setSecurityDomain(securityDomain);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    public int hashCode() {
        return this.repositoryName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedRepositorySource) {
            FederatedRepositorySource that = (FederatedRepositorySource)obj;
            if (!this.getRepositoryName().equals(that.getRepositoryName())) {
                return false;
            }
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return CAPABILITIES;
    }
}

