/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.ThreadSafeProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.merge.strategy.MergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.OneContributionMergeStrategy;
import org.jboss.dna.connector.federation.merge.strategy.SimpleMergeStrategy;
import org.jboss.dna.graph.cache.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FederatedWorkspace
implements Comparable<FederatedWorkspace> {
    private final Projection cacheProjection;
    private final CachePolicy cachePolicy;
    private final List<Projection> sourceProjections;
    private final Map<String, List<Projection>> projectionsBySourceName;
    private final Problems problems;
    private final String name;
    private final MergeStrategy mergingStrategy;

    public FederatedWorkspace(String workspaceName, Projection cacheProjection, Iterable<Projection> sourceProjections, CachePolicy cachePolicy) {
        this(workspaceName, cacheProjection, sourceProjections, cachePolicy, null);
    }

    public FederatedWorkspace(String workspaceName, Projection cacheProjection, Iterable<Projection> sourceProjections, CachePolicy cachePolicy, MergeStrategy mergeStrategy) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)cacheProjection, (String)"cacheProjection");
        this.name = workspaceName;
        this.cachePolicy = cachePolicy;
        this.problems = new ThreadSafeProblems();
        this.cacheProjection = cacheProjection;
        ArrayList<Projection> projectionList = new ArrayList<Projection>();
        for (Projection projection : sourceProjections) {
            if (projection == null || projectionList.contains(projection)) continue;
            projectionList.add(projection);
        }
        this.sourceProjections = Collections.unmodifiableList(projectionList);
        CheckArg.isNotEmpty(this.sourceProjections, (String)"sourceProjections");
        this.projectionsBySourceName = new HashMap<String, List<Projection>>();
        for (Projection projection : this.sourceProjections) {
            String sourceName = projection.getSourceName();
            List<Projection> projectionsForSource = this.projectionsBySourceName.get(sourceName);
            if (projectionsForSource == null) {
                projectionsForSource = new LinkedList<Projection>();
                this.projectionsBySourceName.put(sourceName, projectionsForSource);
            }
            projectionsForSource.add(projection);
        }
        this.mergingStrategy = mergeStrategy != null ? mergeStrategy : (this.sourceProjections.size() == 1 && this.sourceProjections.get(0).isSimple() ? new OneContributionMergeStrategy() : new SimpleMergeStrategy());
        assert (this.mergingStrategy != null);
    }

    public String getName() {
        return this.name;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public MergeStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public Projection getCacheProjection() {
        return this.cacheProjection;
    }

    public List<Projection> getSourceProjections() {
        return this.sourceProjections;
    }

    public List<Projection> getProjectionsFor(String sourceName) {
        return this.projectionsBySourceName.get(sourceName);
    }

    public boolean contains(String sourceName, String workspaceName) {
        List<Projection> projections = this.projectionsBySourceName.get(sourceName);
        if (projections != null) {
            for (Projection projection : this.sourceProjections) {
                if (!projection.getWorkspaceName().equals(workspaceName)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedWorkspace) {
            FederatedWorkspace that = (FederatedWorkspace)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            if (!this.getCacheProjection().equals(that.getCacheProjection())) {
                return false;
            }
            return ((Object)this.getSourceProjections()).equals(that.getSourceProjections());
        }
        return false;
    }

    @Override
    public int compareTo(FederatedWorkspace that) {
        if (that == this) {
            return 0;
        }
        int diff = this.getName().compareTo(that.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.getCacheProjection().compareTo(that.getCacheProjection());
        if (diff != 0) {
            return diff;
        }
        Iterator<Projection> thisIter = this.getSourceProjections().iterator();
        Iterator<Projection> thatIter = that.getSourceProjections().iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            diff = thisIter.next().compareTo(thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }
}

