/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.federation.FederatedWorkspace;
import org.jboss.dna.connector.federation.FederationI18n;
import org.jboss.dna.connector.federation.Projection;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.FederatedNode;
import org.jboss.dna.connector.federation.merge.MergePlan;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.request.CacheableRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UnsupportedRequestException;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class FederatingRequestProcessor
extends RequestProcessor {
    private static final Set<Name> HIDDEN_PROPERTIES = Collections.singleton(DnaLexicon.MERGE_PLAN);
    private final Map<String, FederatedWorkspace> workspaces;
    private final FederatedWorkspace defaultWorkspace;
    private final RepositoryConnectionFactory connectionFactory;
    private final Map<String, RepositoryConnection> connectionsBySourceName;
    protected final PathFactory pathFactory;
    private Logger logger;

    public FederatingRequestProcessor(ExecutionContext context, String sourceName, Map<String, FederatedWorkspace> workspaces, FederatedWorkspace defaultWorkspace, RepositoryConnectionFactory connectionFactory) {
        super(sourceName, context);
        CheckArg.isNotEmpty(workspaces, (String)"workspaces");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        this.workspaces = workspaces;
        this.connectionFactory = connectionFactory;
        this.logger = context.getLogger(((Object)((Object)this)).getClass());
        this.connectionsBySourceName = new HashMap<String, RepositoryConnection>();
        this.defaultWorkspace = defaultWorkspace;
        this.pathFactory = context.getValueFactories().getPathFactory();
    }

    protected DateTime getCurrentTimeInUtc() {
        return this.getExecutionContext().getValueFactories().getDateFactory().createUtc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
        }
        catch (Throwable throwable) {
            for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (Throwable t) {
                    this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
                }
            }
            this.connectionsBySourceName.clear();
            throw throwable;
        }
        for (RepositoryConnection connection : this.connectionsBySourceName.values()) {
            if (connection == null) continue;
            try {
                connection.close();
            }
            catch (Throwable t) {
                this.logger.debug("Error while closing connection to {0}", new Object[]{connection.getSourceName()});
            }
        }
        this.connectionsBySourceName.clear();
    }

    protected RepositoryConnection getConnectionToCacheFor(FederatedWorkspace workspace) throws RepositorySourceException {
        return this.getConnection(workspace.getCacheProjection());
    }

    protected RepositoryConnection getConnection(Projection projection) throws RepositorySourceException {
        String sourceName = projection.getSourceName();
        RepositoryConnection connection = this.connectionsBySourceName.get(sourceName);
        if (connection == null) {
            connection = this.connectionFactory.createConnection(sourceName);
            this.connectionsBySourceName.put(sourceName, connection);
        }
        return connection;
    }

    protected Set<String> getOpenConnections() {
        return this.connectionsBySourceName.keySet();
    }

    protected FederatedWorkspace getWorkspace(Request request, String workspaceName) {
        String msg;
        FederatedWorkspace workspace = null;
        if (workspaceName == null) {
            if (this.defaultWorkspace != null) {
                return this.defaultWorkspace;
            }
            msg = FederationI18n.noDefaultWorkspace.text(new Object[]{this.getSourceName()});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        }
        if ((workspace = this.workspaces.get(workspaceName)) == null) {
            msg = FederationI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    public void process(ReadAllChildrenRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        ReadNodeRequest nodeInfo = this.getNode(request.of(), workspace);
        if (nodeInfo.hasError()) {
            return;
        }
        for (Location child : nodeInfo.getChildren()) {
            request.addChild(child);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(ReadAllPropertiesRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        ReadNodeRequest nodeInfo = this.getNode(request.at(), workspace);
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            if (HIDDEN_PROPERTIES.contains(property.getName())) continue;
            request.addProperty(property);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(ReadNodeRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        ReadNodeRequest nodeInfo = this.getNode(request.at(), workspace);
        if (nodeInfo.hasError()) {
            return;
        }
        for (Property property : nodeInfo.getProperties()) {
            if (HIDDEN_PROPERTIES.contains(property.getName())) continue;
            request.addProperty(property);
        }
        for (Location child : nodeInfo.getChildren()) {
            request.addChild(child);
        }
        request.setActualLocationOfNode(nodeInfo.getActualLocationOfNode());
    }

    public void process(CreateNodeRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        SingleProjection projection = this.asSingleProjection(workspace, request.under(), (Request)request);
        if (projection == null) {
            return;
        }
        Location parentLocation = Location.create((Path)projection.pathInSource);
        String workspaceName = projection.projection.getWorkspaceName();
        CreateNodeRequest sourceRequest = new CreateNodeRequest(parentLocation, workspaceName, request.named(), (Iterable)request.properties());
        this.execute((Request)sourceRequest, projection.projection);
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
        } else {
            request.setActualLocationOfNode(projection.convertToRepository(sourceRequest.getActualLocationOfNode()));
        }
    }

    public void process(DeleteBranchRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        SingleProjection projection = this.asSingleProjection(workspace, request.at(), (Request)request);
        if (projection == null) {
            return;
        }
        Location sourceLocation = Location.create((Path)projection.pathInSource);
        String workspaceName = projection.projection.getWorkspaceName();
        DeleteBranchRequest sourceRequest = new DeleteBranchRequest(sourceLocation, workspaceName);
        this.execute((Request)sourceRequest, projection.projection);
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
        } else {
            request.setActualLocationOfNode(projection.convertToRepository(sourceRequest.getActualLocationOfNode()));
        }
        DeleteBranchRequest cacheRequest = new DeleteBranchRequest(request.at(), workspace.getCacheProjection().getWorkspaceName());
        this.executeInCache((Request)cacheRequest, workspace);
    }

    public void process(CopyBranchRequest request) {
        SingleProjection fromProjection;
        FederatedWorkspace fromWorkspace = this.getWorkspace((Request)request, request.fromWorkspace());
        if (fromWorkspace == null) {
            return;
        }
        FederatedWorkspace intoWorkspace = this.getWorkspace((Request)request, request.intoWorkspace());
        if (intoWorkspace == null) {
            return;
        }
        if (!fromWorkspace.equals(intoWorkspace)) {
            String msg = FederationI18n.unableToPerformOperationSpanningWorkspaces.text(new Object[]{fromWorkspace.getName(), intoWorkspace.getName()});
            request.setError((Throwable)new UnsupportedRequestException(msg));
        }
        if ((fromProjection = this.asSingleProjection(fromWorkspace, request.from(), (Request)request)) == null) {
            return;
        }
        SingleProjection intoProjection = this.asSingleProjection(intoWorkspace, request.into(), (Request)request);
        if (intoProjection == null) {
            return;
        }
        if (!intoProjection.projection.equals(fromProjection.projection)) {
            String msg = FederationI18n.unableToPerformOperationUnlessLocationsAreFromSingleProjection.text(new Object[]{request.from(), request.into(), fromWorkspace.getName(), fromProjection.projection.getRules(), intoProjection.projection.getRules()});
            request.setError((Throwable)new UnsupportedRequestException(msg));
        }
        Location fromLocation = Location.create((Path)fromProjection.pathInSource);
        Location intoLocation = Location.create((Path)intoProjection.pathInSource);
        String workspaceName = fromProjection.projection.getWorkspaceName();
        CopyBranchRequest sourceRequest = new CopyBranchRequest(fromLocation, workspaceName, intoLocation, workspaceName, request.desiredName(), request.conflictBehavior());
        this.execute((Request)sourceRequest, fromProjection.projection);
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
        } else {
            request.setActualLocations(fromProjection.convertToRepository(sourceRequest.getActualLocationBefore()), intoProjection.convertToRepository(sourceRequest.getActualLocationAfter()));
        }
        DeleteBranchRequest cacheRequest = new DeleteBranchRequest(request.into(), fromWorkspace.getCacheProjection().getWorkspaceName());
        this.executeInCache((Request)cacheRequest, fromWorkspace);
    }

    public void process(MoveBranchRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        SingleProjection fromProjection = this.asSingleProjection(workspace, request.from(), (Request)request);
        if (fromProjection == null) {
            return;
        }
        SingleProjection intoProjection = this.asSingleProjection(workspace, request.into(), (Request)request);
        if (intoProjection == null) {
            return;
        }
        if (!intoProjection.projection.equals(fromProjection.projection)) {
            String msg = FederationI18n.unableToPerformOperationUnlessLocationsAreFromSingleProjection.text(new Object[]{request.from(), request.into(), workspace.getName(), fromProjection.projection.getRules(), intoProjection.projection.getRules()});
            request.setError((Throwable)new UnsupportedRequestException(msg));
        }
        Location fromLocation = Location.create((Path)fromProjection.pathInSource);
        Location intoLocation = Location.create((Path)intoProjection.pathInSource);
        String workspaceName = fromProjection.projection.getWorkspaceName();
        MoveBranchRequest sourceRequest = new MoveBranchRequest(fromLocation, intoLocation, workspaceName, request.desiredName(), request.conflictBehavior());
        this.execute((Request)sourceRequest, fromProjection.projection);
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
        } else {
            request.setActualLocations(fromProjection.convertToRepository(sourceRequest.getActualLocationBefore()), intoProjection.convertToRepository(sourceRequest.getActualLocationAfter()));
        }
        DeleteBranchRequest cacheRequest = new DeleteBranchRequest(request.from(), workspace.getCacheProjection().getWorkspaceName());
        this.executeInCache((Request)cacheRequest, workspace);
    }

    public void process(UpdatePropertiesRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        SingleProjection projection = this.asSingleProjection(workspace, request.on(), (Request)request);
        if (projection == null) {
            return;
        }
        Location sourceLocation = Location.create((Path)projection.pathInSource);
        String workspaceName = projection.projection.getWorkspaceName();
        UpdatePropertiesRequest sourceRequest = new UpdatePropertiesRequest(sourceLocation, workspaceName, request.properties());
        this.execute((Request)sourceRequest, projection.projection);
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
        } else {
            request.setActualLocationOfNode(projection.convertToRepository(sourceRequest.getActualLocationOfNode()));
        }
        UpdatePropertiesRequest cacheRequest = new UpdatePropertiesRequest(request.on(), workspace.getCacheProjection().getWorkspaceName(), request.properties());
        this.executeInCache((Request)cacheRequest, workspace);
    }

    public void process(VerifyWorkspaceRequest request) {
        FederatedWorkspace workspace = this.getWorkspace((Request)request, request.workspaceName());
        if (workspace != null) {
            request.setActualWorkspaceName(workspace.getName());
            Location root = Location.create((Path)this.pathFactory.createRootPath());
            ReadNodeRequest nodeInfo = this.getNode(root, workspace);
            if (nodeInfo.hasError()) {
                return;
            }
            request.setActualRootLocation(nodeInfo.getActualLocationOfNode());
        }
    }

    public void process(GetWorkspacesRequest request) {
        request.setAvailableWorkspaceNames(this.workspaces.keySet());
        super.setCacheableInfo((CacheableRequest)request);
    }

    public void process(CreateWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(CloneWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(DestroyWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    protected SingleProjection asSingleProjection(FederatedWorkspace federatedWorkspace, Location location, Request request) {
        ReadNodeRequest nodeInfo = this.getNode(location, federatedWorkspace);
        if (nodeInfo.hasError()) {
            request.setError(nodeInfo.getError());
            return null;
        }
        Location actualLocation = nodeInfo.getActualLocationOfNode();
        Path pathInRepository = actualLocation.getPath();
        assert (pathInRepository != null);
        MergePlan plan = this.getMergePlan(nodeInfo);
        assert (plan != null);
        if (plan.getRealContributionCount() == 1) {
            for (Contribution contribution : plan) {
                if (contribution.isEmpty() || contribution.isPlaceholder()) continue;
                for (Projection projection : federatedWorkspace.getProjectionsFor(contribution.getSourceName())) {
                    Set<Path> paths = projection.getPathsInSource(pathInRepository, this.pathFactory);
                    if (paths.size() != 1) continue;
                    return new SingleProjection(projection, paths.iterator().next(), actualLocation);
                }
            }
        }
        StringBuilder projections = new StringBuilder();
        boolean first = true;
        for (Contribution contribution : plan) {
            if (contribution.isPlaceholder() || contribution.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                projections.append(", ");
            }
            for (Projection projection : federatedWorkspace.getProjectionsFor(contribution.getSourceName())) {
                Set<Path> paths = projection.getPathsInSource(pathInRepository, this.pathFactory);
                if (paths.size() == 1) {
                    projections.append(FederationI18n.pathInProjection.text(new Object[]{paths.iterator().next(), projection.getRules()}));
                    continue;
                }
                projections.append(FederationI18n.pathInProjection.text(new Object[]{paths, projection.getRules()}));
            }
        }
        String msg = FederationI18n.unableToPerformOperationUnlessLocationIsFromSingleProjection.text(new Object[]{location, federatedWorkspace.getName(), projections});
        request.setError((Throwable)new UnsupportedRequestException(msg));
        return null;
    }

    protected void execute(Request request, Projection projection) {
        RepositoryConnection connection = this.getConnection(projection);
        connection.execute(this.getExecutionContext(), request);
    }

    protected void executeInCache(Request request, FederatedWorkspace workspace) {
        RepositoryConnection connection = this.getConnectionToCacheFor(workspace);
        connection.execute(this.getExecutionContext(), request);
    }

    protected ReadNodeRequest getNode(Location location, FederatedWorkspace workspace) throws RepositorySourceException {
        ReadNodeRequest fromCache = new ReadNodeRequest(location, workspace.getCacheProjection().getWorkspaceName());
        this.executeInCache((Request)fromCache, workspace);
        HashSet<String> sourceNames = null;
        LinkedList<Contribution> contributions = new LinkedList<Contribution>();
        if (fromCache.hasError()) {
            Path path;
            Path ancestor;
            Throwable error = fromCache.getError();
            if (!(error instanceof PathNotFoundException)) {
                return fromCache;
            }
            PathNotFoundException notFound = (PathNotFoundException)fromCache.getError();
            Path lowestExistingAncestor = notFound.getLowestAncestorThatDoesExist();
            if (location.hasPath() && !(ancestor = (path = location.getPath()).getParent()).equals(lowestExistingAncestor)) {
                Path pathToLoad = ancestor;
                while (!pathToLoad.equals(lowestExistingAncestor)) {
                    Location locationToLoad = Location.create((Path)pathToLoad);
                    this.loadContributionsFromSources(locationToLoad, workspace, null, contributions);
                    FederatedNode mergedNode = this.createFederatedNode(locationToLoad, workspace, fromCache, contributions, true);
                    if (mergedNode == null) {
                        I18n msg = FederationI18n.nodeDoesNotExistAtPath;
                        fromCache.setError((Throwable)new PathNotFoundException(location, ancestor, msg.text(new Object[]{path, ancestor})));
                        return fromCache;
                    }
                    MergePlan mergePlan = mergedNode.getMergePlan();
                    if (mergePlan != null) {
                        Property mergePlanProperty = this.getExecutionContext().getPropertyFactory().create(DnaLexicon.MERGE_PLAN, new Object[]{mergePlan});
                        fromCache.addProperty(mergePlanProperty);
                    }
                    contributions.clear();
                    pathToLoad = pathToLoad.getParent();
                }
            }
        } else {
            MergePlan mergePlan = this.getMergePlan(fromCache);
            if (mergePlan != null) {
                DateTime now = this.getCurrentTimeInUtc();
                if (!mergePlan.isExpired(now)) {
                    for (Contribution contribution : mergePlan) {
                        if (workspace.contains(contribution.getSourceName(), contribution.getWorkspaceName())) continue;
                    }
                    return fromCache;
                }
                if (mergePlan.getContributionCount() > 0) {
                    sourceNames = new HashSet<String>();
                    for (Contribution contribution : mergePlan) {
                        if (!contribution.isExpired(now)) continue;
                        sourceNames.add(contribution.getSourceName());
                        contributions.add(contribution);
                    }
                }
            }
        }
        if ((location = fromCache.getActualLocationOfNode()) == null) {
            location = fromCache.at();
        }
        this.loadContributionsFromSources(location, workspace, sourceNames, contributions);
        FederatedNode mergedNode = this.createFederatedNode(location, workspace, fromCache, contributions, true);
        if (mergedNode == null) {
            if (location.hasPath()) {
                Path ancestor = location.getPath().getParent();
                I18n msg = FederationI18n.nodeDoesNotExistAtPath;
                fromCache.setError((Throwable)new PathNotFoundException(location, ancestor, msg.text(new Object[]{location, ancestor})));
                return fromCache;
            }
            I18n msg = FederationI18n.nodeDoesNotExistAtLocation;
            fromCache.setError((Throwable)new PathNotFoundException(location, null, msg.text(new Object[]{location})));
            return fromCache;
        }
        return mergedNode;
    }

    protected FederatedNode createFederatedNode(Location location, FederatedWorkspace federatedWorkspace, ReadNodeRequest fromCache, List<Contribution> contributions, boolean updateCache) throws RepositorySourceException {
        assert (location != null);
        boolean foundNonEmptyContribution = false;
        for (Contribution contribution : contributions) {
            assert (contribution != null);
            if (contribution.isEmpty()) continue;
            foundNonEmptyContribution = true;
            break;
        }
        if (!foundNonEmptyContribution) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Loaded {0} from sources, resulting in these contributions:", new Object[]{location});
            int i = 0;
            for (Contribution contribution : contributions) {
                this.logger.trace("  {0} {1}", new Object[]{++i, contribution});
            }
        }
        ExecutionContext context = this.getExecutionContext();
        assert (context != null);
        FederatedNode mergedNode = new FederatedNode(location, federatedWorkspace.getName());
        assert (contributions.size() > 0);
        federatedWorkspace.getMergingStrategy().merge(mergedNode, contributions, context);
        if (mergedNode.getCachePolicy() == null) {
            mergedNode.setCachePolicy(federatedWorkspace.getCachePolicy());
        }
        if (updateCache) {
            this.updateCache(federatedWorkspace, mergedNode, fromCache);
        }
        return mergedNode;
    }

    protected void loadContributionsFromSources(Location location, FederatedWorkspace federatedWorkspace, Set<String> sourceNames, List<Contribution> contributions) throws RepositorySourceException {
        ExecutionContext context = this.getExecutionContext();
        CachePolicy cachePolicy = federatedWorkspace.getCachePolicy();
        if (!location.hasPath()) {
            for (Projection projection : federatedWorkspace.getSourceProjections()) {
                CachePolicy requestCachePolicy;
                RepositoryConnection sourceConnection;
                String source = projection.getSourceName();
                String workspace = projection.getSourceName();
                if (sourceNames != null && !sourceNames.contains(source) || (sourceConnection = this.getConnection(projection)) == null) continue;
                ReadNodeRequest request = new ReadNodeRequest(location, federatedWorkspace.getName());
                sourceConnection.execute(context, (Request)request);
                if (request.hasError()) continue;
                long minimumTimeToLive = Long.MAX_VALUE;
                if (cachePolicy != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, cachePolicy.getTimeToLive());
                }
                if ((requestCachePolicy = request.getCachePolicy()) != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, requestCachePolicy.getTimeToLive());
                } else {
                    CachePolicy sourceCachePolicy = sourceConnection.getDefaultCachePolicy();
                    if (sourceCachePolicy != null) {
                        minimumTimeToLive = Math.min(minimumTimeToLive, sourceCachePolicy.getTimeToLive());
                    }
                }
                DateTime expirationTime = null;
                if (minimumTimeToLive < Long.MAX_VALUE) {
                    expirationTime = this.getCurrentTimeInUtc().plus(minimumTimeToLive, TimeUnit.MILLISECONDS);
                }
                Contribution contribution = Contribution.create(source, workspace, request.getActualLocationOfNode(), expirationTime, request.getProperties(), request.getChildren());
                contributions.add(contribution);
            }
        }
        Path path = location.getPath();
        for (Projection projection : federatedWorkspace.getSourceProjections()) {
            Set<Path> pathsInSource;
            RepositoryConnection sourceConnection;
            String source = projection.getSourceName();
            String workspace = projection.getWorkspaceName();
            if (sourceNames != null && !sourceNames.contains(source) || (sourceConnection = this.getConnection(projection)) == null) continue;
            DateTime expirationTime = null;
            if (cachePolicy != null) {
                expirationTime = this.getCurrentTimeInUtc().plus(cachePolicy.getTimeToLive(), TimeUnit.MILLISECONDS);
            }
            if ((pathsInSource = projection.getPathsInSource(path, this.pathFactory)).isEmpty()) {
                Contribution contribution = null;
                List<Path> topLevelPaths = projection.getTopLevelPathsInRepository(this.pathFactory);
                Location input = Location.create((Path)path);
                switch (topLevelPaths.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Path topLevelPath = topLevelPaths.iterator().next();
                        if (!path.isAncestorOf(topLevelPath)) break;
                        Location location2 = Location.create((Path)topLevelPath);
                        contribution = Contribution.createPlaceholder(source, workspace, input, expirationTime, location2);
                        break;
                    }
                    default: {
                        ArrayList<Location> children = new ArrayList<Location>(topLevelPaths.size());
                        for (Path topLevelPath : topLevelPaths) {
                            if (!path.isAncestorOf(topLevelPath)) continue;
                            children.add(Location.create((Path)topLevelPath));
                        }
                        if (children.size() <= 0) break;
                        contribution = Contribution.createPlaceholder(source, workspace, input, expirationTime, children);
                    }
                }
                if (contribution == null) {
                    contribution = Contribution.create(source, workspace, expirationTime);
                }
                contributions.add(contribution);
                continue;
            }
            int numPaths = pathsInSource.size();
            if (numPaths == 1) {
                CachePolicy requestCachePolicy;
                Path pathInSource = pathsInSource.iterator().next();
                ReadNodeRequest fromSource = new ReadNodeRequest(Location.create((Path)pathInSource), workspace);
                sourceConnection.execute(this.getExecutionContext(), (Request)fromSource);
                if (fromSource.hasError()) continue;
                Collection properties = fromSource.getProperties();
                List list = fromSource.getChildren();
                long minimumTimeToLive = Long.MAX_VALUE;
                if (cachePolicy != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, cachePolicy.getTimeToLive());
                }
                if ((requestCachePolicy = fromSource.getCachePolicy()) != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, requestCachePolicy.getTimeToLive());
                } else {
                    CachePolicy sourceCachePolicy = sourceConnection.getDefaultCachePolicy();
                    if (sourceCachePolicy != null) {
                        minimumTimeToLive = Math.min(minimumTimeToLive, sourceCachePolicy.getTimeToLive());
                    }
                }
                expirationTime = null;
                if (minimumTimeToLive < Long.MAX_VALUE) {
                    expirationTime = this.getCurrentTimeInUtc().plus(minimumTimeToLive, TimeUnit.MILLISECONDS);
                }
                Location actualLocation = fromSource.getActualLocationOfNode();
                Contribution contribution = Contribution.create(source, workspace, actualLocation, expirationTime, properties, list);
                contributions.add(contribution);
                continue;
            }
            ArrayList<ReadNodeRequest> fromSourceCommands = new ArrayList<ReadNodeRequest>(numPaths);
            for (Path pathInSource : pathsInSource) {
                fromSourceCommands.add(new ReadNodeRequest(Location.create((Path)pathInSource), workspace));
            }
            Request request = CompositeRequest.with(fromSourceCommands);
            sourceConnection.execute(context, request);
            for (Request request2 : fromSourceCommands) {
                CachePolicy requestCachePolicy;
                ReadNodeRequest fromSource = (ReadNodeRequest)request2;
                if (fromSource.hasError()) continue;
                long minimumTimeToLive = Long.MAX_VALUE;
                if (cachePolicy != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, cachePolicy.getTimeToLive());
                }
                if ((requestCachePolicy = fromSource.getCachePolicy()) != null) {
                    minimumTimeToLive = Math.min(minimumTimeToLive, requestCachePolicy.getTimeToLive());
                } else {
                    CachePolicy sourceCachePolicy = sourceConnection.getDefaultCachePolicy();
                    if (sourceCachePolicy != null) {
                        minimumTimeToLive = Math.min(minimumTimeToLive, sourceCachePolicy.getTimeToLive());
                    }
                }
                expirationTime = null;
                if (minimumTimeToLive < Long.MAX_VALUE) {
                    expirationTime = this.getCurrentTimeInUtc().plus(minimumTimeToLive, TimeUnit.MILLISECONDS);
                }
                List children = fromSource.getChildren();
                Contribution contribution = Contribution.create(source, workspace, fromSource.getActualLocationOfNode(), expirationTime, fromSource.getProperties(), children);
                contributions.add(contribution);
            }
        }
    }

    protected MergePlan getMergePlan(ReadNodeRequest request) {
        Property mergePlanProperty = (Property)request.getPropertiesByName().get(DnaLexicon.MERGE_PLAN);
        if (mergePlanProperty == null || mergePlanProperty.isEmpty()) {
            return null;
        }
        Object value = mergePlanProperty.getValues().next();
        return value instanceof MergePlan ? (MergePlan)value : null;
    }

    protected void updateCache(FederatedWorkspace federatedWorkspace, FederatedNode mergedNode, ReadNodeRequest fromCache) throws RepositorySourceException {
        Location parentLocation;
        ExecutionContext context = this.getExecutionContext();
        Location location = mergedNode.at();
        Path path = location.getPath();
        String cacheWorkspace = federatedWorkspace.getCacheProjection().getWorkspaceName();
        assert (path != null);
        ArrayList<Object> requests = new ArrayList<Object>();
        Name childName = null;
        Map properties = mergedNode.getPropertiesByName();
        MergePlan mergePlan = mergedNode.getMergePlan();
        if (mergePlan != null && !properties.containsKey(DnaLexicon.MERGE_PLAN)) {
            Property mergePlanProperty = this.getExecutionContext().getPropertyFactory().create(DnaLexicon.MERGE_PLAN, new Object[]{mergePlan});
            properties.put(mergePlanProperty.getName(), mergePlanProperty);
        }
        PropertyFactory propertyFactory = this.getExecutionContext().getPropertyFactory();
        Property uuidProperty = (Property)properties.get(DnaLexicon.UUID);
        if (uuidProperty == null) {
            uuidProperty = (Property)properties.get(JcrLexicon.UUID);
        }
        if (uuidProperty == null) {
            UUID uuid = mergedNode.at().getUuid();
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            uuidProperty = propertyFactory.create(DnaLexicon.UUID, new Object[]{uuid});
            properties.put(uuidProperty.getName(), uuidProperty);
        }
        if (mergedNode.hasError() && !path.isRoot()) {
            parentLocation = Location.create((Path)path.getParent());
            childName = path.getLastSegment().getName();
            requests.add(new CreateNodeRequest(parentLocation, cacheWorkspace, childName, NodeConflictBehavior.REPLACE, (Iterable)mergedNode.getProperties()));
            for (Location child : mergedNode.getChildren()) {
                childName = child.getPath().getLastSegment().getName();
                requests.add(new CreateNodeRequest(location, cacheWorkspace, childName, NodeConflictBehavior.APPEND, (Iterable)child));
            }
        } else if (((Object)fromCache.getChildren()).equals(mergedNode.getChildren())) {
            requests.add(new UpdatePropertiesRequest(location, cacheWorkspace, properties));
        } else if (fromCache.getChildren().isEmpty()) {
            requests.add(new UpdatePropertiesRequest(location, cacheWorkspace, properties));
            for (Location child : mergedNode.getChildren()) {
                childName = child.getPath().getLastSegment().getName();
                requests.add(new CreateNodeRequest(location, cacheWorkspace, childName, NodeConflictBehavior.APPEND, (Iterable)child));
            }
        } else if (mergedNode.getChildren().isEmpty()) {
            requests.add(new UpdatePropertiesRequest(location, cacheWorkspace, properties));
            for (Location child : fromCache.getChildren()) {
                requests.add(new DeleteBranchRequest(child, cacheWorkspace));
            }
        } else if (path.isRoot()) {
            requests.add(new UpdatePropertiesRequest(location, cacheWorkspace, properties));
            for (Location child : fromCache.getChildren()) {
                requests.add(new DeleteBranchRequest(child, cacheWorkspace));
            }
            for (Location child : mergedNode.getChildren()) {
                childName = child.getPath().getLastSegment().getName();
                requests.add(new CreateNodeRequest(location, cacheWorkspace, childName, NodeConflictBehavior.APPEND, (Iterable)child));
            }
        } else {
            requests.add(new DeleteBranchRequest(location, cacheWorkspace));
            parentLocation = Location.create((Path)path.getParent());
            childName = path.getLastSegment().getName();
            requests.add(new CreateNodeRequest(parentLocation, cacheWorkspace, childName, NodeConflictBehavior.REPLACE, (Iterable)mergedNode.getProperties()));
            for (Location child : mergedNode.getChildren()) {
                childName = child.getPath().getLastSegment().getName();
                requests.add(new CreateNodeRequest(location, cacheWorkspace, childName, NodeConflictBehavior.APPEND, (Iterable)child));
            }
        }
        RepositoryConnection cacheConnection = this.getConnectionToCacheFor(federatedWorkspace);
        cacheConnection.execute(context, CompositeRequest.with(requests));
        if (requests.size() > 1) {
            Iterator requestIter = requests.iterator();
            requestIter.next();
            List children = mergedNode.getChildren();
            for (int i = 0; i != children.size(); ++i) {
                Request request = (Request)requestIter.next();
                while (!(request instanceof CreateNodeRequest)) {
                    request = (Request)requestIter.next();
                }
                Location actual = ((CreateNodeRequest)request).getActualLocationOfNode();
                Location child = (Location)children.get(i);
                if (child.hasIdProperties()) continue;
                assert (child.getPath().equals(actual.getPath()));
                children.set(i, actual);
            }
        }
    }

    @Immutable
    protected class SingleProjection {
        protected final Projection projection;
        protected final Path pathInSource;
        protected final Location federatedLocation;

        protected SingleProjection(Projection projection, Path pathInSource, Location federatedLocation) {
            this.projection = projection;
            this.federatedLocation = federatedLocation;
            this.pathInSource = pathInSource;
        }

        protected Location convertToRepository(Location sourceLocation) {
            assert (sourceLocation != null);
            if (sourceLocation.hasPath()) {
                Set<Path> paths = this.projection.getPathsInRepository(sourceLocation.getPath(), FederatingRequestProcessor.this.pathFactory);
                assert (paths.size() == 1);
                return sourceLocation.with(paths.iterator().next());
            }
            return sourceLocation;
        }
    }
}

