/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.NonEmptyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MultiPropertyContribution
extends NonEmptyContribution {
    private static final long serialVersionUID = 1L;
    protected final Map<Name, Property> properties;

    public MultiPropertyContribution(String sourceName, String workspaceName, Location locationInSource, DateTime expirationTime, Iterable<Property> properties) {
        super(sourceName, workspaceName, locationInSource, expirationTime);
        assert (properties != null);
        this.properties = new HashMap<Name, Property>();
        for (Property property : properties) {
            if (property == null) continue;
            this.properties.put(property.getName(), property);
        }
        assert (!this.properties.isEmpty());
    }

    @Override
    public Iterator<Property> getProperties() {
        return new Contribution.ImmutableIterator<Property>(this.properties.values().iterator());
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public Property getProperty(Name name) {
        return this.properties.get(name);
    }
}

