/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.contribution;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.contribution.NonEmptyContribution;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class OnePropertyContribution
extends NonEmptyContribution {
    private static final long serialVersionUID = 1L;
    private final Property property;

    public OnePropertyContribution(String sourceName, String workspaceName, Location locationInSource, DateTime expirationTime, Property property) {
        super(sourceName, workspaceName, locationInSource, expirationTime);
        assert (property != null);
        assert (!property.isEmpty());
        this.property = property;
    }

    @Override
    public Iterator<Property> getProperties() {
        return new Contribution.OneValueIterator<Property>(this.property);
    }

    @Override
    public int getPropertyCount() {
        return 1;
    }

    @Override
    public Property getProperty(Name name) {
        return this.property.getName().equals(name) ? this.property : null;
    }
}

