/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.MergePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MultipleContributionMergePlan
extends MergePlan {
    private static final long serialVersionUID = 1L;
    private final List<Contribution> contributions = new CopyOnWriteArrayList<Contribution>();

    MultipleContributionMergePlan(Contribution ... contributions) {
        assert (contributions != null);
        for (int i = 0; i != contributions.length; ++i) {
            assert (contributions[i] != null);
            this.contributions.add(contributions[i]);
        }
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    MultipleContributionMergePlan(Iterable<Contribution> contributions) {
        assert (contributions != null);
        for (Contribution contribution : contributions) {
            assert (contribution != null);
            this.contributions.add(contribution);
        }
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    MultipleContributionMergePlan(Iterator<Contribution> contributions) {
        assert (contributions != null);
        while (contributions.hasNext()) {
            Contribution contribution = contributions.next();
            assert (contribution != null);
            this.contributions.add(contribution);
        }
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    @Override
    public int getContributionCount() {
        return this.contributions.size();
    }

    @Override
    public Contribution getContributionFrom(String sourceName) {
        for (Contribution contribution : this.contributions) {
            if (!contribution.getSourceName().equals(sourceName)) continue;
            return contribution;
        }
        return null;
    }

    @Override
    public Iterator<Contribution> iterator() {
        final Iterator<Contribution> iterator = this.contributions.iterator();
        return new Iterator<Contribution>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Contribution next() {
                return (Contribution)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSource(String sourceName) {
        for (Contribution contribution : this.contributions) {
            if (!contribution.getSourceName().equals(sourceName)) continue;
            return true;
        }
        return false;
    }

    public void addContribution(Contribution contribution) {
        this.contributions.add(contribution);
    }

    public int hashCode() {
        return ((Object)this.contributions).hashCode();
    }
}

