/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.federation.merge;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.connector.federation.contribution.Contribution;
import org.jboss.dna.connector.federation.merge.MergePlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TwoContributionMergePlan
extends MergePlan {
    private static final long serialVersionUID = 1L;
    private final Contribution contribution1;
    private final Contribution contribution2;

    TwoContributionMergePlan(Contribution contribution1, Contribution contribution2) {
        assert (contribution1 != null);
        assert (contribution2 != null);
        this.contribution1 = contribution1;
        this.contribution2 = contribution2;
        assert (this.checkEachContributionIsFromDistinctSource());
    }

    @Override
    public int getContributionCount() {
        return 2;
    }

    @Override
    public Contribution getContributionFrom(String sourceName) {
        if (this.contribution1.getSourceName().equals(sourceName)) {
            return this.contribution1;
        }
        if (this.contribution2.getSourceName().equals(sourceName)) {
            return this.contribution2;
        }
        return null;
    }

    @Override
    public Iterator<Contribution> iterator() {
        return new Iterator<Contribution>(){
            private int next = 2;

            @Override
            public boolean hasNext() {
                return this.next > 0;
            }

            @Override
            public Contribution next() {
                if (this.next == 2) {
                    this.next = 1;
                    return TwoContributionMergePlan.this.contribution1;
                }
                if (this.next == 1) {
                    this.next = 0;
                    return TwoContributionMergePlan.this.contribution2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSource(String sourceName) {
        return this.contribution1.getSourceName().equals(sourceName) || this.contribution2.getSourceName().equals(sourceName);
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.contribution1, this.contribution2});
    }
}

